/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class EagerObjectCreator
extends BeanDefinitionCreator {
    private final ImmutableSet<Class<?>> earlyCreationObjectTypes = ImmutableSet.builder().add(ObjectProvider.class).build();

    EagerObjectCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        final SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        Class<?> type = componentModel.getType();
        if (type == null) {
            return false;
        }
        Optional<Class> foundClass = this.earlyCreationObjectTypes.stream().filter(clazz -> clazz.isAssignableFrom(type)).findAny();
        return foundClass.map(clazz -> {
            Object instance;
            ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
            try {
                instance = type.newInstance();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create an instance of '%s' using default constructor. Early created object must have a default constructor", type.getName()));
            }
            componentBuildingDefinition.getSetterParameterDefinitions().forEach(attributeDefinition -> {
                final SetterAttributeDefinition setterAttributeDefinition = (SetterAttributeDefinition)attributeDefinition;
                setterAttributeDefinition.getAttributeDefinition().accept(new AbstractAttributeDefinitionVisitor(){

                    @Override
                    public void onUndefinedSimpleParameters() {
                        Map<String, String> parameters = componentModel.getRawParameters();
                        String attributeName = setterAttributeDefinition.getAttributeName();
                        try {
                            BeanUtils.setProperty((Object)instance, (String)attributeName, parameters);
                        }
                        catch (Exception e) {
                            throw new MuleRuntimeException(e);
                        }
                    }

                    @Override
                    protected void doOnOperation(String operation) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Attribute definition with operation '%s' is not supported for earlyCreationObjects", operation)));
                    }
                });
            });
            componentModel.setObjectInstance(instance);
            componentModel.setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ConstantFactoryBean.class).addConstructorArgValue(instance).getBeanDefinition());
            return true;
        }).orElse(false);
    }
}

