/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public abstract class AbstractProcessorRouteFactoryBean<T>
extends AbstractComponentFactory<T> {
    @Inject
    private MuleContext muleContext;
    @Inject
    protected ConfigurationComponentLocator locator;
    private List<Processor> messageProcessors;

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public T doGetObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (Processor processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessors or MessageProcessorBuilders configured");
        }
        MessageProcessorChain chain = DefaultMessageProcessorChainBuilder.newLazyProcessorChainBuilder(builder, this.muleContext, () -> MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()).orElse(null));
        return this.getProcessorRoute(chain);
    }

    protected abstract T getProcessorRoute(MessageProcessorChain var1);
}

