/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.model.DefaultComponentParameterAst;
import org.mule.runtime.config.internal.model.MetadataTypeModelAdapter;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public abstract class ComponentModel {
    public static String COMPONENT_MODEL_KEY = "ComponentModel";
    private boolean root = false;
    private ComponentIdentifier identifier;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Set<String> schemaValueParameter = new HashSet<String>();
    private ComponentModel parent;
    private final List<ComponentModel> innerComponents = new ArrayList<ComponentModel>();
    private String textContent;
    private DefaultComponentLocation componentLocation;
    private TypedComponentIdentifier.ComponentType componentType;
    private org.mule.runtime.api.meta.model.ComponentModel componentModel;
    private NestableElementModel nestableElementModel;
    private ConfigurationModel configurationModel;
    private ConnectionProviderModel connectionProviderModel;
    private MetadataTypeModelAdapter metadataTypeModelAdapter;
    private ComponentMetadataAst componentMetadata;
    private Object objectInstance;
    private Class<?> type;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Deprecated
    public Optional<Integer> getLineNumber() {
        return this.componentMetadata.getStartLine().isPresent() ? Optional.of(this.componentMetadata.getStartLine().getAsInt()) : Optional.empty();
    }

    @Deprecated
    public Optional<Integer> getStartColumn() {
        return this.componentMetadata.getStartColumn().isPresent() ? Optional.of(this.componentMetadata.getStartColumn().getAsInt()) : Optional.empty();
    }

    @Deprecated
    public Optional<String> getConfigFileName() {
        return this.componentMetadata.getFileName();
    }

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getRawParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<ComponentModel> getInnerComponents() {
        return this.innerComponents;
    }

    @Deprecated
    public Map<String, Object> getCustomAttributes() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.putAll(this.componentMetadata.getParserAttributes());
        this.componentMetadata.getDocAttributes().forEach((k, v) -> attrs.put("{http://www.mulesoft.org/schema/mule/documentation}" + k, v));
        return attrs;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setParameter(ParameterModel parameterModel, ComponentParameterAst value) {
        this.parameters.put(parameterModel.getName(), value.getRawValue());
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setComponentType(TypedComponentIdentifier.ComponentType componentType) {
        this.componentType = componentType;
    }

    public TypedComponentIdentifier.ComponentType getComponentType() {
        return this.componentType != null ? this.componentType : TypedComponentIdentifier.ComponentType.UNKNOWN;
    }

    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (this.componentModel != null && modelClass.isAssignableFrom(this.componentModel.getClass())) {
            return Optional.of(this.componentModel);
        }
        if (this.configurationModel != null && modelClass.isAssignableFrom(this.configurationModel.getClass())) {
            return Optional.of(this.configurationModel);
        }
        if (this.connectionProviderModel != null && modelClass.isAssignableFrom(this.connectionProviderModel.getClass())) {
            return Optional.of(this.connectionProviderModel);
        }
        if (this.nestableElementModel != null && modelClass.isAssignableFrom(this.nestableElementModel.getClass())) {
            return Optional.of(this.nestableElementModel);
        }
        if (this.metadataTypeModelAdapter != null && modelClass.isAssignableFrom(this.metadataTypeModelAdapter.getClass())) {
            return Optional.of(this.metadataTypeModelAdapter);
        }
        return Optional.empty();
    }

    public void resolveTypedComponentIdentifier(ExtensionModelHelper extensionModelHelper, boolean runtimeMode) {
        this.executeOnComponentTree(this, componentModel -> componentModel.doResolveTypedComponentIdentifier(extensionModelHelper, runtimeMode));
    }

    private void doResolveTypedComponentIdentifier(final ExtensionModelHelper extensionModelHelper, final boolean runtimeMode) {
        extensionModelHelper.walkToComponent(this.getIdentifier(), new ExtensionModelHelper.ExtensionWalkerModelDelegate(){

            @Override
            public void onConfiguration(ConfigurationModel model) {
                ComponentModel.this.setConfigurationModel(model);
                this.onParameterizedModel(model);
            }

            @Override
            public void onConnectionProvider(ConnectionProviderModel model) {
                ComponentModel.this.setConnectionProviderModel(model);
                this.onParameterizedModel(model);
            }

            @Override
            public void onOperation(OperationModel model) {
                ComponentModel.this.setComponentModel(model);
                this.onParameterizedModel(model);
            }

            @Override
            public void onSource(SourceModel model) {
                ComponentModel.this.setComponentModel(model);
                this.onParameterizedModel(model);
            }

            @Override
            public void onConstruct(ConstructModel model) {
                ComponentModel.this.setComponentModel(model);
                this.onParameterizedModel(model);
            }

            @Override
            public void onNestableElement(NestableElementModel model) {
                ComponentModel.this.setNestableElementModel(model);
                if (model instanceof ParameterizedModel) {
                    this.onParameterizedModel((ParameterizedModel)((Object)model));
                }
            }

            private void onParameterizedModel(ParameterizedModel model) {
                if (runtimeMode) {
                    ComponentModel.this.handleNestedParametersWithoutPopulatingObjectTypes(ComponentModel.this, extensionModelHelper, model);
                } else {
                    DslElementSyntax elementDsl = extensionModelHelper.resolveDslElementModel(model, ComponentModel.this.getIdentifier());
                    this.onParameterizedModel(elementDsl, model, parameterModel -> true);
                }
            }

            private void onParameterizedModel(DslElementSyntax elementDsl, ParameterizedModel model, Predicate<ParameterModel> parameterModelFilter) {
                Multimap nestedComponents = ComponentModel.this.getNestedComponents(ComponentModel.this);
                List inlineGroupedParameters = model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).map(group -> ComponentModel.this.addInlineGroup(elementDsl, (Multimap<ComponentIdentifier, ComponentModel>)nestedComponents, group, extensionModelHelper)).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
                ComponentModel.this.handleNestedParameters(ComponentModel.this, ((ComponentAst)((Object)ComponentModel.this)).directChildrenStream().filter(childComp -> childComp != ComponentModel.this), (Multimap<ComponentIdentifier, ComponentModel>)nestedComponents, extensionModelHelper, model, parameterModel -> parameterModelFilter.test((ParameterModel)parameterModel) && !inlineGroupedParameters.contains(parameterModel));
            }
        });
        if (!this.getModel(HasStereotypeModel.class).isPresent()) {
            extensionModelHelper.findMetadataType(this.getType()).flatMap(type -> MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithSterotype(type, extensionModelHelper)).ifPresent(this::setMetadataTypeModelAdapter);
        }
        this.setComponentType(ComponentModelHelper.resolveComponentType((ComponentAst)((Object)this), extensionModelHelper));
    }

    private ParameterGroupModel addInlineGroup(DslElementSyntax elementDsl, Multimap<ComponentIdentifier, ComponentModel> nestedComponents, final ParameterGroupModel group, ExtensionModelHelper extensionModelHelper) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            Optional<ComponentIdentifier> groupIdentifier = this.getIdentifier((DslElementSyntax)groupDsl);
            if (!groupIdentifier.isPresent()) {
                return;
            }
            ComponentModel groupComponent = this.getSingleComponentModel(nestedComponents, groupIdentifier);
            if (groupComponent != null) {
                this.handleNestedParameters(this, ((ComponentAst)((Object)groupComponent)).directChildrenStream().filter(childComp -> childComp != groupComponent), this.getNestedComponents(groupComponent), extensionModelHelper, new ParameterizedModel(){

                    @Override
                    public List<ParameterGroupModel> getParameterGroupModels() {
                        return Lists.newArrayList((Object[])new ParameterGroupModel[]{group});
                    }

                    @Override
                    public String getDescription() {
                        return group.getDescription();
                    }

                    @Override
                    public String getName() {
                        return group.getName();
                    }
                }, parameterModel -> true);
            }
        });
        return group;
    }

    private void handleNestedParameters(ComponentModel componentModel, Stream<ComponentAst> childrenComponentModels, Multimap<ComponentIdentifier, ComponentModel> nestedComponents, ExtensionModelHelper extensionModelHelper, ParameterizedModel model, Predicate<ParameterModel> parameterModelFilter) {
        childrenComponentModels.forEach(childComp -> extensionModelHelper.findParameterModel(childComp.getIdentifier(), model).filter(parameterModelFilter::test).filter(paramModel -> {
            if (model instanceof SourceModel) {
                return ((SourceModel)model).getSuccessCallback().map(sc -> sc.getAllParameterModels().contains(paramModel)).orElse(false) == false && ((SourceModel)model).getErrorCallback().map(ec -> ec.getAllParameterModels().contains(paramModel)).orElse(false) == false;
            }
            return true;
        }).filter(paramModel -> paramModel.getDslConfiguration().allowsInlineDefinition()).ifPresent(paramModel -> {
            if (paramModel.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED || childComp.directChildrenStream().findFirst().isPresent()) {
                componentModel.enrichComponentModels(componentModel, nestedComponents, Optional.of(extensionModelHelper.resolveDslElementModel((ParameterModel)paramModel, componentModel.getIdentifier())), (ParameterModel)paramModel, extensionModelHelper);
            } else {
                componentModel.setParameter((ParameterModel)paramModel, new DefaultComponentParameterAst(org.mule.runtime.core.api.util.StringUtils.trim(((ComponentModel)((Object)childComp)).getTextContent()), () -> paramModel, childComp.getMetadata()));
            }
        }));
    }

    private void handleNestedParametersWithoutPopulatingObjectTypes(ComponentModel componentModel, ExtensionModelHelper extensionModelHelper, ParameterizedModel model) {
        ((ComponentAst)((Object)componentModel)).recursiveStream().forEach(childComp -> extensionModelHelper.findParameterModel(childComp.getIdentifier(), model).filter(paramModel -> {
            if (model instanceof SourceModel) {
                return ((SourceModel)model).getSuccessCallback().map(sc -> sc.getAllParameterModels().contains(paramModel)).orElse(false) == false && ((SourceModel)model).getErrorCallback().map(ec -> ec.getAllParameterModels().contains(paramModel)).orElse(false) == false;
            }
            return true;
        }).filter(paramModel -> paramModel.getDslConfiguration().allowsInlineDefinition()).ifPresent(paramModel -> {
            if (paramModel.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED) {
                this.setParameter((ParameterModel)paramModel, new DefaultComponentParameterAst(childComp, () -> paramModel, childComp.getMetadata()));
                ((ComponentModel)((Object)childComp)).setMetadataTypeModelAdapter(MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(paramModel.getType(), extensionModelHelper));
            } else {
                componentModel.setParameter((ParameterModel)paramModel, new DefaultComponentParameterAst(org.mule.runtime.core.api.util.StringUtils.trim(((ComponentModel)((Object)childComp)).getTextContent()), () -> paramModel, childComp.getMetadata()));
            }
        }));
    }

    private Multimap<ComponentIdentifier, ComponentModel> getNestedComponents(ComponentModel componentModel) {
        ArrayListMultimap result = ArrayListMultimap.create();
        componentModel.getInnerComponents().forEach(arg_0 -> ComponentModel.lambda$getNestedComponents$21((Multimap)result, arg_0));
        return result;
    }

    private ComponentModel getSingleComponentModel(Multimap<ComponentIdentifier, ComponentModel> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(arg_0 -> innerComponents.containsKey(arg_0)).map(arg_0 -> innerComponents.get(arg_0)).map(collection -> (ComponentModel)collection.iterator().next()).orElse(null);
    }

    private void enrichComponentModels(ComponentModel componentModel, Multimap<ComponentIdentifier, ComponentModel> innerComponents, Optional<DslElementSyntax> optionalParamDsl, ParameterModel paramModel, ExtensionModelHelper extensionModelHelper) {
        optionalParamDsl.ifPresent(paramDsl -> {
            ComponentModel paramComponent;
            if (paramDsl.isWrapped()) {
                if (!(paramModel.getType() instanceof ObjectType)) {
                    return;
                }
                this.handleWrappedElement(componentModel, innerComponents, paramModel, extensionModelHelper, (DslElementSyntax)paramDsl);
            }
            if ((paramComponent = this.getSingleComponentModel(innerComponents, this.getIdentifier((DslElementSyntax)paramDsl))) != null) {
                paramModel.getType().accept(this.getComponentChildVisitor(componentModel, paramModel, (DslElementSyntax)paramDsl, paramComponent, extensionModelHelper));
            } else {
                this.setSimpleParameterValue(componentModel, paramModel, (DslElementSyntax)paramDsl);
            }
        });
    }

    private void handleWrappedElement(ComponentModel componentModel, Multimap<ComponentIdentifier, ComponentModel> innerComponents, ParameterModel paramModel, ExtensionModelHelper extensionModelHelper, DslElementSyntax paramDsl) {
        ComponentModel wrappedComponent = this.getSingleComponentModel(innerComponents, this.getIdentifier(paramDsl));
        if (wrappedComponent != null) {
            Multimap<ComponentIdentifier, ComponentModel> nestedWrappedComponents = this.getNestedComponents(wrappedComponent);
            Map<ObjectType, Optional<DslElementSyntax>> objectTypeOptionalMap = extensionModelHelper.resolveSubTypes((ObjectType)paramModel.getType());
            objectTypeOptionalMap.entrySet().stream().filter(entry -> {
                if (((Optional)entry.getValue()).isPresent()) {
                    return this.getSingleComponentModel(nestedWrappedComponents, this.getIdentifier((DslElementSyntax)((Optional)entry.getValue()).get())) != null;
                }
                return false;
            }).findFirst().ifPresent(wrappedEntryType -> {
                DslElementSyntax wrappedDsl = (DslElementSyntax)((Optional)wrappedEntryType.getValue()).get();
                ((ObjectType)wrappedEntryType.getKey()).accept(this.getComponentChildVisitor(componentModel, paramModel, wrappedDsl, this.getSingleComponentModel(nestedWrappedComponents, this.getIdentifier(wrappedDsl)), extensionModelHelper));
            });
        }
    }

    private void setSimpleParameterValue(ComponentModel componentModel, ParameterModel paramModel, DslElementSyntax paramDsl) {
        String value;
        String string = value = paramDsl.supportsAttributeDeclaration() ? componentModel.getRawParameters().get(paramModel.getName()) : null;
        if (StringUtils.isNotBlank(value)) {
            componentModel.setParameter(paramModel, new DefaultComponentParameterAst(value.trim(), () -> paramModel, componentModel.getMetadata()));
        } else {
            paramModel.getLayoutModel().ifPresent(layoutModel -> {
                if (layoutModel.isText() && StringUtils.isNotBlank((CharSequence)componentModel.getTextContent())) {
                    componentModel.setParameter(paramModel, new DefaultComponentParameterAst(componentModel.getTextContent().trim(), () -> paramModel, componentModel.getMetadata()));
                }
            });
        }
    }

    private MetadataTypeVisitor getComponentChildVisitor(final ComponentModel componentModel, final ParameterModel paramModel, final DslElementSyntax paramDsl, final ComponentModel paramComponent, final ExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                MetadataType itemType = arrayType.getType();
                itemType.accept(ComponentModel.this.getArrayItemTypeVisitor(componentModel, paramModel, paramDsl, paramComponent, extensionModelHelper));
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    List<ComponentModel> componentModels = this.handleMap(objectType);
                    componentModel.setParameter(paramModel, new DefaultComponentParameterAst(componentModels, () -> paramModel, paramComponent.getMetadata()));
                    return;
                }
                componentModel.setParameter(paramModel, new DefaultComponentParameterAst(paramComponent, () -> paramModel, paramComponent.getMetadata()));
                MetadataTypeModelAdapter parameterizedModel = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(objectType, extensionModelHelper);
                paramComponent.setMetadataTypeModelAdapter(parameterizedModel);
                parameterizedModel.getAllParameterModels().stream().forEach(nestedParameter -> ComponentModel.this.enrichComponentModels(paramComponent, (Multimap<ComponentIdentifier, ComponentModel>)ComponentModel.this.getNestedComponents(paramComponent), paramDsl.getContainedElement(nestedParameter.getName()), nestedParameter, extensionModelHelper));
            }

            private List<ComponentModel> handleMap(ObjectType objectType) {
                return paramComponent.getInnerComponents().stream().filter(entryComponent -> {
                    MetadataType entryType = objectType.getOpenRestriction().get();
                    Optional<DslElementSyntax> entryValueDslOptional = paramDsl.getGeneric(entryType);
                    if (entryValueDslOptional.isPresent()) {
                        DslElementSyntax entryValueDsl = entryValueDslOptional.get();
                        ImmutableParameterModel keyParamModel = new ImmutableParameterModel("key", "", ComponentModel.this.typeLoader.load((Type)((Object)String.class)), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                        String key = entryComponent.getRawParameters().get("key");
                        entryComponent.setParameter(keyParamModel, new DefaultComponentParameterAst(key, () -> keyParamModel, entryComponent.getMetadata()));
                        String value = entryComponent.getRawParameters().get("value");
                        ImmutableParameterModel valueParamModel = new ImmutableParameterModel("value", "", entryType, false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                        if (StringUtils.isBlank((CharSequence)value)) {
                            Optional<DslElementSyntax> genericValueDslOptional = entryValueDsl.getGeneric(keyParamModel.getType());
                            Multimap nestedComponents = ComponentModel.this.getNestedComponents((ComponentModel)entryComponent);
                            if (genericValueDslOptional.isPresent()) {
                                DslElementSyntax genericValueDsl = genericValueDslOptional.get();
                                List itemsComponentModels = entryComponent.getInnerComponents().stream().filter(valueComponent -> valueComponent.getIdentifier().equals(ComponentModel.this.getIdentifier(genericValueDsl).orElse(null))).map(entryValueComponent -> {
                                    ArrayListMultimap nested = ArrayListMultimap.create();
                                    nested.put((Object)entryValueComponent.getIdentifier(), entryValueComponent);
                                    ComponentModel.this.enrichComponentModels((ComponentModel)entryComponent, (Multimap<ComponentIdentifier, ComponentModel>)((Multimap)nested), Optional.of(genericValueDsl), valueParamModel, extensionModelHelper);
                                    return entryValueComponent;
                                }).collect(Collectors.toList());
                                entryComponent.setParameter(valueParamModel, new DefaultComponentParameterAst(itemsComponentModels, () -> valueParamModel, entryComponent.getMetadata()));
                            } else {
                                Optional<DslElementSyntax> valueDslElementOptional = entryValueDsl.getContainedElement("value");
                                if (valueDslElementOptional.isPresent() && !valueDslElementOptional.get().isWrapped()) {
                                    ComponentModel.this.enrichComponentModels((ComponentModel)entryComponent, (Multimap<ComponentIdentifier, ComponentModel>)nestedComponents, valueDslElementOptional, valueParamModel, extensionModelHelper);
                                } else if (entryType instanceof ObjectType) {
                                    extensionModelHelper.resolveSubTypes((ObjectType)entryType).entrySet().stream().filter(entrySubTypeDslOptional -> ((Optional)entrySubTypeDslOptional.getValue()).isPresent()).forEach(entrySubTypeDslOptional -> {
                                        DslElementSyntax subTypeDsl = (DslElementSyntax)((Optional)entrySubTypeDslOptional.getValue()).get();
                                        ImmutableParameterModel subTypeValueParamModel = new ImmutableParameterModel("value", "", (MetadataType)entrySubTypeDslOptional.getKey(), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                                        ComponentModel.this.enrichComponentModels((ComponentModel)entryComponent, (Multimap<ComponentIdentifier, ComponentModel>)nestedComponents, Optional.of(subTypeDsl), subTypeValueParamModel, extensionModelHelper);
                                    });
                                }
                            }
                        } else {
                            entryComponent.setParameter(valueParamModel, new DefaultComponentParameterAst(value, () -> valueParamModel, entryComponent.getMetadata()));
                        }
                        ObjectTypeBuilder entryObjectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
                        entryObjectTypeBuilder.addField().key(keyParamModel.getName()).value(keyParamModel.getType());
                        entryObjectTypeBuilder.addField().key(valueParamModel.getName()).value(valueParamModel.getType());
                        entryComponent.setMetadataTypeModelAdapter(MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(entryObjectTypeBuilder.build(), extensionModelHelper));
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
        };
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final ComponentModel componentModel, final ParameterModel paramModel, final DslElementSyntax paramDsl, final ComponentModel paramComponent, final ExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitSimpleType(SimpleType simpleType) {
                if (paramComponent.getRawParameters().containsKey("value")) {
                    ObjectTypeBuilder entryObjectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
                    entryObjectTypeBuilder.addField().key("value").value(simpleType);
                    paramComponent.setMetadataTypeModelAdapter(MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(entryObjectTypeBuilder.build(), extensionModelHelper));
                    return;
                }
                paramDsl.getGeneric(simpleType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ComponentModel.this.getIdentifier(itemDsl).get();
                    List componentModels = paramComponent.getInnerComponents().stream().filter(c -> c.getIdentifier().equals(itemIdentifier)).filter(valueComponentModel -> valueComponentModel.getRawParameters().containsKey("value")).map(valueComponentModel -> {
                        ObjectTypeBuilder entryObjectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
                        entryObjectTypeBuilder.addField().key("value").value(simpleType);
                        valueComponentModel.setMetadataTypeModelAdapter(MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(entryObjectTypeBuilder.build(), extensionModelHelper));
                        return valueComponentModel;
                    }).collect(Collectors.toList());
                    componentModel.setParameter(paramModel, new DefaultComponentParameterAst(componentModels, () -> paramModel, paramComponent.getMetadata()));
                });
            }

            @Override
            public void visitObject(ObjectType itemType) {
                paramDsl.getGeneric(itemType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ComponentModel.this.getIdentifier(itemDsl).get();
                    HashMap objectTypeByTypeId = new HashMap();
                    HashMap typesDslMap = new HashMap();
                    HashMap itemIdentifiers = new HashMap();
                    extensionModelHelper.resolveSubTypes(itemType).entrySet().forEach(entrySet -> MetadataTypeUtils.getTypeId((MetadataType)entrySet.getKey()).ifPresent(subTypeTypeId -> {
                        typesDslMap.put(subTypeTypeId, entrySet.getValue());
                        objectTypeByTypeId.put(subTypeTypeId, entrySet.getKey());
                        ((Optional)entrySet.getValue()).ifPresent(dslElementSyntax -> ComponentModel.this.getIdentifier(dslElementSyntax).ifPresent(subTypeIdentifier -> itemIdentifiers.put(subTypeIdentifier, subTypeTypeId)));
                    }));
                    MetadataTypeUtils.getTypeId(itemType).ifPresent(itemTypeId -> {
                        typesDslMap.put(itemTypeId, Optional.of(itemDsl));
                        objectTypeByTypeId.put(itemTypeId, itemType);
                        itemIdentifiers.put(itemIdentifier, itemTypeId);
                    });
                    List componentModels = paramComponent.getInnerComponents().stream().filter(c -> itemIdentifiers.keySet().contains(c.getIdentifier())).map(c -> (ComponentAst)((Object)c)).collect(Collectors.toList());
                    componentModel.setParameter(paramModel, new DefaultComponentParameterAst(componentModels, () -> paramModel, paramComponent.getMetadata()));
                    paramComponent.getInnerComponents().stream().forEach(itemComponent -> {
                        String typeId = (String)itemIdentifiers.get(itemComponent.getIdentifier());
                        ((Optional)typesDslMap.get(typeId)).ifPresent(subTypeDsl -> {
                            MetadataTypeModelAdapter parameterizedModel = MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)objectTypeByTypeId.get(typeId), extensionModelHelper);
                            itemComponent.setMetadataTypeModelAdapter(parameterizedModel);
                            parameterizedModel.getAllParameterModels().stream().forEach(nestedParameter -> ComponentModel.this.enrichComponentModels((ComponentModel)itemComponent, (Multimap<ComponentIdentifier, ComponentModel>)ComponentModel.this.getNestedComponents((ComponentModel)itemComponent), subTypeDsl.getContainedElement(nestedParameter.getName()), nestedParameter, extensionModelHelper));
                        });
                    });
                });
            }
        };
    }

    private Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        if (StringUtils.isNotBlank((CharSequence)dsl.getElementName()) && StringUtils.isNotBlank((CharSequence)dsl.getPrefix())) {
            return Optional.of(ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build());
        }
        return Optional.empty();
    }

    private void executeOnComponentTree(ComponentModel component, Consumer<ComponentModel> task) throws MuleRuntimeException {
        task.accept(component);
        component.getInnerComponents().forEach(innerComponent -> this.executeOnComponentTree((ComponentModel)innerComponent, task));
    }

    public void setComponentModel(org.mule.runtime.api.meta.model.ComponentModel model) {
        this.componentModel = model;
    }

    public void setNestableElementModel(NestableElementModel nestableElementModel) {
        this.nestableElementModel = nestableElementModel;
    }

    public void setConfigurationModel(ConfigurationModel model) {
        this.configurationModel = model;
    }

    public void setConnectionProviderModel(ConnectionProviderModel connectionProviderModel) {
        this.connectionProviderModel = connectionProviderModel;
    }

    public void setMetadataTypeModelAdapter(MetadataTypeModelAdapter metadataTypeModelAdapter) {
        this.metadataTypeModelAdapter = metadataTypeModelAdapter;
    }

    @Deprecated
    public String getNameAttribute() {
        if (this instanceof ComponentAst) {
            return ((ComponentAst)((Object)this)).getComponentId().orElseGet(() -> this.parameters.get("name"));
        }
        return this.parameters.get("name");
    }

    public boolean isScope() {
        return Router.class.isAssignableFrom(this.type);
    }

    public void setParent(ComponentModel parent) {
        this.parent = parent;
    }

    public ComponentModel getParent() {
        return this.parent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setComponentLocation(DefaultComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    public DefaultComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public void setObjectInstance(Object objectInstance) {
        this.objectInstance = objectInstance;
    }

    public boolean isParameterValueProvidedBySchema(String parameterName) {
        return this.schemaValueParameter.contains(parameterName);
    }

    @Deprecated
    public ComponentConfiguration getConfiguration() {
        InternalComponentConfiguration.Builder builder = InternalComponentConfiguration.builder().withIdentifier(this.getIdentifier()).withValue(this.textContent);
        this.parameters.entrySet().forEach(e -> builder.withParameter((String)e.getKey(), (String)e.getValue()));
        this.innerComponents.forEach(i -> builder.withNestedComponent(i.getConfiguration()));
        this.getMetadata().getParserAttributes().forEach(builder::withProperty);
        builder.withComponentLocation(this.componentLocation);
        builder.withProperty(COMPONENT_MODEL_KEY, this);
        return builder.build();
    }

    public void executedOnEveryInnerComponent(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.innerComponents) {
            task.accept(componentModel);
            componentModel.executedOnEveryInnerComponent(task);
        }
    }

    @Deprecated
    public String getSourceCode() {
        return this.componentMetadata.getSourceCode().orElse(null);
    }

    public ComponentMetadataAst getMetadata() {
        return this.componentMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentModel that = (ComponentModel)o;
        if (this.root != that.root) {
            return false;
        }
        if (!Objects.equals(this.componentLocation, that.componentLocation)) {
            return false;
        }
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.root ? 1 : 0;
        result = 31 * result + Objects.hashCode(this.componentLocation);
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    private static /* synthetic */ void lambda$getNestedComponents$21(Multimap result, ComponentModel nestedComponent) {
        result.put((Object)nestedComponent.getIdentifier(), (Object)nestedComponent);
    }

    public static class Builder {
        private final ComponentModel model = new SpringComponentModel();
        private ComponentModel root;
        private final ComponentMetadataAst.Builder metadataBuilder = ComponentMetadataAst.builder();

        public Builder() {
        }

        public Builder(ComponentModel root) {
            this.root = root;
        }

        public Builder setIdentifier(ComponentIdentifier identifier) {
            this.checkIsNotBuildingFromRootComponentModel("identifier");
            this.model.identifier = identifier;
            return this;
        }

        public Builder addParameter(String parameterName, String value, boolean valueFromSchema) {
            this.checkIsNotBuildingFromRootComponentModel("parameters");
            this.model.parameters.put(parameterName, value);
            if (valueFromSchema) {
                this.model.schemaValueParameter.add(parameterName);
            }
            return this;
        }

        public Builder addChildComponentModel(ComponentModel componentModel) {
            this.checkIsNotBuildingFromRootComponentModel("innerComponents");
            this.model.innerComponents.add(componentModel);
            componentModel.setParent(this.model);
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.checkIsNotBuildingFromRootComponentModel("textComponent");
            this.model.textContent = textContent;
            return this;
        }

        public Builder markAsRootComponent() {
            this.checkIsNotBuildingFromRootComponentModel("root");
            this.model.root = true;
            return this;
        }

        public Builder addCustomAttribute(String name, Object value) {
            this.checkIsNotBuildingFromRootComponentModel("customAttributes");
            return this.addCustomAttribute(QName.valueOf(name), value);
        }

        public Builder addCustomAttribute(QName qname, Object value) {
            this.checkIsNotBuildingFromRootComponentModel("customAttributes");
            if (StringUtils.isEmpty((CharSequence)qname.getNamespaceURI()) || "http://www.mulesoft.org/schema/mule/parser-metadata".equals(qname.getNamespaceURI())) {
                this.metadataBuilder.putParserAttribute(qname.getLocalPart(), value);
            } else {
                this.metadataBuilder.putDocAttribute(qname.toString(), value.toString());
                if ("http://www.mulesoft.org/schema/mule/documentation".equals(qname.getNamespaceURI())) {
                    this.metadataBuilder.putDocAttribute(qname.getLocalPart(), value.toString());
                }
            }
            return this;
        }

        public Builder setConfigFileName(String configFileName) {
            this.checkIsNotBuildingFromRootComponentModel("configFileName");
            this.metadataBuilder.setFileName(configFileName);
            return this;
        }

        public Builder setLineNumber(int lineNumber) {
            this.checkIsNotBuildingFromRootComponentModel("lineNumber");
            this.metadataBuilder.setStartLine(lineNumber);
            this.metadataBuilder.setEndLine(lineNumber);
            return this;
        }

        public Builder setStartColumn(int startColumn) {
            this.checkIsNotBuildingFromRootComponentModel("startColumn");
            this.metadataBuilder.setStartColumn(startColumn);
            this.metadataBuilder.setEndColumn(startColumn);
            return this;
        }

        public Builder setSourceCode(String sourceCode) {
            this.checkIsNotBuildingFromRootComponentModel("sourceCode");
            this.metadataBuilder.setSourceCode(sourceCode);
            return this;
        }

        public Builder merge(ComponentModel otherRootComponentModel) {
            ((ComponentAst)((Object)otherRootComponentModel)).getMetadata().getParserAttributes().forEach((k, v) -> this.metadataBuilder.putParserAttribute((String)k, v));
            ((ComponentAst)((Object)otherRootComponentModel)).getMetadata().getDocAttributes().forEach((k, v) -> this.metadataBuilder.putDocAttribute((String)k, (String)v));
            this.root.parameters.putAll(otherRootComponentModel.parameters);
            this.root.schemaValueParameter.addAll(otherRootComponentModel.schemaValueParameter);
            this.root.innerComponents.addAll(otherRootComponentModel.innerComponents);
            return this;
        }

        public ComponentModel build() {
            if (this.root != null) {
                return this.root;
            }
            Preconditions.checkState(this.model.identifier != null, "An identifier must be provided");
            this.model.componentMetadata = this.metadataBuilder.build();
            return this.model;
        }

        private void checkIsNotBuildingFromRootComponentModel(String parameter) {
            Preconditions.checkState(this.root == null, String.format("%s cannot be modified when builder has been constructed from a root component", parameter));
        }
    }
}

