/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultComponentParameterAst
implements ComponentParameterAst {
    private final String rawValue;
    private final Supplier<ParameterModel> model;
    private final ComponentMetadataAst metadata;
    private final LazyValue<Either<String, Object>> value;

    public DefaultComponentParameterAst(String rawValue, Supplier<ParameterModel> model) {
        this(rawValue, model, null);
    }

    public DefaultComponentParameterAst(String rawValue, Supplier<ParameterModel> model, ComponentMetadataAst metadata) {
        this(rawValue, null, model, metadata);
    }

    public DefaultComponentParameterAst(Object complexValue, Supplier<ParameterModel> model, ComponentMetadataAst metadata) {
        this(null, complexValue, model, metadata);
    }

    private DefaultComponentParameterAst(final String rawValue, Object complexValue, Supplier<ParameterModel> model, ComponentMetadataAst metadata) {
        this.rawValue = rawValue;
        this.model = model;
        this.metadata = metadata;
        this.value = new LazyValue<Supplier<Either>>(() -> {
            if (complexValue != null) {
                return Either.right(complexValue);
            }
            if (StringUtils.isEmpty((CharSequence)rawValue)) {
                Object defaultValue = this.getModel().getDefaultValue();
                if (MuleExtensionUtils.isExpression(defaultValue)) {
                    return Either.left((String)defaultValue);
                }
                return Either.right(defaultValue);
            }
            final AtomicReference expression = new AtomicReference();
            final AtomicReference value = new AtomicReference();
            this.getModel().getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitObjectField(ObjectFieldType objectFieldType) {
                    objectFieldType.getValue().accept(this);
                }

                @Override
                public void visitBoolean(BooleanType booleanType) {
                    if (MuleExtensionUtils.isExpression(rawValue)) {
                        this.defaultVisit(booleanType);
                    } else {
                        value.set(Boolean.valueOf(rawValue));
                    }
                }

                @Override
                public void visitNumber(NumberType numberType) {
                    if (MuleExtensionUtils.isExpression(rawValue)) {
                        this.defaultVisit(numberType);
                    } else {
                        value.set(numberType.getAnnotation(ClassInformationAnnotation.class).map(classInfo -> {
                            if (classInfo.getClassname().equals(Integer.class.getName())) {
                                return Integer.valueOf(rawValue);
                            }
                            if (classInfo.getClassname().equals(Float.class.getName())) {
                                return Float.valueOf(rawValue);
                            }
                            if (classInfo.getClassname().equals(Long.class.getName())) {
                                return Long.valueOf(rawValue);
                            }
                            if (classInfo.getClassname().equals(Byte.class.getName())) {
                                return Byte.valueOf(rawValue);
                            }
                            if (classInfo.getClassname().equals(Short.class.getName())) {
                                return Short.valueOf(rawValue);
                            }
                            if (classInfo.getClassname().equals(Double.class.getName())) {
                                return Double.valueOf(rawValue);
                            }
                            return null;
                        }).orElseGet(() -> Integer.valueOf(rawValue)));
                    }
                }

                @Override
                public void visitString(StringType stringType) {
                    if (MuleExtensionUtils.isExpression(rawValue)) {
                        this.defaultVisit(stringType);
                    } else {
                        value.set(rawValue);
                    }
                }

                @Override
                protected void defaultVisit(MetadataType metadataType) {
                    if (!DefaultComponentParameterAst.this.getModel().getAllowedStereotypes().isEmpty() && rawValue instanceof String) {
                        value.set(rawValue);
                    } else if (!ExpressionSupport.NOT_SUPPORTED.equals((Object)DefaultComponentParameterAst.this.getModel().getExpressionSupport())) {
                        if (MuleExtensionUtils.isExpression(rawValue)) {
                            expression.set(rawValue);
                        } else {
                            value.set(rawValue);
                        }
                    }
                }
            });
            if (expression.get() != null) {
                return Either.left(expression.get());
            }
            return Either.right(value.get());
        });
    }

    @Override
    public <T> Either<String, T> getValue() {
        return this.value.get();
    }

    @Override
    public String getRawValue() {
        return this.rawValue;
    }

    @Override
    public ParameterModel getModel() {
        return this.model.get();
    }

    @Override
    public Optional<ComponentMetadataAst> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }
}

