/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming;

import java.io.Closeable;
import java.io.InputStream;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.StreamingStatistics;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManagerFactory;
import org.mule.runtime.core.api.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.api.streaming.object.ObjectStreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.streaming.AtomicStreamingStatistics;
import org.mule.runtime.core.internal.streaming.CursorManager;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.NullStreamingStatistics;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.streaming.bytes.DefaultByteStreamingManager;
import org.mule.runtime.core.internal.streaming.bytes.factory.PoolingByteBufferManagerFactory;
import org.mule.runtime.core.internal.streaming.object.DefaultObjectStreamingManager;
import org.mule.runtime.core.internal.streaming.object.factory.NullCursorIteratorProviderFactory;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.util.EventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultStreamingManager
implements StreamingManager,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStreamingManager.class);
    private static final String BUFFER_MANAGER_FACTORY_CLASS = System.getProperty(ByteBufferManagerFactory.class.getName(), PoolingByteBufferManagerFactory.class.getName());
    private ByteBufferManager bufferManager;
    private ByteStreamingManager byteStreamingManager;
    private ObjectStreamingManager objectStreamingManager;
    private CursorManager cursorManager;
    private MutableStreamingStatistics statistics;
    private boolean initialised = false;
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private StreamingGhostBuster ghostBuster;

    @Override
    public void initialise() throws InitialisationException {
        if (!this.initialised) {
            this.statistics = this.createStatistics();
            this.cursorManager = new CursorManager(this.statistics, this.ghostBuster);
            this.bufferManager = this.createByteBufferManager();
            this.byteStreamingManager = this.createByteStreamingManager();
            this.objectStreamingManager = this.createObjectStreamingManager();
            LifecycleUtils.initialiseIfNeeded(this.byteStreamingManager, true, this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.objectStreamingManager, true, this.muleContext);
            this.initialised = true;
        }
    }

    private ByteBufferManager createByteBufferManager() throws InitialisationException {
        ByteBufferManagerFactory factory;
        CompositeClassLoader classLoader = new CompositeClassLoader(this.getClass().getClassLoader(), this.muleContext.getExecutionClassLoader());
        try {
            factory = (ByteBufferManagerFactory)ClassUtils.instantiateClass(BUFFER_MANAGER_FACTORY_CLASS, new Object[0], classLoader);
        }
        catch (Exception e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("Could not create %s of type %s", ByteBufferManagerFactory.class.getName(), BUFFER_MANAGER_FACTORY_CLASS)), (Throwable)e, this);
        }
        return factory.create();
    }

    private MutableStreamingStatistics createStatistics() {
        return Boolean.parseBoolean(System.getProperty("mule..enableStreamingStatistics")) ? new AtomicStreamingStatistics() : new NullStreamingStatistics();
    }

    protected ByteStreamingManager createByteStreamingManager() {
        return new DefaultByteStreamingManager(this.bufferManager, this);
    }

    protected ObjectStreamingManager createObjectStreamingManager() {
        return new DefaultObjectStreamingManager(this);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.byteStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.objectStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.bufferManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.cursorManager, LOGGER);
        this.initialised = false;
    }

    @Override
    public ByteStreamingManager forBytes() {
        return this.byteStreamingManager;
    }

    @Override
    public ObjectStreamingManager forObjects() {
        return this.objectStreamingManager;
    }

    @Override
    public CursorProvider manage(CursorProvider provider, EventContext creatorEventContext) {
        if (provider instanceof ManagedCursorProvider) {
            return provider;
        }
        return this.cursorManager.manage(provider, (DefaultEventContext)((BaseEventContext)creatorEventContext).getRootContext());
    }

    @Override
    public void manage(InputStream stream, EventContext creatorEventContext) {
        this.manage((Closeable)stream, creatorEventContext);
    }

    @Override
    public void manage(Closeable closeable, EventContext creatorEventContext) {
        if (closeable instanceof Cursor) {
            return;
        }
        ((BaseEventContext)creatorEventContext).onTerminated((response, throwable) -> IOUtils.closeQuietly(closeable));
    }

    @Override
    public CursorProvider manage(CursorProvider provider, CoreEvent creatorEvent) {
        return this.manage(provider, EventUtils.getRoot(creatorEvent.getContext()));
    }

    @Override
    public void manage(InputStream stream, CoreEvent creatorEvent) {
        this.manage(stream, EventUtils.getRoot(creatorEvent.getContext()));
    }

    @Override
    public Pair<CursorStreamProviderFactory, CursorIteratorProviderFactory> getPairFor(CursorProviderFactory provider) {
        CursorStreamProviderFactory cursorStreamProviderFactory;
        CursorIteratorProviderFactory cursorIteratorProviderFactory;
        if (provider instanceof CursorIteratorProviderFactory) {
            cursorIteratorProviderFactory = (CursorIteratorProviderFactory)provider;
            cursorStreamProviderFactory = provider instanceof NullCursorIteratorProviderFactory && this.muleContext.getConfiguration().isInheritIterableRepeatability() ? this.forBytes().getNullCursorProviderFactory() : this.forBytes().getDefaultCursorProviderFactory();
        } else if (provider instanceof CursorStreamProviderFactory) {
            cursorStreamProviderFactory = (CursorStreamProviderFactory)provider;
            cursorIteratorProviderFactory = this.forObjects().getDefaultCursorProviderFactory();
        } else {
            throw new IllegalArgumentException("The given cursor provider factory must be either a CursorStreamProviderFactory or a CursorIteratorProviderFactory");
        }
        return new Pair<CursorStreamProviderFactory, CursorIteratorProviderFactory>(cursorStreamProviderFactory, cursorIteratorProviderFactory);
    }

    @Override
    public StreamingStatistics getStreamingStatistics() {
        return this.statistics;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }
}

