/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.internal.construct.FlowBackPressureEventsAccumulatedException;
import org.mule.runtime.core.internal.construct.FlowBackPressureMaxConcurrencyExceededException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyWithFullBufferException;

public abstract class FlowBackPressureException
extends MuleException {
    static String BACK_PRESSURE_ERROR_MESSAGE = "Flow '%s' is unable to accept new events at this time. Reason: %s";
    private static final long serialVersionUID = -4973370165925845336L;

    public FlowBackPressureException(String flowName, BackPressureReason reason) {
        super(CoreMessages.backpressure(flowName, reason));
    }

    public FlowBackPressureException(String flowName, BackPressureReason reason, Throwable cause) {
        super(CoreMessages.backpressure(flowName, reason), cause);
    }

    public static FlowBackPressureException createFlowBackPressureException(String flowName, BackPressureReason reason, Throwable cause) {
        switch (reason) {
            case MAX_CONCURRENCY_EXCEEDED: {
                return new FlowBackPressureMaxConcurrencyExceededException(flowName, reason, cause);
            }
            case REQUIRED_SCHEDULER_BUSY: {
                return new FlowBackPressureRequiredSchedulerBusyException(flowName, reason, cause);
            }
            case REQUIRED_SCHEDULER_BUSY_WITH_FULL_BUFFER: {
                return new FlowBackPressureRequiredSchedulerBusyWithFullBufferException(flowName, reason, cause);
            }
            case EVENTS_ACCUMULATED: {
                return new FlowBackPressureEventsAccumulatedException(flowName, reason, cause);
            }
        }
        throw new IllegalArgumentException("Cannot build a FlowBackPressureException with a cause without a reason");
    }

    public static void createAndThrowIfNeeded(String flowName, BackPressureReason reason, Throwable cause) throws FlowBackPressureException {
        FlowBackPressureException toThrow = FlowBackPressureException.createFlowBackPressureException(flowName, reason, cause);
        if (toThrow != null) {
            throw toThrow;
        }
    }
}

