/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;

public class ErrorHandlerContext {
    public static final String ERROR_HANDLER_CONTEXT = "error.context";
    private final Map<String, ErrorHandlerContextItem> items = new SmallMap<String, ErrorHandlerContextItem>();

    public static ErrorHandlerContext from(CoreEvent event) {
        return (ErrorHandlerContext)((InternalEvent)event).getInternalParameter(ERROR_HANDLER_CONTEXT);
    }

    public void addContextItem(String parameterId, Exception exception, CoreEvent originalEvent, Consumer<CoreEvent> successCallback, Consumer<Throwable> errorCallback) {
        this.items.put(parameterId, new ErrorHandlerContextItem(exception, originalEvent, successCallback, errorCallback));
    }

    public Exception getException(String parameterId) {
        return this.items.get(parameterId).exception;
    }

    public CoreEvent getOriginalEvent(String parameterId) {
        return this.items.get(parameterId).originalEvent;
    }

    public Consumer<CoreEvent> getSuccessCallback(String parameterId) {
        return this.items.get(parameterId).successCallback;
    }

    public Consumer<Throwable> getRethrowCallback(String parameterId) {
        return this.items.get(parameterId).errorCallback;
    }

    private static class ErrorHandlerContextItem {
        private final Exception exception;
        private final CoreEvent originalEvent;
        private final Consumer<CoreEvent> successCallback;
        private final Consumer<Throwable> errorCallback;

        public ErrorHandlerContextItem(Exception exception, CoreEvent originalEvent, Consumer<CoreEvent> successCallback, Consumer<Throwable> errorCallback) {
            this.exception = exception;
            this.originalEvent = originalEvent;
            this.successCallback = successCallback;
            this.errorCallback = errorCallback;
        }
    }
}

