/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Preconditions;

public final class ErrorBuilder {
    private Throwable exception;
    private String description;
    private String detailedDescription;
    private ErrorType errorType;
    private Message errorMessage;
    private List<Error> errors = Collections.emptyList();

    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    public static ErrorBuilder builder(Throwable e) {
        return new ErrorBuilder(e);
    }

    public static ErrorBuilder builder(Error e) {
        return new ErrorBuilder(e);
    }

    private ErrorBuilder() {
    }

    private ErrorBuilder(Throwable e) {
        String exceptionDescription;
        if (e instanceof ErrorMessageAwareException) {
            this.errorMessage = ((ErrorMessageAwareException)((Object)e)).getErrorMessage();
        }
        if (e instanceof ComposedErrorException) {
            this.errors = ((ComposedErrorException)((Object)e)).getErrors();
        }
        this.exception = e;
        this.description = exceptionDescription = e.getMessage() != null ? e.getMessage() : "unknown description";
        this.detailedDescription = exceptionDescription;
        MuleException muleRoot = ExceptionHelper.getRootMuleException(this.exception);
        if (muleRoot != null && muleRoot.getMessage() != null) {
            this.description = muleRoot.getMessage();
        }
    }

    private ErrorBuilder(Error e) {
        this.description = e.getDescription();
        this.detailedDescription = e.getDetailedDescription();
        this.exception = e.getCause();
        this.errorType = e.getErrorType();
        this.errorMessage = e.getErrorMessage();
        this.errors = e.getChildErrors();
    }

    public ErrorBuilder exception(Throwable exception) {
        this.exception = exception;
        return this;
    }

    public ErrorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ErrorBuilder detailedDescription(String detailedDescription) {
        this.detailedDescription = detailedDescription;
        return this;
    }

    public ErrorBuilder errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ErrorBuilder errorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public ErrorBuilder errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public Error build() {
        Preconditions.checkState(this.exception != null, "error exception cannot be null");
        Preconditions.checkState(this.description != null, "description exception cannot be null");
        Preconditions.checkState(this.detailedDescription != null, "detailed description exception cannot be null");
        Preconditions.checkState(this.errorType != null, "errorType exception cannot be null");
        return new ErrorImplementation(this.exception, this.description, this.detailedDescription, this.errorType, this.errorMessage, this.errors);
    }

    private static final class ErrorImplementation
    implements Error {
        private static final long serialVersionUID = -6904692174522094021L;
        private final Throwable exception;
        private final String description;
        private final String detailedDescription;
        private final ErrorType errorType;
        private final Message muleMessage;
        private final List<Error> errors;

        private ErrorImplementation(Throwable exception, String description, String detailedDescription, ErrorType errorType, Message errorMessage, List<Error> errors) {
            this.exception = exception;
            this.description = description;
            this.detailedDescription = detailedDescription;
            this.errorType = errorType;
            this.muleMessage = errorMessage;
            this.errors = Collections.unmodifiableList(errors);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDetailedDescription() {
            return this.detailedDescription;
        }

        @Override
        public ErrorType getErrorType() {
            return this.errorType;
        }

        @Override
        public Throwable getCause() {
            return this.exception;
        }

        @Override
        public Message getErrorMessage() {
            return this.muleMessage;
        }

        @Override
        public List<Error> getChildErrors() {
            return this.errors;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(120);
            buf.append(System.lineSeparator());
            buf.append(this.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("{");
            buf.append(System.lineSeparator());
            buf.append("  description=").append(this.description);
            buf.append(System.lineSeparator());
            buf.append("  detailedDescription=").append(this.detailedDescription);
            buf.append(System.lineSeparator());
            buf.append("  errorType=").append(this.errorType);
            buf.append(System.lineSeparator());
            buf.append("  cause=").append(this.exception.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("  errorMessage=").append(ObjectUtils.defaultIfNull((Object)this.muleMessage, (Object)"-"));
            buf.append(System.lineSeparator());
            buf.append("  childErrors=").append(this.errors);
            buf.append(System.lineSeparator());
            buf.append('}');
            return buf.toString();
        }
    }
}

