/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.mule.runtime.api.interception.SourceInterceptorFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.processor.interceptor.AbstractInterceptorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

public class CompletableInterceptorSourceCallbackAdapter
extends AbstractInterceptorAdapter
implements BiFunction<MessageSource, BiConsumer<SourcePolicySuccessResult, CompletableCallback<Void>>, BiConsumer<SourcePolicySuccessResult, CompletableCallback<Void>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableInterceptorSourceCallbackAdapter.class);
    private SourceInterceptorFactory interceptorFactory;

    public CompletableInterceptorSourceCallbackAdapter(SourceInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public BiConsumer<SourcePolicySuccessResult, CompletableCallback<Void>> apply(MessageSource source, BiConsumer<SourcePolicySuccessResult, CompletableCallback<Void>> next) {
        if (!this.isInterceptable(source)) {
            return next;
        }
        ComponentLocation componentLocation = source.getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        SourceInterceptor interceptor = (SourceInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)source.getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        return (result, callback) -> {
            SourcePolicySuccessResult interceptedBeforeResult = new SourcePolicySuccessResult(this.doBefore(interceptor, source, dslParameters).apply((InternalEvent)result.getResult()), result.getResponseParameters(), result.getMessageSourceResponseParametersProcessor());
            try {
                next.accept(interceptedBeforeResult, (CompletableCallback<Void>)callback);
                this.doAfter(interceptor, source, Optional.empty()).apply((InternalEvent)interceptedBeforeResult.getResult());
            }
            catch (Throwable t) {
                this.doAfter(interceptor, source, Optional.of(t)).apply((InternalEvent)interceptedBeforeResult.getResult());
                callback.error(t);
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doBefore(SourceInterceptor interceptor, Component component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClass().getClassLoader(), () -> interceptor.beforeCallback(component.getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)new MessagingException((CoreEvent)interceptionEvent.resolve(), e.getCause(), component));
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doAfter(SourceInterceptor interceptor, Component component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClass().getClassLoader(), () -> interceptor.afterCallback(component.getLocation(), interceptionEvent, thrown));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)this.createMessagingException(interceptionEvent.resolve(), e.getCause(), component, Optional.empty()));
            }
        };
    }

    private boolean isInterceptable(Component component) {
        return component.getLocation() != null;
    }
}

