/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.thread.notification.ThreadLoggingExecutorServiceDecorator;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.OperationInnerProcessor;
import org.mule.runtime.core.internal.processor.strategy.StreamEmitterProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.RetrySchedulerWrapper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ProactorStreamEmitterProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        Supplier<Scheduler> cpuLightSchedulerSupplier = this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix);
        return new ProactorStreamEmitterProcessingStrategy(this.getBufferSize(), this.getSubscriberCount(), cpuLightSchedulerSupplier, cpuLightSchedulerSupplier, () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.resolveParallelism(), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck(), muleContext.getConfiguration().isThreadLoggingEnabled());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ProactorStreamEmitterProcessingStrategy.class;
    }

    static class ProactorStreamEmitterProcessingStrategy
    extends StreamEmitterProcessingStrategyFactory.StreamEmitterProcessingStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProactorStreamEmitterProcessingStrategy.class);
        private final boolean isThreadLoggingEnabled;
        private final Supplier<Scheduler> blockingSchedulerSupplier;
        private final Supplier<Scheduler> cpuIntensiveSchedulerSupplier;
        private Scheduler blockingScheduler;
        private Scheduler cpuIntensiveScheduler;

        public ProactorStreamEmitterProcessingStrategy(int bufferSize, int subscriberCount, Supplier<Scheduler> flowDispatchSchedulerSupplier, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck, boolean isThreadLoggingEnabled) {
            super(bufferSize, subscriberCount, flowDispatchSchedulerSupplier, cpuLightSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck);
            this.blockingSchedulerSupplier = blockingSchedulerSupplier;
            this.cpuIntensiveSchedulerSupplier = cpuIntensiveSchedulerSupplier;
            this.isThreadLoggingEnabled = isThreadLoggingEnabled;
        }

        @Override
        public void start() throws MuleException {
            super.start();
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
            this.cpuIntensiveScheduler = this.cpuIntensiveSchedulerSupplier.get();
        }

        @Override
        protected int getSinksCount() {
            return this.maxConcurrency < AbstractStreamProcessingStrategyFactory.CORES ? this.maxConcurrency : AbstractStreamProcessingStrategyFactory.CORES;
        }

        @Override
        protected Scheduler createCpuLightScheduler(Supplier<Scheduler> cpuLightSchedulerSupplier) {
            return new RetrySchedulerWrapper(super.createCpuLightScheduler(cpuLightSchedulerSupplier), 2L);
        }

        @Override
        protected boolean stopSchedulersIfNeeded() {
            if (super.stopSchedulersIfNeeded()) {
                if (this.blockingScheduler != null) {
                    this.blockingScheduler.stop();
                }
                if (this.cpuIntensiveScheduler != null) {
                    this.cpuIntensiveScheduler.stop();
                }
                return true;
            }
            return false;
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING || processor.getProcessingType() == ReactiveProcessor.ProcessingType.IO_RW) {
                return this.proactor(processor, this.blockingScheduler);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE) {
                return this.proactor(processor, this.cpuIntensiveScheduler);
            }
            return super.onProcessor(processor);
        }

        protected ReactiveProcessor proactor(ReactiveProcessor processor, ScheduledExecutorService scheduler) {
            LOGGER.debug("Doing proactor() for {} on {}. maxConcurrency={}, parallelism={}, subscribers={}", new Object[]{processor, scheduler, this.maxConcurrency, this.getParallelism(), this.subscribers});
            ScheduledExecutorService retryScheduler = this.getRetryScheduler(scheduler);
            if (this.maxConcurrency == 1) {
                return publisher -> this.scheduleProcessor(processor, retryScheduler, (Flux<CoreEvent>)Flux.from((Publisher)publisher)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler));
            }
            if (this.maxConcurrency == Integer.MAX_VALUE) {
                if (processor instanceof OperationInnerProcessor) {
                    return publisher -> this.scheduleProcessor(processor, retryScheduler, (Flux<CoreEvent>)Flux.from((Publisher)publisher)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler));
                }
                return publisher -> Flux.from((Publisher)publisher).flatMap(event -> this.scheduleProcessor(processor, retryScheduler, (Mono<CoreEvent>)Mono.just((Object)event)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler)), Integer.MAX_VALUE);
            }
            return publisher -> Flux.from((Publisher)publisher).flatMap(event -> this.scheduleProcessor(processor, retryScheduler, (Mono<CoreEvent>)Mono.just((Object)event)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler)), Math.max(this.maxConcurrency / (this.getParallelism() * this.subscribers), 1));
        }

        private Mono<CoreEvent> scheduleProcessor(ReactiveProcessor processor, ScheduledExecutorService processorScheduler, Mono<CoreEvent> eventFlux) {
            return this.scheduleWithLogging(processor, processorScheduler, eventFlux);
        }

        private Flux<CoreEvent> scheduleProcessor(ReactiveProcessor processor, ScheduledExecutorService processorScheduler, Flux<CoreEvent> eventFlux) {
            return this.scheduleWithLogging(processor, processorScheduler, eventFlux);
        }

        private Mono<CoreEvent> scheduleWithLogging(ReactiveProcessor processor, ScheduledExecutorService processorScheduler, Mono<CoreEvent> eventFlux) {
            if (this.isThreadLoggingEnabled) {
                return Mono.from(eventFlux).flatMap(e -> Mono.subscriberContext().flatMap(ctx -> Mono.just((Object)e).transform((Function)processor).subscribeOn(Schedulers.fromExecutorService((ExecutorService)new ThreadLoggingExecutorServiceDecorator(ctx.getOrEmpty((Object)"mule.nb.ThreadNotificationLogger"), this.decorateScheduler(processorScheduler), e.getContext().getId())))));
            }
            return Mono.from(eventFlux).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(processorScheduler))).transform((Function)processor);
        }

        private Flux<CoreEvent> scheduleWithLogging(ReactiveProcessor processor, ScheduledExecutorService processorScheduler, Flux<CoreEvent> eventFlux) {
            if (this.isThreadLoggingEnabled) {
                return Flux.from(eventFlux).flatMap(e -> Mono.subscriberContext().flatMap(ctx -> Mono.just((Object)e).transform((Function)processor).subscribeOn(Schedulers.fromExecutorService((ExecutorService)new ThreadLoggingExecutorServiceDecorator(ctx.getOrEmpty((Object)"mule.nb.ThreadNotificationLogger"), this.decorateScheduler(processorScheduler), e.getContext().getId())))));
            }
            return Flux.from(eventFlux).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(processorScheduler))).transform((Function)processor);
        }

        @Override
        protected Scheduler getFlowDispatcherScheduler() {
            return this.getCpuLightScheduler();
        }
    }
}

