/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.routing.ExecutableRoute;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.routing.RoutingException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

abstract class AbstractSinkRouter {
    private final Flux<CoreEvent> router;
    private final List<ExecutableRoute> routes;

    protected AbstractSinkRouter(Publisher<CoreEvent> publisher, List<ProcessorRoute> routes) {
        this.routes = routes.stream().map(ProcessorRoute::toExecutableRoute).collect(Collectors.toList());
        this.router = Flux.from(publisher).doOnNext(Exceptions.checkedConsumer(this::route)).doOnComplete(() -> this.routes.stream().forEach(executableRoute -> executableRoute.complete()));
    }

    List<Flux<CoreEvent>> collectPublishers() {
        ArrayList<Flux<CoreEvent>> routes = new ArrayList<Flux<CoreEvent>>();
        Iterator<ExecutableRoute> routesIterator = this.routes.iterator();
        while (routesIterator.hasNext()) {
            ExecutableRoute nextRoute = routesIterator.next();
            if (routesIterator.hasNext()) {
                routes.add(nextRoute.getPublisher());
                continue;
            }
            routes.add(RxUtils.subscribeFluxOnPublisherSubscription(nextRoute.getPublisher(), this.router));
        }
        return routes;
    }

    protected abstract void route(CoreEvent var1) throws RoutingException;

    protected List<ExecutableRoute> getRoutes() {
        return this.routes;
    }
}

