/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.ExecutableRoute;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorRoute
extends AbstractComponent
implements MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorRoute.class);
    private final Processor processor;
    private FlowExceptionHandler messagingExceptionHandler = (exception, event) -> null;
    private MuleContext muleContext;

    public ProcessorRoute(Processor processor) {
        Objects.requireNonNull(processor, "processor can't be null");
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.processor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.processor)).setMuleContext(context);
        }
    }

    public void setMessagingExceptionHandler(FlowExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.processor instanceof DefaultMessageProcessorChainBuilder.MessagingExceptionHandlerAware) {
            ((DefaultMessageProcessorChainBuilder.MessagingExceptionHandlerAware)((Object)this.processor)).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        LifecycleUtils.initialiseIfNeeded(this.processor, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processor);
    }

    public boolean accepts(ExpressionManagerSession session) {
        return true;
    }

    ExecutableRoute toExecutableRoute() {
        return new ExecutableRoute(this);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processor);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processor, LOGGER);
    }
}

