/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.UntilSuccessfulRouter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;

public class UntilSuccessful
extends AbstractMuleObjectOwner
implements Scope {
    private static final String DEFAULT_MILLIS_BETWEEN_RETRIES = "60000";
    private static final String DEFAULT_RETRIES = "5";
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExtendedExpressionManager expressionManager;
    private String maxRetries = "5";
    private String millisBetweenRetries = "60000";
    private MessageProcessorChain nestedChain;
    private Predicate<CoreEvent> shouldRetry;
    private Scheduler timer;
    private List<Processor> processors;

    @Override
    public void initialise() throws InitialisationException {
        if (this.processors == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("One message processor must be configured within 'until-successful'."), (Initialisable)this);
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), this.processors);
        super.initialise();
        this.timer = this.schedulerService.cpuLightScheduler();
        this.shouldRetry = event -> event.getError().isPresent();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.stop();
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        try {
            return MessageProcessors.processToApply(event, this);
        }
        catch (Exception error) {
            Throwable cause = error.getCause();
            if (cause != null && cause instanceof UntilSuccessfulRouter.RetryContextInitializationException && cause.getCause() instanceof ExpressionRuntimeException) {
                throw (ExpressionRuntimeException)cause.getCause();
            }
            throw error;
        }
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return new UntilSuccessfulRouter(this, publisher, this.nestedChain, this.expressionManager, this.shouldRetry, this.timer, this.maxRetries, this.millisBetweenRetries).getDownstreamPublisher();
    }

    public String getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(String maxRetries) {
        this.maxRetries = maxRetries;
    }

    public String getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(String millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Object> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }
}

