/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.ref.WeakReference;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;

public class EventStreamingState {
    private final Cache<Integer, WeakReference<ManagedCursorProvider>> providers = Caffeine.newBuilder().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedCursorProvider addProvider(ManagedCursorProvider provider, StreamingGhostBuster ghostBuster) {
        int hash = System.identityHashCode(provider.getDelegate());
        ManagedCursorProvider managedProvider = this.getOrAddManagedProvider(hash, provider, ghostBuster);
        if (managedProvider == null) {
            CursorProvider cursorProvider = provider.getDelegate();
            synchronized (cursorProvider) {
                managedProvider = this.getOrAddManagedProvider(hash, provider, ghostBuster);
                if (managedProvider == null) {
                    this.providers.invalidate((Object)hash);
                    managedProvider = this.getOrAddManagedProvider(hash, provider, ghostBuster);
                }
            }
        }
        return managedProvider;
    }

    private ManagedCursorProvider getOrAddManagedProvider(int hash, ManagedCursorProvider provider, StreamingGhostBuster ghostBuster) {
        return (ManagedCursorProvider)((WeakReference)this.providers.get((Object)hash, k -> ghostBuster.track(provider))).get();
    }

    public void dispose() {
        this.providers.asMap().forEach((hash, weakReference) -> {
            ManagedCursorProvider provider = (ManagedCursorProvider)weakReference.get();
            if (provider != null) {
                weakReference.clear();
                provider.releaseResources();
            }
        });
    }
}

