/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;

public abstract class ManagedCursorProvider<T extends Cursor>
implements CursorProvider<T> {
    private final CursorProvider<T> delegate;
    private final AtomicInteger openCursorsCount = new AtomicInteger(0);
    private final MutableStreamingStatistics statistics;
    private final CursorProviderJanitor janitor;

    protected ManagedCursorProvider(CursorProvider<T> delegate, MutableStreamingStatistics statistics) {
        this.delegate = delegate;
        this.janitor = new CursorProviderJanitor(delegate, this.openCursorsCount, statistics);
        this.statistics = statistics;
        if (statistics != null) {
            statistics.incrementOpenProviders();
        }
    }

    @Override
    public final T openCursor() {
        T cursor = this.delegate.openCursor();
        this.openCursorsCount.incrementAndGet();
        if (this.statistics != null) {
            this.statistics.incrementOpenCursors();
        }
        return this.managedCursor(cursor);
    }

    public CursorProvider<T> getDelegate() {
        return this.delegate;
    }

    protected abstract T managedCursor(T var1);

    @Override
    public final void releaseResources() {
        this.janitor.releaseResources();
    }

    public CursorProviderJanitor getJanitor() {
        return this.janitor;
    }

    @Override
    public void close() {
        this.janitor.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }
}

