/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.value.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.app.declaration.internal.utils.Preconditions;

public class ValueProviderCacheId {
    private final String sourceElementName;
    private final String value;
    private final List<ValueProviderCacheId> parts;
    private final Map<String, String> attributes;

    private ValueProviderCacheId(String sourceElementName, String value, List<ValueProviderCacheId> parts, Map<String, String> attributes) {
        this.sourceElementName = sourceElementName;
        this.parts = new ArrayList<ValueProviderCacheId>(parts);
        this.attributes = attributes;
        this.value = value + parts.stream().map(ValueProviderCacheId::getValue).reduce((a, b) -> a + b).orElse("");
    }

    public List<ValueProviderCacheId> getParts() {
        return this.parts;
    }

    public String getSourceElementName() {
        return this.sourceElementName;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sourceElementName).append(" : ").append(this.value).append(", attributes: {");
        this.attributes.forEach((k, v) -> stringBuilder.append(System.lineSeparator()).append((String)k).append(" : ").append(this.value));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueProviderCacheId) {
            return Objects.equals(this.value, ((ValueProviderCacheId)obj).value);
        }
        return false;
    }

    public static class ValueProviderCacheIdBuilder {
        private String sourceElementName;
        private String hashValue;
        private List<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        private Map<String, String> attributes = new HashMap<String, String>();

        public static ValueProviderCacheId aValueProviderCacheId(ValueProviderCacheIdBuilder builder) {
            return builder.build();
        }

        private ValueProviderCacheIdBuilder() {
        }

        public static ValueProviderCacheIdBuilder fromElementWithName(String sourceElementName) {
            ValueProviderCacheIdBuilder builder = new ValueProviderCacheIdBuilder();
            builder.sourceElementName = sourceElementName;
            return builder;
        }

        public ValueProviderCacheIdBuilder withHashValueFrom(Object hashedObject) {
            this.hashValue = Integer.toString(Objects.hash(hashedObject));
            return this;
        }

        public ValueProviderCacheIdBuilder containing(ValueProviderCacheId ... parts) {
            return this.containing(Arrays.asList(parts));
        }

        public ValueProviderCacheIdBuilder containing(List<ValueProviderCacheId> parts) {
            this.parts.addAll(parts);
            return this;
        }

        public ValueProviderCacheIdBuilder withAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        private ValueProviderCacheId build() {
            Preconditions.checkArgument(this.hashValue != null || !this.parts.isEmpty(), "ValueProviderCacheId must have a hashValue or parts");
            if (this.hashValue == null) {
                this.hashValue = "";
            }
            return new ValueProviderCacheId(this.sourceElementName, this.hashValue, this.parts, this.attributes);
        }
    }
}

