/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

public class StereotypeTypeAnnotation
implements TypeAnnotation {
    public static final String NAME = "stereotype";
    private final List<StereotypeModel> allowedStereotypes;
    private transient List<Class<? extends StereotypeDefinition>> definitionClasses;

    public static StereotypeTypeAnnotation fromDefinitions(List<Class<? extends StereotypeDefinition>> definitionClasses) {
        StereotypeTypeAnnotation annotation = new StereotypeTypeAnnotation(new ArrayList<StereotypeModel>(definitionClasses.size()));
        annotation.definitionClasses = definitionClasses;
        return annotation;
    }

    public StereotypeTypeAnnotation(List<StereotypeModel> allowedStereotypes) {
        this.allowedStereotypes = allowedStereotypes;
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public void resolveStereotypes(Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.definitionClasses.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply((Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    public void resolveStereotypes(ObjectType objectType, BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.definitionClasses.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply(objectType, (Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public int hashCode() {
        return this.allowedStereotypes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StereotypeTypeAnnotation other = (StereotypeTypeAnnotation)obj;
        return !(this.allowedStereotypes == null ? other.allowedStereotypes != null : !this.allowedStereotypes.equals(other.allowedStereotypes));
    }
}

