/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.config.dsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.config.dsl.XmlSdkConfigurationProvider;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.RequiredParameterNotSetException;

class XmlSdkConfigurationProviderFactory
extends AbstractExtensionObjectFactory<ConfigurationProvider>
implements ObjectFactory<ConfigurationProvider> {
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final LazyValue<String> configName = new LazyValue<Supplier<String>>(this::getName);
    private List<ConfigurationProvider> innerConfigProviders = Collections.emptyList();

    public XmlSdkConfigurationProviderFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
    }

    @Override
    public ConfigurationProvider doGetObject() throws Exception {
        HashMap<String, String> rawParams = new HashMap<String, String>();
        Set<Map.Entry<String, Object>> entrySet = this.getParameters().entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            rawParams.put(entry.getKey(), entry.getValue().toString());
        }
        return new XmlSdkConfigurationProvider(this.configName.get(), this.innerConfigProviders, rawParams, this.extensionModel, this.configurationModel);
    }

    public List<ConfigurationProvider> getInnerConfigProviders() {
        return this.innerConfigProviders;
    }

    public void setInnerConfigProviders(List<ConfigurationProvider> innerConfigProviders) {
        this.innerConfigProviders = Collections.unmodifiableList(innerConfigProviders);
    }

    public String getName() {
        return this.configurationModel.getAllParameterModels().stream().filter(ParameterModel::isComponentId).findAny().map(p -> this.parameters.get(p.getName()).toString()).orElseThrow(() -> new RequiredParameterNotSetException("cannot create a configuration without a name"));
    }
}

