/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.ComponentModelReader;
import org.mule.runtime.config.internal.dsl.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModulesModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.PrivateOperationsModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.TestConnectionGlobalElementModelProperty;
import org.mule.runtime.config.internal.dsl.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.internal.util.NoOpXmlErrorHandler;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.xml.declaration.DeclarationOperation;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.extension.internal.loader.validator.property.InvalidTestConnectionMarkerModelProperty;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.w3c.dom.Document;

public final class XmlExtensionLoaderDelegate {
    public static final String CYCLIC_OPERATIONS_ERROR = "Cyclic operations detected, offending ones: [%s]";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_DEFAULT_VALUE = "defaultValue";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MODULE_NAME = "name";
    private static final String MODULE_PREFIX_ATTRIBUTE = "prefix";
    private static final String MODULE_NAMESPACE_ATTRIBUTE = "namespace";
    private static final String MODULE_NAMESPACE_NAME = "module";
    protected static final String CONFIG_NAME = "config";
    private static final Map<String, ParameterRole> parameterRoleTypes = ImmutableMap.builder().put((Object)"BEHAVIOUR", (Object)ParameterRole.BEHAVIOUR).put((Object)"CONTENT", (Object)ParameterRole.CONTENT).put((Object)"PRIMARY", (Object)ParameterRole.PRIMARY_CONTENT).build();
    private static final String CATEGORY = "category";
    private static final String VENDOR = "vendor";
    private static final String DOC_DESCRIPTION = "doc:description";
    private static final String PASSWORD = "password";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String TAB_ATTRIBUTE = "tab";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String SUMMARY_ATTRIBUTE = "summary";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String ERROR_TYPE_ATTRIBUTE = "type";
    private static final String ROLE = "role";
    private static final String ATTRIBUTE_USE = "use";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String NAMESPACE_SEPARATOR = ":";
    private static final String TRANSFORMATION_FOR_TNS_RESOURCE = "META-INF/transform_for_tns.xsl";
    private static final String XMLNS_TNS = "xmlns:tns";
    public static final String MODULE_CONNECTION_MARKER_ATTRIBUTE = "xmlns:connection";
    private static final String GLOBAL_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("operation").build();
    private static final ComponentIdentifier OPERATION_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("property").build();
    private static final ComponentIdentifier CONNECTION_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("connection").build();
    private static final ComponentIdentifier OPERATION_PARAMETERS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameters").build();
    private static final ComponentIdentifier OPERATION_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameter").build();
    private static final ComponentIdentifier OPERATION_BODY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("body").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output-attributes").build();
    private static final ComponentIdentifier OPERATION_ERRORS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("errors").build();
    private static final ComponentIdentifier OPERATION_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("error").build();
    private static final ComponentIdentifier MODULE_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("module").build();
    public static final String XSD_SUFFIX = ".xsd";
    private static final String XML_SUFFIX = ".xml";
    private static final String TYPES_XML_SUFFIX = "-catalog.xml";
    private final String modulePath;
    private final boolean validateXml;
    private final Optional<String> declarationPath;
    private final List<String> resourcesPaths;
    private TypeResolver typeResolver;
    private Map<String, DeclarationOperation> declarationMap;

    private static ParameterRole getRole(String role) {
        if (!parameterRoleTypes.containsKey(role)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parametrized role [%s] doesn't match any of the expected types [%s]", role, String.join((CharSequence)", ", parameterRoleTypes.keySet())));
        }
        return parameterRoleTypes.get(role);
    }

    public XmlExtensionLoaderDelegate(String modulePath, boolean validateXml, Optional<String> declarationPath, List<String> resourcesPaths) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)modulePath) ? 1 : 0) != 0, (Object)"modulePath must not be empty");
        this.modulePath = modulePath;
        this.validateXml = validateXml;
        this.declarationPath = declarationPath;
        this.resourcesPaths = resourcesPaths;
    }

    public void declare(ExtensionLoadingContext context) {
        URL resource = this.getResource(this.modulePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("There's no reachable XML in the path '%s'", this.modulePath));
        }
        try {
            this.loadCustomTypes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The custom type file [%s] for the module '%s' cannot be read properly", this.getCustomTypeFilename(), this.modulePath), e);
        }
        this.loadDeclaration();
        ExtensionModelHelper extensionModelHelper = new ExtensionModelHelper(context.getDslResolvingContext().getExtensions(), context.getDslResolvingContext());
        Document moduleDocument = this.getModuleDocument(extensionModelHelper, resource);
        this.loadModuleExtension(context.getExtensionDeclarer(), resource, moduleDocument, extensionModelHelper, false);
    }

    private URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    private void loadCustomTypes() {
        String customTypes = this.getCustomTypeFilename();
        URL resourceCustomType = this.getResource(customTypes);
        this.typeResolver = resourceCustomType != null ? TypeResolver.createFrom(resourceCustomType, Thread.currentThread().getContextClassLoader()) : this.getEmptyTypeResolver();
    }

    private TypeResolver getEmptyTypeResolver() {
        return TypeResolver.create(Thread.currentThread().getContextClassLoader());
    }

    private String getCustomTypeFilename() {
        return this.modulePath.replace(XML_SUFFIX, TYPES_XML_SUFFIX);
    }

    private void loadDeclaration() {
        this.declarationMap = new HashMap<String, DeclarationOperation>();
        this.declarationPath.ifPresent(operationsOutputPathValue -> {
            URL operationsOutputResource = this.getResource((String)operationsOutputPathValue);
            if (operationsOutputResource != null) {
                try {
                    this.declarationMap = DeclarationOperation.fromString(IOUtils.toString((URL)operationsOutputResource));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("The declarations file [%s] for the module '%s' cannot be read properly", operationsOutputPathValue, this.modulePath), e);
                }
            }
        });
    }

    private Document getModuleDocument(ExtensionModelHelper extensionModelHelper, URL resource) {
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = this.validateXml ? XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader() : XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader(NoOpXmlErrorHandler::new);
        try {
            HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>(extensionModelHelper.getExtensionsModels());
            this.createTnsExtensionModel(resource, extensionModelHelper).ifPresent(extensions::add);
            return xmlConfigurationDocumentLoader.loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), new ModuleDelegatingEntityResolver(extensions), resource.getFile(), resource.openStream());
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an issue reading the stream for the resource %s", resource.getFile())));
        }
    }

    private Optional<ExtensionModel> createTnsExtensionModel(URL resource, ExtensionModelHelper extensionModelHelper) throws IOException {
        ExtensionModel result = null;
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(TRANSFORMATION_FOR_TNS_RESOURCE);){
            StreamSource xslt = new StreamSource(in);
            StreamSource moduleToTransform = new StreamSource(resource.openStream());
            TransformerFactory.newInstance().newTransformer(xslt).transform(moduleToTransform, new StreamResult((OutputStream)resultStream));
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an issue transforming the stream for the resource %s while trying to remove the content of the <body> element to generate an XSD", resource.getFile())), (Throwable)e);
        }
        Document transformedModuleDocument = XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader(NoOpXmlErrorHandler::new).loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), new ModuleDelegatingEntityResolver(extensionModelHelper.getExtensionsModels()), resource.getFile(), new ByteArrayInputStream(resultStream.toByteArray()));
        if (StringUtils.isNotBlank((CharSequence)transformedModuleDocument.getDocumentElement().getAttribute(XMLNS_TNS))) {
            ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
            this.loadModuleExtension(extensionDeclarer, resource, transformedModuleDocument, extensionModelHelper, true);
            result = this.createExtensionModel(extensionDeclarer);
        }
        return Optional.ofNullable(result);
    }

    private ComponentModel getModuleComponentModel(URL resource, Document moduleDocument, Set<ExtensionModel> extensions) {
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser(XmlNamespaceInfoProviderSupplier.createFromExtensionModels(extensions, Optional.empty()));
        Optional<ConfigLine> parseModule = xmlApplicationParser.parse(moduleDocument.getDocumentElement());
        if (!parseModule.isPresent()) {
            throw new IllegalArgumentException(String.format("There was an issue trying to read the stream of '%s'", resource.getFile()));
        }
        ConfigLine configLine = parseModule.get();
        ConfigurationPropertiesResolver externalPropertiesResolver = this.getConfigurationPropertiesResolver(configLine);
        ComponentModelReader componentModelReader = new ComponentModelReader(externalPropertiesResolver);
        return componentModelReader.extractComponentDefinitionModel(configLine, this.modulePath);
    }

    private ConfigurationPropertiesResolver getConfigurationPropertiesResolver(ConfigLine configLine) {
        DefaultConfigurationPropertiesResolver globalPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new XmlExtensionConfigurationPropertiesResolver()), this.createProviderFromGlobalProperties(configLine, this.modulePath));
        DefaultConfigurationPropertiesResolver systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), new EnvironmentPropertiesConfigurationProvider());
        String description = String.format("External files for smart connector '%s'", this.modulePath);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider(new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader()), description);
        return new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), externalPropertiesConfigurationProvider);
    }

    private ConfigurationPropertiesProvider createProviderFromGlobalProperties(ConfigLine moduleLine, String modulePath) {
        HashMap<String, ConfigurationProperty> globalProperties = new HashMap<String, ConfigurationProperty>();
        moduleLine.getChildren().stream().filter(configLine -> "global-property".equals(configLine.getIdentifier())).forEach(configLine -> {
            String key = configLine.getConfigAttributes().get("name").getValue();
            String rawValue = configLine.getConfigAttributes().get("value").getValue();
            globalProperties.put(key, new DefaultConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", modulePath, configLine.getLineNumber()), key, rawValue));
        });
        return new GlobalPropertyConfigurationPropertiesProvider(globalProperties);
    }

    private void loadModuleExtension(ExtensionDeclarer declarer, URL resource, Document moduleDocument, ExtensionModelHelper extensionModelHelper, boolean comesFromTNS) {
        ComponentModel moduleModel = this.getModuleComponentModel(resource, moduleDocument, extensionModelHelper.getExtensionsModels());
        if (!moduleModel.getIdentifier().equals(MODULE_IDENTIFIER)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("The root element of a module must be '%s', but found '%s'", MODULE_IDENTIFIER.toString(), moduleModel.getIdentifier().toString())));
        }
        moduleModel.resolveTypedComponentIdentifier(extensionModelHelper, true);
        String name = moduleModel.getRawParameters().get("name");
        String version = "4.0.0";
        String category = moduleModel.getRawParameters().get(CATEGORY);
        String vendor = moduleModel.getRawParameters().get(VENDOR);
        XmlDslModel xmlDslModel = this.getXmlDslModel(moduleModel, name, "4.0.0");
        String description = this.getDescription(moduleModel);
        String xmlnsTnsValue = moduleModel.getRawParameters().get(XMLNS_TNS);
        if (xmlnsTnsValue != null && !xmlDslModel.getNamespace().equals(xmlnsTnsValue)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("The %s attribute value of the module must be '%s', but found '%s'", XMLNS_TNS, xmlDslModel.getNamespace(), xmlnsTnsValue)));
        }
        this.resourcesPaths.stream().forEach(declarer::withResource);
        this.fillDeclarer(declarer, name, "4.0.0", category, vendor, xmlDslModel, description);
        declarer.withModelProperty(this.getXmlExtensionModelProperty(moduleModel, xmlDslModel));
        DefaultDirectedGraph directedGraph = new DefaultDirectedGraph(DefaultEdge.class);
        List<ComponentModel> globalElementsComponentModel = this.extractGlobalElementsFrom(moduleModel);
        this.addGlobalElementModelProperty(declarer, globalElementsComponentModel);
        Optional<ConfigurationDeclarer> configurationDeclarer = this.loadPropertiesFrom(declarer, moduleModel, globalElementsComponentModel, extensionModelHelper);
        ExtensionDeclarer hasOperationDeclarer = configurationDeclarer.isPresent() ? (HasOperationDeclarer)configurationDeclarer.get() : declarer;
        ExtensionDeclarer temporalPublicOpsDeclarer = new ExtensionDeclarer();
        this.fillDeclarer(temporalPublicOpsDeclarer, name, "4.0.0", category, vendor, xmlDslModel, description);
        this.loadOperationsFrom(hasOperationDeclarer, moduleModel, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PUBLIC);
        this.loadOperationsFrom(temporalPublicOpsDeclarer, moduleModel, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PUBLIC);
        try {
            this.enrichModuleModel((ComponentAst)((Object)moduleModel), this.createExtensionModel(temporalPublicOpsDeclarer));
        }
        catch (IllegalModelDefinitionException illegalModelDefinitionException) {
            // empty catch block
        }
        if (comesFromTNS) {
            this.loadOperationsFrom(hasOperationDeclarer, moduleModel, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PRIVATE);
        } else {
            ExtensionDeclarer temporalPrivateOpsDeclarer = new ExtensionDeclarer();
            this.fillDeclarer(temporalPrivateOpsDeclarer, name, "4.0.0", category, vendor, xmlDslModel, description);
            this.loadOperationsFrom(temporalPrivateOpsDeclarer, moduleModel, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PRIVATE);
            ExtensionModel result = this.createExtensionModel(temporalPrivateOpsDeclarer);
            PrivateOperationsModelProperty privateOperations = new PrivateOperationsModelProperty(result.getOperationModels());
            declarer.withModelProperty(privateOperations);
            this.enrichModuleModel((ComponentAst)((Object)moduleModel), result);
        }
        CycleDetector cycleDetector = new CycleDetector((Graph)directedGraph);
        Set cycles = cycleDetector.findCycles();
        if (!cycles.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format(CYCLIC_OPERATIONS_ERROR, new TreeSet(cycles))));
        }
    }

    private void enrichModuleModel(ComponentAst moduleModel, ExtensionModel result) {
        moduleModel.recursiveStream().forEach(comp -> result.getOperationModel(comp.getIdentifier().getName()).ifPresent(model -> ((ComponentModel)((Object)comp)).setComponentModel((org.mule.runtime.api.meta.model.ComponentModel)model)));
    }

    private ExtensionModel createExtensionModel(ExtensionDeclarer declarer) {
        return new ExtensionModelFactory().create(new DefaultExtensionLoadingContext(declarer, Thread.currentThread().getContextClassLoader(), new NullDslResolvingContext()));
    }

    private void fillDeclarer(ExtensionDeclarer declarer, String name, String version, String category, String vendor, XmlDslModel xmlDslModel, String description) {
        declarer.named(name).describedAs(description).fromVendor(vendor).onVersion(version).withCategory(Category.valueOf(category.toUpperCase())).withXmlDsl(xmlDslModel);
    }

    private XmlExtensionModelProperty getXmlExtensionModelProperty(ComponentModel moduleModel, XmlDslModel xmlDslModel) {
        Set<String> namespaceDependencies = MacroExpansionModulesModel.getUsedNamespaces(moduleModel).stream().filter(namespace -> !xmlDslModel.getNamespace().equals(namespace)).collect(Collectors.toSet());
        return new XmlExtensionModelProperty(namespaceDependencies);
    }

    private XmlDslModel getXmlDslModel(ComponentModel moduleModel, String name, String version) {
        Optional<String> prefix = Optional.ofNullable(moduleModel.getRawParameters().get(MODULE_PREFIX_ATTRIBUTE));
        Optional<String> namespace = Optional.ofNullable(moduleModel.getRawParameters().get(MODULE_NAMESPACE_ATTRIBUTE));
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, name, version);
    }

    private String getDescription(ComponentModel componentModel) {
        return componentModel.getRawParameters().getOrDefault(DOC_DESCRIPTION, "");
    }

    private List<ComponentModel> extractGlobalElementsFrom(ComponentModel moduleModel) {
        HashSet NOT_GLOBAL_ELEMENT_IDENTIFIERS = Sets.newHashSet((Object[])new ComponentIdentifier[]{OPERATION_PROPERTY_IDENTIFIER, CONNECTION_PROPERTIES_IDENTIFIER, OPERATION_IDENTIFIER});
        return moduleModel.getInnerComponents().stream().filter(child -> !NOT_GLOBAL_ELEMENT_IDENTIFIERS.contains(child.getIdentifier())).collect(Collectors.toList());
    }

    private Optional<ConfigurationDeclarer> loadPropertiesFrom(ExtensionDeclarer declarer, ComponentModel moduleModel, List<ComponentModel> globalElementsComponentModel, ExtensionModelHelper extensionModelHelper) {
        List<ComponentModel> configurationProperties = this.extractProperties(moduleModel);
        List<ComponentModel> connectionProperties = this.extractConnectionProperties(moduleModel);
        this.validateProperties(configurationProperties, connectionProperties);
        if (!configurationProperties.isEmpty() || !connectionProperties.isEmpty()) {
            declarer.withModelProperty(new NoReconnectionStrategyModelProperty());
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(CONFIG_NAME);
            configurationProperties.forEach(param -> this.extractProperty(configurationDeclarer, (ComponentModel)param));
            this.addConnectionProvider(configurationDeclarer, connectionProperties, globalElementsComponentModel, extensionModelHelper);
            return Optional.of(configurationDeclarer);
        }
        return Optional.empty();
    }

    private void addGlobalElementModelProperty(ExtensionDeclarer declarer, List<ComponentModel> globalElementsComponentModel) {
        if (!globalElementsComponentModel.isEmpty()) {
            declarer.withModelProperty(new GlobalElementComponentModelModelProperty(globalElementsComponentModel));
        }
    }

    private List<ComponentModel> extractProperties(ComponentModel moduleModel) {
        return moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PROPERTY_IDENTIFIER)).collect(Collectors.toList());
    }

    private List<ComponentModel> extractConnectionProperties(ComponentModel moduleModel) {
        List connectionsComponentModel = moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(CONNECTION_PROPERTIES_IDENTIFIER)).collect(Collectors.toList());
        if (connectionsComponentModel.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There cannot be more than 1 child [%s] element per [%s], found [%d]", CONNECTION_PROPERTIES_IDENTIFIER.getName(), MODULE_IDENTIFIER.getName(), connectionsComponentModel.size())));
        }
        return connectionsComponentModel.isEmpty() ? Collections.emptyList() : this.extractProperties((ComponentModel)connectionsComponentModel.get(0));
    }

    private void validateProperties(List<ComponentModel> configurationProperties, List<ComponentModel> connectionProperties) {
        List connectionPropertiesNames = connectionProperties.stream().map(ComponentModel::getNameAttribute).collect(Collectors.toList());
        List intersectedProperties = configurationProperties.stream().map(ComponentModel::getNameAttribute).filter(connectionPropertiesNames::contains).collect(Collectors.toList());
        if (!intersectedProperties.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There cannot be properties with the same name even if they are within a <connection>, repeated properties are: [%s]", intersectedProperties.stream().collect(Collectors.joining(", ")))));
        }
    }

    private void addConnectionProvider(ConfigurationDeclarer configurationDeclarer, List<ComponentModel> connectionProperties, List<ComponentModel> globalElementsComponentModel, ExtensionModelHelper extensionModelHelper) {
        Optional<ComponentModel> testConnectionGlobalElementOptional = this.getTestConnectionGlobalElement(configurationDeclarer, globalElementsComponentModel, extensionModelHelper);
        if (testConnectionGlobalElementOptional.isPresent() || !connectionProperties.isEmpty()) {
            ConnectionProviderDeclarer connectionProviderDeclarer = configurationDeclarer.withConnectionProvider("connection");
            connectionProviderDeclarer.withConnectionManagementType(ConnectionManagementType.NONE);
            connectionProperties.stream().forEach(param -> this.extractProperty(connectionProviderDeclarer, (ComponentModel)param));
            testConnectionGlobalElementOptional.ifPresent(testConnectionGlobalElement -> {
                String testConnectionGlobalElementName = testConnectionGlobalElement.getRawParameters().get("name");
                connectionProviderDeclarer.withModelProperty(new TestConnectionGlobalElementModelProperty(testConnectionGlobalElementName));
            });
        }
    }

    private Optional<ComponentModel> getTestConnectionGlobalElement(ConfigurationDeclarer configurationDeclarer, List<ComponentModel> globalElementsComponentModel, ExtensionModelHelper extensionModelHelper) {
        List markedAsTestConnectionGlobalElements = globalElementsComponentModel.stream().filter(globalElementComponentModel -> Boolean.parseBoolean(globalElementComponentModel.getRawParameters().get(MODULE_CONNECTION_MARKER_ATTRIBUTE))).collect(Collectors.toList());
        if (markedAsTestConnectionGlobalElements.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("It can only be one global element marked as test connectivity [%s] but found [%d], offended global elements are: [%s]", MODULE_CONNECTION_MARKER_ATTRIBUTE, markedAsTestConnectionGlobalElements.size(), markedAsTestConnectionGlobalElements.stream().map(ComponentModel::getNameAttribute).collect(Collectors.joining(", ")))));
        }
        Optional<Object> testConnectionGlobalElement = markedAsTestConnectionGlobalElements.stream().findFirst();
        if (!testConnectionGlobalElement.isPresent()) {
            testConnectionGlobalElement = this.findTestConnectionGlobalElementFrom(globalElementsComponentModel, extensionModelHelper);
        } else {
            Optional<ComponentModel> temporalTestConnectionGlobalElement = this.findTestConnectionGlobalElementFrom(Collections.singletonList(testConnectionGlobalElement.get()), extensionModelHelper);
            if (!temporalTestConnectionGlobalElement.isPresent() || !temporalTestConnectionGlobalElement.get().equals(testConnectionGlobalElement.get())) {
                configurationDeclarer.withModelProperty(new InvalidTestConnectionMarkerModelProperty(testConnectionGlobalElement.get().getNameAttribute(), testConnectionGlobalElement.get().getIdentifier().toString()));
            }
        }
        return testConnectionGlobalElement;
    }

    private Optional<ComponentModel> findTestConnectionGlobalElementFrom(List<ComponentModel> globalElementsComponentModel, ExtensionModelHelper extensionModelHelper) {
        List testConnectionComponentModels = globalElementsComponentModel.stream().filter(globalElementComponentModel -> globalElementComponentModel.getModel(ConfigurationModel.class).map(configurationModel -> configurationModel.getConnectionProviders().stream().anyMatch(ConnectionProviderModel::supportsConnectivityTesting)).orElse(false)).collect(Collectors.toList());
        if (testConnectionComponentModels.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There are [%d] global elements that can be potentially used for test connection when it should be just one. Mark any of them with the attribute [%s=\"true\"], offended global elements are: [%s]", testConnectionComponentModels.size(), MODULE_CONNECTION_MARKER_ATTRIBUTE, testConnectionComponentModels.stream().map(ComponentModel::getNameAttribute).sorted().collect(Collectors.joining(", ")))));
        }
        return testConnectionComponentModels.stream().findFirst();
    }

    private void loadOperationsFrom(HasOperationDeclarer declarer, ComponentModel moduleModel, Graph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel, OperationVisibility visibility) {
        moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_IDENTIFIER)).filter(operationModel -> OperationVisibility.valueOf(operationModel.getRawParameters().get(ATTRIBUTE_VISIBILITY)) == visibility).forEach(operationModel -> this.extractOperationExtension(declarer, (ComponentModel)operationModel, directedGraph, xmlDslModel));
    }

    private void extractOperationExtension(HasOperationDeclarer declarer, ComponentModel operationModel, Graph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel) {
        String operationName = operationModel.getNameAttribute();
        OperationDeclarer operationDeclarer = declarer.withOperation(operationName);
        ComponentModel bodyComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_BODY_IDENTIFIER)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The operation '%s' is missing the <body> statement", operationName)));
        directedGraph.addVertex((Object)operationName);
        this.fillGraphWithTnsReferences(directedGraph, operationName, bodyComponentModel.getInnerComponents());
        operationDeclarer.withModelProperty(new OperationComponentModelModelProperty(operationModel, bodyComponentModel));
        operationDeclarer.describedAs(this.getDescription(operationModel));
        ((OperationDeclaration)operationDeclarer.getDeclaration()).setDisplayModel(this.getDisplayModel(operationModel));
        this.extractOperationParameters(operationDeclarer, operationModel);
        this.extractOutputType(operationDeclarer.withOutput(), OPERATION_OUTPUT_IDENTIFIER, operationModel, this.getDeclarationOutputFor(operationName));
        this.extractOutputType(operationDeclarer.withOutputAttributes(), OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER, operationModel, this.getDeclarationOutputAttributesFor(operationName));
        this.declareErrorModels(operationDeclarer, xmlDslModel, operationName, operationModel);
    }

    private Optional<MetadataType> getDeclarationOutputFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutput());
        }
        return result;
    }

    private Optional<MetadataType> getDeclarationOutputAttributesFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutputAttributes());
        }
        return result;
    }

    private void fillGraphWithTnsReferences(Graph<String, DefaultEdge> directedGraph, String sourceOperationVertex, List<ComponentModel> innerComponents) {
        innerComponents.forEach(childMPComponentModel -> {
            if ("tns".equals(childMPComponentModel.getIdentifier().getNamespace())) {
                String targetOperationVertex = childMPComponentModel.getIdentifier().getName();
                if (!directedGraph.containsVertex((Object)targetOperationVertex)) {
                    directedGraph.addVertex((Object)targetOperationVertex);
                }
                directedGraph.addEdge((Object)sourceOperationVertex, (Object)targetOperationVertex);
            } else {
                childMPComponentModel.getInnerComponents().forEach(childChildMPComponentModel -> this.fillGraphWithTnsReferences(directedGraph, sourceOperationVertex, childMPComponentModel.getInnerComponents()));
            }
        });
    }

    private void extractOperationParameters(OperationDeclarer operationDeclarer, ComponentModel componentModel) {
        Optional<ComponentModel> optionalParametersComponentModel = componentModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETERS_IDENTIFIER)).findAny();
        if (optionalParametersComponentModel.isPresent()) {
            optionalParametersComponentModel.get().getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETER_IDENTIFIER)).forEach(param -> {
                String role = param.getRawParameters().get(ROLE);
                this.extractParameter(operationDeclarer, (ComponentModel)param, XmlExtensionLoaderDelegate.getRole(role));
            });
        }
    }

    private void extractProperty(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param) {
        this.extractParameter(parameterizedDeclarer, param, ParameterRole.BEHAVIOUR);
    }

    private void extractParameter(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param, ParameterRole role) {
        Map<String, String> parameters = param.getRawParameters();
        String receivedInputType = parameters.get("type");
        LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
        if (Boolean.parseBoolean(parameters.get(PASSWORD))) {
            layoutModelBuilder.asPassword();
        }
        layoutModelBuilder.order(this.getOrder(parameters.get(ORDER_ATTRIBUTE)));
        layoutModelBuilder.tabName(this.getTab(parameters.get(TAB_ATTRIBUTE)));
        DisplayModel displayModel = this.getDisplayModel(param);
        MetadataType parameterType = this.extractType(receivedInputType);
        ParameterDeclarer parameterDeclarer = this.getParameterDeclarer(parameterizedDeclarer, parameters);
        ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)parameterDeclarer.describedAs(this.getDescription(param))).withLayout(layoutModelBuilder.build())).withDisplayModel(displayModel)).withRole(role)).ofType(parameterType);
    }

    private DisplayModel getDisplayModel(ComponentModel componentModel) {
        DisplayModel.DisplayModelBuilder displayModelBuilder = DisplayModel.builder();
        displayModelBuilder.displayName(componentModel.getRawParameters().get(DISPLAY_NAME_ATTRIBUTE));
        displayModelBuilder.summary(componentModel.getRawParameters().get(SUMMARY_ATTRIBUTE));
        displayModelBuilder.example(componentModel.getRawParameters().get(EXAMPLE_ATTRIBUTE));
        return displayModelBuilder.build();
    }

    private String getTab(String tab) {
        return StringUtils.isBlank((CharSequence)tab) ? "General" : tab;
    }

    private int getOrder(String order) {
        try {
            return Integer.parseInt(order);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private ParameterDeclarer getParameterDeclarer(ParameterizedDeclarer parameterizedDeclarer, Map<String, String> parameters) {
        String parameterName = parameters.get("name");
        String parameterDefaultValue = parameters.get(PARAMETER_DEFAULT_VALUE);
        UseEnum use = UseEnum.valueOf(parameters.get(ATTRIBUTE_USE));
        if (UseEnum.REQUIRED.equals((Object)use) && StringUtils.isNotBlank((CharSequence)parameterDefaultValue)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] cannot have the %s attribute set to %s when it has a default value", new Object[]{parameterName, ATTRIBUTE_USE, UseEnum.REQUIRED}));
        }
        boolean parameterRequired = UseEnum.REQUIRED.equals((Object)use) || UseEnum.AUTO.equals((Object)use) && StringUtils.isBlank((CharSequence)parameterDefaultValue);
        return parameterRequired ? parameterizedDeclarer.onDefaultParameterGroup().withRequiredParameter(parameterName) : parameterizedDeclarer.onDefaultParameterGroup().withOptionalParameter(parameterName).defaultingTo(parameterDefaultValue);
    }

    private void extractOutputType(OutputDeclarer outputDeclarer, ComponentIdentifier componentIdentifier, ComponentModel operationModel, Optional<MetadataType> calculatedOutput) {
        Optional<ComponentModel> outputAttributesComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(componentIdentifier)).findFirst();
        outputAttributesComponentModel.ifPresent(outputComponentModel -> outputDeclarer.describedAs(this.getDescription((ComponentModel)outputComponentModel)));
        MetadataType metadataType = this.getMetadataType(outputAttributesComponentModel, calculatedOutput);
        outputDeclarer.ofType(metadataType);
    }

    private MetadataType getMetadataType(Optional<ComponentModel> outputAttributesComponentModel, Optional<MetadataType> declarationMetadataType) {
        MetadataType metadataType;
        if (declarationMetadataType.isPresent()) {
            metadataType = declarationMetadataType.get();
        } else if (outputAttributesComponentModel.isPresent()) {
            String receivedOutputAttributeType = outputAttributesComponentModel.get().getRawParameters().get("type");
            metadataType = this.extractType(receivedOutputAttributeType);
        } else {
            metadataType = BaseTypeBuilder.create(MetadataFormat.JAVA).voidType().build();
        }
        return metadataType;
    }

    private MetadataType extractType(String receivedType) {
        Optional<Object> metadataType;
        block3: {
            metadataType = Optional.empty();
            try {
                metadataType = this.typeResolver.resolveType(receivedType);
            }
            catch (TypeResolverException e) {
                if (metadataType.isPresent()) break block3;
                throw new IllegalParameterModelDefinitionException(String.format("The type obtained [%s] cannot be resolved", receivedType), e);
            }
        }
        if (!metadataType.isPresent()) {
            String errorMessage = String.format("should not have reach here. Type obtained [%s] when supported default types are [%s].", receivedType, String.join((CharSequence)", ", PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.keySet()));
            throw new IllegalParameterModelDefinitionException(errorMessage);
        }
        return (MetadataType)metadataType.get();
    }

    private void declareErrorModels(OperationDeclarer operationDeclarer, XmlDslModel xmlDslModel, String operationName, ComponentModel operationModel) {
        Optional<ComponentModel> optionalParametersComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_ERRORS_IDENTIFIER)).findAny();
        optionalParametersComponentModel.ifPresent(componentModel -> componentModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_ERROR_IDENTIFIER)).forEach(param -> {
            String namespace = xmlDslModel.getPrefix().toUpperCase();
            String typeName = param.getRawParameters().get("type");
            if (StringUtils.isBlank((CharSequence)typeName)) {
                throw new IllegalModelDefinitionException(String.format("The operation [%s] cannot have an <error> with an empty 'type' attribute", operationName));
            }
            if (typeName.contains(NAMESPACE_SEPARATOR)) {
                throw new IllegalModelDefinitionException(String.format("The operation [%s] cannot have an <error> [%s] that contains a reserved character [%s]", operationName, typeName, NAMESPACE_SEPARATOR));
            }
            operationDeclarer.withErrorModel(ErrorModelBuilder.newError(typeName, namespace).withParent(ErrorModelBuilder.newError(Errors.ComponentIdentifiers.Handleable.ANY).build()).build());
        }));
    }

    private class XmlExtensionConfigurationPropertiesResolver
    implements ConfigurationPropertiesResolver {
        private XmlExtensionConfigurationPropertiesResolver() {
        }

        @Override
        public Object resolveValue(String value) {
            return value;
        }

        @Override
        public Object resolvePlaceholderKeyValue(String placeholderKey) {
            return placeholderKey;
        }
    }

    private static enum OperationVisibility {
        PRIVATE,
        PUBLIC;

    }

    private static enum UseEnum {
        REQUIRED,
        OPTIONAL,
        AUTO;

    }
}

