/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class CorrectPrefixesValidator
implements ExtensionModelValidator {
    private static final String SEPARATOR = ":";
    public static final String TYPE_RAISE_ERROR_ATTRIBUTE = "type";
    public static final String EMPTY_TYPE_FORMAT_MESSAGE = "When using a %s the '%s' must not be null nor empty, offending operation '%s'";
    public static final String WRONG_VALUE_FORMAT_MESSAGE = "When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'";

    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            @Override
            protected void onOperation(HasOperationModels owner, OperationModel operationModel) {
                operationModel.getModelProperty(OperationComponentModelModelProperty.class).ifPresent(operationComponentModelModelProperty -> CorrectPrefixesValidator.this.searchAndValidate(extensionModel.getXmlDslModel().getPrefix(), operationModel, operationComponentModelModelProperty.getBodyComponentModel(), problemsReporter));
            }
        }.walk(extensionModel);
    }

    private void searchAndValidate(String namespace, OperationModel operationModel, ComponentModel componentModel, ProblemsReporter problemsReporter) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.RAISE_ERROR_IDENTIFIER)) {
            this.validateRaiseError(namespace, operationModel, componentModel, problemsReporter);
        } else if (componentModel.getIdentifier().equals(ApplicationModel.ERROR_MAPPING_IDENTIFIER)) {
            this.validateErrorMapping(namespace, operationModel, componentModel, problemsReporter);
        }
        for (ComponentModel childComponentModel : componentModel.getInnerComponents()) {
            this.searchAndValidate(namespace, operationModel, childComponentModel, problemsReporter);
        }
    }

    private void validateRaiseError(String moduleNamespace, OperationModel operationModel, ComponentModel raiseErrorComponentModel, ProblemsReporter problemsReporter) {
        this.genericValidation(moduleNamespace, operationModel, raiseErrorComponentModel, problemsReporter, TYPE_RAISE_ERROR_ATTRIBUTE, CoreDslConstants.RAISE_ERROR_IDENTIFIER);
    }

    private void validateErrorMapping(String moduleNamespace, OperationModel operationModel, ComponentModel errorMappingComponentModel, ProblemsReporter problemsReporter) {
        this.genericValidation(moduleNamespace, operationModel, errorMappingComponentModel, problemsReporter, "targetType", ApplicationModel.ERROR_MAPPING_IDENTIFIER);
    }

    private void genericValidation(String moduleNamespace, OperationModel operationModel, ComponentModel elementComponentModel, ProblemsReporter problemsReporter, String attributeToValidate, ComponentIdentifier workingIdentifier) {
        String stringRepresentation = elementComponentModel.getRawParameters().get(attributeToValidate);
        if (StringUtils.isBlank(stringRepresentation)) {
            problemsReporter.addError(new Problem(operationModel, String.format(EMPTY_TYPE_FORMAT_MESSAGE, workingIdentifier.toString(), attributeToValidate, operationModel.getName())));
        } else {
            int separator = stringRepresentation.indexOf(SEPARATOR);
            if (separator > 0) {
                String namespace = stringRepresentation.substring(0, separator).toUpperCase();
                if (!moduleNamespace.toUpperCase().equals(namespace)) {
                    problemsReporter.addError(new Problem(operationModel, String.format(WRONG_VALUE_FORMAT_MESSAGE, workingIdentifier.toString(), attributeToValidate, BeanDefinitionFactory.CORE_ERROR_NS, moduleNamespace.toUpperCase(), namespace, operationModel.getName())));
                }
            }
        }
    }
}

