/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingUtils;
import org.mule.runtime.module.extension.internal.runtime.exception.RequiredParameterNotSetException;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public abstract class AbstractExtensionObjectFactory<T>
extends AbstractComponentFactory<T>
implements ObjectTypeParametersResolver {
    @Inject
    protected ConfigurationProperties properties;
    @Inject
    protected ReflectionCache reflectionCache;
    @Inject
    protected ExpressionManager expressionManager;
    protected final MuleContext muleContext;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    private LazyValue<ParametersResolver> parametersResolver;

    public AbstractExtensionObjectFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.parametersResolver = new LazyValue<Supplier<ParametersResolver>>(() -> this.parametersResolverFromValues(muleContext));
    }

    @Override
    public T getObject() throws Exception {
        try {
            return super.getObject();
        }
        catch (RequiredParameterNotSetException e) {
            throw this.handleMissingRequiredParameter(e);
        }
    }

    private Exception handleMissingRequiredParameter(RequiredParameterNotSetException e) {
        String description = this.getAnnotations().values().stream().filter(v -> v instanceof ComponentLocation).map(v -> (ComponentLocation)v).findFirst().map(v -> String.format("Element <%s:%s> in line %s of file %s is missing required parameter '%s'", v.getComponentIdentifier().getIdentifier().getNamespace(), v.getComponentIdentifier().getIdentifier().getName(), v.getLineInFile().map(n -> "" + n).orElse("<UNKNOWN>"), v.getFileName().orElse("<UNKNOWN>"), NameUtils.hyphenize(e.getParameterName()))).orElse(e.getMessage());
        return new ConfigurationException(I18nMessageFactory.createStaticMessage(description), (Throwable)e);
    }

    protected ParametersResolver getParametersResolver() {
        return this.parametersResolver.get();
    }

    private ParametersResolver parametersResolverFromValues(MuleContext muleContext) {
        return ParametersResolver.fromValues(this.parameters, muleContext, LifecycleUtils.isLazyInitMode(this.properties), this.reflectionCache, this.expressionManager);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = this.normalize(parameters);
        this.parametersResolver = new LazyValue<ParametersResolver>(this.parametersResolverFromValues(this.muleContext));
    }

    @Override
    public void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder) {
        this.parametersResolver.get().resolveParameterGroups(objectType, builder);
    }

    @Override
    public void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder) {
        this.parametersResolver.get().resolveParameters(objectType, builder);
    }

    private Map<String, Object> normalize(Map<String, Object> parameters) {
        HashMap<String, Object> normalized = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            String normalizedKey = key;
            if (ExtensionParsingUtils.isChildKey(key)) {
                normalizedKey = ExtensionParsingUtils.unwrapChildKey(key);
                normalized.put(normalizedKey, value);
            } else if (!normalized.containsKey(normalizedKey)) {
                normalized.put(normalizedKey, value);
            }
        });
        return normalized;
    }
}

