/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher.stereotypes;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.StereotypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.FunctionalUtils;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.ImplicitStereotypeDefinition;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.ClassStereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.MethodStereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public class StereotypesDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.WIRING;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader(extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate().apply(extensionLoadingContext));
    }

    private static class EnricherDelegate {
        private final Map<StereotypeDefinition, StereotypeModel> stereotypes = new HashMap<StereotypeDefinition, StereotypeModel>();
        private Multimap<ComponentDeclaration, ConfigurationDeclaration> componentConfigs = LinkedListMultimap.create();
        private String namespace;
        private StereotypeModel sourceParent;
        private StereotypeModel processorParent;
        private ClassTypeLoader typeLoader;
        private DslResolvingContext dslResolvingContext;

        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            this.dslResolvingContext = extensionLoadingContext.getDslResolvingContext();
            ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
            this.typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader(extensionLoadingContext.getExtensionClassLoader());
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            this.namespace = this.getStereotypePrefix(extensionDeclarer);
            this.processorParent = StereotypeModelBuilder.newStereotype(MuleStereotypes.PROCESSOR.getType(), this.namespace).withParent(MuleStereotypes.PROCESSOR).build();
            this.sourceParent = StereotypeModelBuilder.newStereotype(MuleStereotypes.SOURCE.getType(), this.namespace).withParent(MuleStereotypes.SOURCE).build();
            IdempotentDeclarationWalker enricher = declaration.getModelProperty(ImplementingTypeModelProperty.class).isPresent() ? this.getJavaBasedStereotypeEnricher() : this.getDefaultStereotypeEnricher();
            enricher.walk(declaration);
            this.resolveDeclaredTypesStereotypes(declaration, this.namespace);
        }

        private IdempotentDeclarationWalker getJavaBasedStereotypeEnricher() {
            return new IdempotentDeclarationWalker(){

                @Override
                protected void onConfiguration(ConfigurationDeclaration config) {
                    StereotypeModel defaultStereotype = this.createStereotype(config.getName(), MuleStereotypes.CONFIG);
                    FunctionalUtils.ifPresent(config.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(ExtensionTypeDescriptorModelProperty::getType), type -> this.resolveStereotype((Type)type, config, defaultStereotype), () -> config.withStereotype(defaultStereotype));
                    componentConfigs = this.populateComponentConfigsMap(config);
                }

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), MuleStereotypes.CONNECTION);
                    FunctionalUtils.ifPresent(declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(ExtensionTypeDescriptorModelProperty::getType), type -> this.resolveStereotype((Type)type, declaration, defaultStereotype), () -> declaration.withStereotype(defaultStereotype));
                }

                @Override
                protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), processorParent);
                    FunctionalUtils.ifPresent(declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(method -> new MethodWrapper((Method)method, typeLoader)), methodElement -> this.resolveStereotype((MethodWrapper<?>)methodElement, declaration, defaultStereotype), () -> declaration.withStereotype(defaultStereotype));
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }

                @Override
                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), processorParent);
                    FunctionalUtils.ifPresent(declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(method -> new OperationWrapper((Method)method, typeLoader)), methodElement -> this.resolveStereotype((MethodWrapper<?>)methodElement, declaration, defaultStereotype), () -> declaration.withStereotype(defaultStereotype));
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), sourceParent);
                    FunctionalUtils.ifPresent(declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).map(declaringType -> new TypeWrapper((Class<?>)declaringType, typeLoader)), type -> this.resolveStereotype((Type)type, declaration, defaultStereotype), () -> declaration.withStereotype(defaultStereotype));
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }

                private void resolveStereotype(Type type, StereotypedDeclaration<?> declaration, StereotypeModel fallback) {
                    new ClassStereotypeResolver(type, (WithStereotypesDeclaration)declaration, namespace, fallback, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype();
                }

                private void resolveStereotype(MethodWrapper<?> method, ComponentDeclaration<?> declaration, StereotypeModel fallback) {
                    new MethodStereotypeResolver(method, declaration, namespace, fallback, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype();
                }
            };
        }

        private IdempotentDeclarationWalker getDefaultStereotypeEnricher() {
            return new IdempotentDeclarationWalker(){

                @Override
                protected void onConfiguration(ConfigurationDeclaration config) {
                    StereotypeModel defaultStereotype = this.createStereotype(config.getName(), MuleStereotypes.CONFIG);
                    config.withStereotype(defaultStereotype);
                    componentConfigs = this.populateComponentConfigsMap(config);
                }

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), MuleStereotypes.CONNECTION);
                    declaration.withStereotype(defaultStereotype);
                }

                @Override
                protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), processorParent);
                    declaration.withStereotype(defaultStereotype);
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }

                @Override
                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), processorParent);
                    declaration.withStereotype(defaultStereotype);
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    StereotypeModel defaultStereotype = this.createStereotype(declaration.getName(), sourceParent);
                    declaration.withStereotype(defaultStereotype);
                    this.addConfigRefStereoTypesIfNeeded(declaration);
                }
            };
        }

        private StereotypeModel createStereotype(String name, StereotypeModel parent) {
            return StereotypeModelBuilder.newStereotype(name, this.namespace).withParent(parent).build();
        }

        private void resolveDeclaredTypesStereotypes(ExtensionDeclaration declaration, String namespace) {
            HashMap subTypeToParent = new HashMap();
            declaration.getSubTypes().forEach(subTypeModel -> subTypeModel.getSubTypes().forEach(subType -> subTypeToParent.put(subType, subTypeModel.getBaseType())));
            BiFunction<ObjectType, Class, StereotypeModel> resolver = (type, def) -> this.resolveStereotype((Class<? extends StereotypeDefinition>)def, (ObjectType)type, namespace, subTypeToParent);
            declaration.getTypes().forEach(type -> this.resolveStereotype((ObjectType)type, (BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel>)resolver));
        }

        private StereotypeModel resolveStereotype(Class<? extends StereotypeDefinition> def, ObjectType type, String namespace, Map<ObjectType, ObjectType> subTypeToParent) {
            if (def.equals(ImplicitStereotypeDefinition.class)) {
                namespace = this.resolveImportedTypeNamespace(type, namespace);
                String stereotypeName = this.toStereotypeName(type.getAnnotation(ClassInformationAnnotation.class).get().getClassname());
                ObjectType parentObjectType = subTypeToParent.get(type);
                if (parentObjectType != null) {
                    return StereotypeResolver.getStereotype(new ImplicitStereotypeDefinition(stereotypeName, new ImplicitStereotypeDefinition(this.toStereotypeName(parentObjectType.getAnnotation(ClassInformationAnnotation.class).get().getClassname()))), namespace, this.stereotypes);
                }
                return StereotypeResolver.getStereotype(new ImplicitStereotypeDefinition(stereotypeName), namespace, this.stereotypes);
            }
            return StereotypeResolver.createCustomStereotype(def, namespace, this.stereotypes);
        }

        private String toStereotypeName(String classname) {
            return NameUtils.underscorize(classname.substring(classname.lastIndexOf(".") + 1)).toUpperCase();
        }

        private String resolveImportedTypeNamespace(ObjectType type, String namespace) {
            return MetadataTypeUtils.getTypeId(type).flatMap(typeId -> this.dslResolvingContext.getExtensionForType((String)typeId)).map(extensionModel -> extensionModel.getXmlDslModel().getPrefix().toUpperCase()).orElse(namespace);
        }

        private void resolveStereotype(ObjectType type, final BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
            type.accept(new MetadataTypeVisitor(){
                private final List<MetadataType> registeredTypes = new LinkedList<MetadataType>();

                @Override
                public void visitObject(ObjectType objectType) {
                    if (!this.registeredTypes.contains(objectType) && !objectType.getAnnotation(InfrastructureTypeAnnotation.class).isPresent()) {
                        this.registeredTypes.add(objectType);
                        objectType.getAnnotation(StereotypeTypeAnnotation.class).ifPresent(a -> a.resolveStereotypes(objectType, resolver));
                        objectType.getFields().forEach(f -> f.getValue().accept(this));
                        objectType.getOpenRestriction().ifPresent(open -> open.accept(this));
                    }
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept(this);
                }

                @Override
                public void visitUnion(UnionType unionType) {
                    unionType.getTypes().forEach(t -> t.accept(this));
                }

                @Override
                public void visitIntersection(IntersectionType intersectionType) {
                    intersectionType.getTypes().forEach(t -> t.accept(this));
                }
            });
        }

        private String getStereotypePrefix(ExtensionDeclarer extensionDeclarer) {
            return ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getXmlDslModel().getPrefix().toUpperCase();
        }

        private Multimap<ComponentDeclaration, ConfigurationDeclaration> populateComponentConfigsMap(ConfigurationDeclaration config) {
            LinkedListMultimap componentConfigs = LinkedListMultimap.create();
            config.getConstructs().forEach(arg_0 -> EnricherDelegate.lambda$populateComponentConfigsMap$6((Multimap)componentConfigs, config, arg_0));
            config.getMessageSources().forEach(arg_0 -> EnricherDelegate.lambda$populateComponentConfigsMap$7((Multimap)componentConfigs, config, arg_0));
            config.getOperations().forEach(arg_0 -> EnricherDelegate.lambda$populateComponentConfigsMap$8((Multimap)componentConfigs, config, arg_0));
            return componentConfigs;
        }

        private void addConfigRefStereoTypesIfNeeded(ComponentDeclaration<?> declaration) {
            Collection configs = this.componentConfigs.get(declaration);
            if (configs != null && !configs.isEmpty()) {
                List stereotypes = configs.stream().map(StereotypedDeclaration::getStereotype).collect(Collectors.toList());
                declaration.getAllParameters().stream().filter(p -> "config-ref".equals(p.getName())).findAny().ifPresent(configRef -> configRef.setAllowedStereotypeModels(stereotypes));
            }
        }

        private static /* synthetic */ void lambda$populateComponentConfigsMap$8(Multimap componentConfigs, ConfigurationDeclaration config, OperationDeclaration operation) {
            componentConfigs.put((Object)operation, (Object)config);
        }

        private static /* synthetic */ void lambda$populateComponentConfigsMap$7(Multimap componentConfigs, ConfigurationDeclaration config, SourceDeclaration source) {
            componentConfigs.put((Object)source, (Object)config);
        }

        private static /* synthetic */ void lambda$populateComponentConfigsMap$6(Multimap componentConfigs, ConfigurationDeclaration config, ConstructDeclaration construct) {
            componentConfigs.put((Object)construct, (Object)config);
        }
    }
}

