/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class InjectedFieldsModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        HashSet validatedTypes = new HashSet();
        Boolean isASTMode = extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(mp -> mp.getType().getDeclaringClass().isPresent()).orElse(false) == false;
        if (!isASTMode.booleanValue()) {
            extensionModel.getModelProperty(ClassLoaderModelProperty.class).ifPresent(classLoaderModelProperty -> new ExtensionWalker((ClassLoaderModelProperty)classLoaderModelProperty, validatedTypes, problemsReporter){
                final /* synthetic */ ClassLoaderModelProperty val$classLoaderModelProperty;
                final /* synthetic */ Set val$validatedTypes;
                final /* synthetic */ ProblemsReporter val$problemsReporter;
                {
                    this.val$classLoaderModelProperty = classLoaderModelProperty;
                    this.val$validatedTypes = set;
                    this.val$problemsReporter = problemsReporter;
                }

                @Override
                protected void onSource(HasSourceModels owner, SourceModel model) {
                    this.validateFields(model, MuleExtensionUtils.getImplementingType(model), DefaultEncoding.class);
                }

                @Override
                protected void onConfiguration(ConfigurationModel model) {
                    Optional<Class> implementingType = MuleExtensionUtils.getImplementingType(model);
                    this.validateFields(model, implementingType, DefaultEncoding.class);
                    this.validateFields(model, implementingType, RefName.class);
                }

                @Override
                protected void onOperation(HasOperationModels owner, OperationModel model) {
                    this.validateArguments(model, model.getModelProperty(ExtensionOperationDescriptorModelProperty.class), DefaultEncoding.class);
                }

                @Override
                protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                    this.validateFields(model, MuleExtensionUtils.getImplementingType(model), DefaultEncoding.class);
                    this.validateFields(model, MuleExtensionUtils.getImplementingType(model), RefName.class);
                }

                @Override
                protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, final ParameterModel model) {
                    if (model.getType().getMetadataFormat().equals(MetadataFormat.JAVA)) {
                        model.getType().accept(new MetadataTypeVisitor(){

                            @Override
                            public void visitObject(ObjectType objectType) {
                                if (!objectType.getAnnotation(InfrastructureTypeAnnotation.class).isPresent()) {
                                    try {
                                        Class type = JavaTypeUtils.getType(objectType, val$classLoaderModelProperty.getClassLoader());
                                        if (val$validatedTypes.add(type)) {
                                            this.validateType(model, type, DefaultEncoding.class);
                                        }
                                    }
                                    catch (Exception e) {
                                        val$problemsReporter.addWarning(new Problem(model, "Could not validate Class: " + e.getMessage()));
                                    }
                                }
                            }
                        });
                    }
                }

                private void validateArguments(NamedObject model, Optional<ExtensionOperationDescriptorModelProperty> modelProperty, Class<? extends Annotation> annotationClass) {
                    modelProperty.ifPresent(operationDescriptorModelProperty -> {
                        ExtensionParameter argument;
                        OperationElement operation = operationDescriptorModelProperty.getOperationElement();
                        int size = operation.getParametersAnnotatedWith(annotationClass).size();
                        if (size == 0) {
                            return;
                        }
                        if (size > 1) {
                            this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' has %d arguments annotated with @%s. Only one argument may carry that annotation", operation.getName(), size, annotationClass.getSimpleName())));
                        }
                        if (!(argument = operation.getParametersAnnotatedWith(annotationClass).get(0)).getType().isSameType(String.class)) {
                            this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' declares an argument '%s' which is annotated with @%s and is of type '%s'. Only arguments of type String are allowed to carry such annotation", operation.getName(), argument.getName(), annotationClass.getSimpleName(), argument.getType().getName())));
                        }
                    });
                }

                private void validateFields(NamedObject model, Optional<Class> implementingType, Class<? extends Annotation> annotationClass) {
                    implementingType.ifPresent(type -> this.validateType(model, (Class<?>)type, annotationClass));
                }

                private void validateType(NamedObject model, Class<?> type, Class<? extends Annotation> annotationClass) {
                    Field field;
                    List<Field> fields = IntrospectionUtils.getAnnotatedFields(type, annotationClass);
                    if (fields.isEmpty()) {
                        return;
                    }
                    if (fields.size() > 1) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' has %d fields annotated with @%s. Only one field may carry that annotation", type.getName(), fields.size(), annotationClass.getSimpleName())));
                    }
                    if (!String.class.equals((field = fields.get(0)).getType())) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' declares the field '%s' which is annotated with @%s and is of type '%s'. Only fields of type String are allowed to carry such annotation", type.getName(), field.getName(), annotationClass.getSimpleName(), field.getType().getName())));
                    }
                }
            }.walk(extensionModel));
        }
    }
}

