/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;

final class DefaultMutableConfigurationStats
implements MutableConfigurationStats {
    private final AtomicInteger inflightOperations = new AtomicInteger(0);
    private final AtomicInteger runningSources = new AtomicInteger(0);
    private final TimeSupplier timeSupplier;
    private long lastUsedMillis;

    public DefaultMutableConfigurationStats(TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.updateLastUsed();
    }

    @Override
    public long updateLastUsed() {
        this.lastUsedMillis = this.timeSupplier.getAsLong();
        return this.lastUsedMillis;
    }

    @Override
    public long getLastUsedMillis() {
        return this.lastUsedMillis;
    }

    @Override
    public int getInflightOperations() {
        return this.inflightOperations.get();
    }

    @Override
    public int getRunningSources() {
        return this.runningSources.get();
    }

    @Override
    public int addInflightOperation() {
        this.updateLastUsed();
        return this.inflightOperations.incrementAndGet();
    }

    @Override
    public int discountInflightOperation() {
        this.updateLastUsed();
        return this.inflightOperations.decrementAndGet();
    }

    @Override
    public int addRunningSource() {
        this.updateLastUsed();
        return this.runningSources.incrementAndGet();
    }

    @Override
    public int discountRunningSource() {
        this.updateLastUsed();
        return this.runningSources.decrementAndGet();
    }
}

