/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.config.ExpirableConfigurationProvider;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements ExpirableConfigurationProvider,
ConfigurationParameterValueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigurationProvider.class);
    private final ConfigurationInstanceFactory configurationInstanceFactory;
    private final ResolverSet resolverSet;
    private final ConnectionProviderValueResolver connectionProviderResolver;
    private final ExpirationPolicy expirationPolicy;
    private final LoadingCache<ResolverResultAndEvent, ConfigurationInstance> cache;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private final ExtensionManager extensionManager;

    public DynamicConfigurationProvider(String name, ExtensionModel extension, ConfigurationModel config, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, ExpirationPolicy expirationPolicy, ReflectionCache reflectionCache, ExpressionManager expressionManager, MuleContext muleContext) {
        super(name, extension, config, muleContext);
        this.configurationInstanceFactory = new ConfigurationInstanceFactory(extension, config, resolverSet, expressionManager, muleContext);
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.resolverSet = resolverSet;
        this.connectionProviderResolver = connectionProviderResolver;
        this.expirationPolicy = expirationPolicy;
        this.extensionManager = muleContext.getExtensionManager();
        this.cache = Caffeine.newBuilder().expireAfterAccess(expirationPolicy.getMaxIdleTime(), expirationPolicy.getTimeUnit()).removalListener((key, value, cause) -> this.extensionManager.disposeConfiguration(((ResolverResultAndEvent)key).getResolverSetResult().toString(), (ConfigurationInstance)value)).build(key -> this.createConfiguration(key.getResolverSetResult(), key.getEvent()));
    }

    @Override
    public ConfigurationInstance get(Event event) {
        return ClassUtils.withContextClassLoader(this.getExtensionClassLoader(), () -> {
            try (ValueResolvingContext resolvingContext = ValueResolvingContext.builder((CoreEvent)event).withExpressionManager(this.expressionManager).build();){
                ResolverSetResult result = this.resolverSet.resolve(resolvingContext);
                ResolverSetResult providerResult = null;
                if (this.connectionProviderResolver.getResolverSet().isPresent()) {
                    providerResult = this.connectionProviderResolver.getResolverSet().get().resolve(resolvingContext);
                }
                ConfigurationInstance configurationInstance = this.getConfiguration(new Pair<ResolverSetResult, Object>(result, providerResult), (CoreEvent)event);
                return configurationInstance;
            }
        });
    }

    private ConfigurationInstance getConfiguration(Pair<ResolverSetResult, ResolverSetResult> resolverSetResult, CoreEvent event) {
        return (ConfigurationInstance)this.cache.get((Object)new ResolverResultAndEvent(resolverSetResult, event));
    }

    private ConfigurationInstance createConfiguration(Pair<ResolverSetResult, ResolverSetResult> values, CoreEvent event) throws MuleException {
        ResolverSetResult connectionProviderValues = values.getSecond();
        ConfigurationInstance configuration = connectionProviderValues != null ? this.configurationInstanceFactory.createConfiguration(this.getName(), values.getFirst(), event, this.connectionProviderResolver, connectionProviderValues) : this.configurationInstanceFactory.createConfiguration(this.getName(), values.getFirst(), event, Optional.ofNullable(this.connectionProviderResolver));
        this.registerConfiguration(configuration);
        return configuration;
    }

    @Override
    protected void registerConfiguration(ConfigurationInstance configuration) {
        try {
            ClassUtils.withContextClassLoader(this.getExtensionClassLoader(), () -> {
                if (this.lifecycleManager.isPhaseComplete("initialise")) {
                    try {
                        LifecycleUtils.initialiseIfNeeded(configuration, true, this.muleContext);
                    }
                    catch (Exception e) {
                        LifecycleUtils.disposeIfNeeded(configuration, LOGGER);
                        throw e;
                    }
                }
                if (this.lifecycleManager.isPhaseComplete("start")) {
                    try {
                        this.startConfig(configuration);
                    }
                    catch (Exception e) {
                        try {
                            LifecycleUtils.stopIfNeeded(configuration);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Exception while stopping " + configuration.toString(), (Throwable)e);
                        }
                        LifecycleUtils.disposeIfNeeded(configuration, LOGGER);
                        throw e;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not register configuration of key " + this.getName()), (Throwable)e);
        }
        super.registerConfiguration(configuration);
    }

    @Override
    public List<ConfigurationInstance> getExpired() {
        return this.cache.asMap().entrySet().stream().filter(entry -> this.isExpired((ConfigurationInstance)entry.getValue())).map(entry -> {
            this.cache.invalidate(entry.getKey());
            this.unRegisterConfiguration((ConfigurationInstance)entry.getValue());
            return (ConfigurationInstance)entry.getValue();
        }).collect(Collectors.toImmutableList());
    }

    private boolean isExpired(ConfigurationInstance configuration) {
        ConfigurationStats stats = configuration.getStatistics();
        return stats.getRunningSources() == 0 && stats.getInflightOperations() == 0 && this.expirationPolicy.isExpired(stats.getLastUsedMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doInitialise() {
        try {
            LifecycleUtils.initialiseIfNeeded(this.resolverSet, this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.connectionProviderResolver, this.muleContext);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded(this.connectionProviderResolver);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Set<Value> getConfigValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> new ValueProviderMediator<ConfigurationModel>(this.getConfigurationModel(), () -> this.muleContext, () -> this.reflectionCache).getValues(parameterName, new ResolverSetBasedParameterResolver(this.resolverSet, this.getConfigurationModel(), this.reflectionCache, this.expressionManager)), this.getExtensionModel());
    }

    @Override
    public Set<Value> getConnectionValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> {
            ConnectionProviderModel connectionProviderModel = this.getConnectionProviderModel().orElseThrow(() -> new ValueResolvingException("Internal Error. Unable to resolve values because the service is unable to get the connection model", "UNKNOWN"));
            ResolverSet resolverSet = this.connectionProviderResolver.getResolverSet().orElseThrow(() -> new ValueResolvingException("Internal Error. Unable to resolve values because of the service is unable to retrieve connection parameters", "UNKNOWN"));
            return new ValueProviderMediator<ConnectionProviderModel>(connectionProviderModel, () -> this.muleContext, () -> this.reflectionCache).getValues(parameterName, new ResolverSetBasedParameterResolver(resolverSet, connectionProviderModel, this.reflectionCache, this.expressionManager));
        }, this.getExtensionModel());
    }

    private Optional<ConnectionProviderModel> getConnectionProviderModel() {
        return this.connectionProviderResolver.getObjectBuilder().filter(ob -> ob instanceof ConnectionProviderObjectBuilder).map(ob -> ((ConnectionProviderObjectBuilder)ob).providerModel);
    }

    private static class ResolverResultAndEvent {
        private Pair<ResolverSetResult, ResolverSetResult> resolverSetResult;
        private CoreEvent event;

        ResolverResultAndEvent(Pair<ResolverSetResult, ResolverSetResult> resolverSetResult, CoreEvent event) {
            this.resolverSetResult = resolverSetResult;
            this.event = event;
        }

        Pair<ResolverSetResult, ResolverSetResult> getResolverSetResult() {
            return this.resolverSetResult;
        }

        public CoreEvent getEvent() {
            return this.event;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResolverResultAndEvent)) {
                return false;
            }
            ResolverResultAndEvent that = (ResolverResultAndEvent)o;
            return this.resolverSetResult.equals(that.resolverSetResult);
        }

        public int hashCode() {
            return Objects.hash(this.resolverSetResult);
        }
    }
}

