/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.ImmutableAuthorizationCodeState;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionsOAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsOAuthUtils.class);

    public static AuthorizationCodeState toAuthorizationCodeState(AuthorizationCodeConfig config, ResourceOwnerOAuthContext context) {
        return new ImmutableAuthorizationCodeState(context.getAccessToken(), context.getRefreshToken(), context.getResourceOwnerId(), context.getExpiresIn(), context.getState(), config.getAuthorizationUrl(), config.getAccessTokenUrl(), config.getCallbackConfig().getExternalCallbackUrl(), config.getConsumerKey(), config.getConsumerSecret());
    }

    public static ClientCredentialsLocation toCredentialsLocation(CredentialsPlacement placement) {
        if (placement == CredentialsPlacement.BASIC_AUTH_HEADER) {
            return ClientCredentialsLocation.BASIC_AUTH_HEADER;
        }
        if (placement == CredentialsPlacement.QUERY_PARAMS) {
            return ClientCredentialsLocation.QUERY_PARAMS;
        }
        if (placement == CredentialsPlacement.BODY) {
            return ClientCredentialsLocation.BODY;
        }
        throw new IllegalArgumentException("Unsupported CredentialsPlacement type " + placement.name());
    }

    public static OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = operationContext.getConfiguration().get();
        ConnectionProvider provider = ConnectionProviderUtils.unwrapProviderWrapper(config.getConnectionProvider().get(), OAuthConnectionProviderWrapper.class);
        return provider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)provider : null;
    }

    public static Map<Field, String> getCallbackValuesExtractors(ConnectionProviderModel providerModel) {
        return providerModel.getModelProperty(OAuthCallbackValuesModelProperty.class).map(OAuthCallbackValuesModelProperty::getCallbackValues).orElseGet(Collections::emptyMap);
    }

    public static <C, T extends OAuthState> FieldSetter<ConnectionProvider<C>, T> getOAuthStateSetter(ConnectionProvider<C> connectionProvider, Class<T> stateType, OAuthGrantType grantType) {
        List stateFields = IntrospectionUtils.getFields(connectionProvider.getClass()).stream().filter(f -> f.getType().equals(stateType)).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 %s grant type and thus should contain one (and only one) field of type %s. %d were found", connectionProvider.getClass().getName(), grantType.getName(), stateType, stateFields.size()));
        }
        return new FieldSetter((Field)stateFields.get(0));
    }

    public static <C> void updateOAuthParameters(ConnectionProvider<C> connectionProvider, Map<Field, String> callbackValues, ResourceOwnerOAuthContext context) {
        Map<String, Object> responseParameters = context.getTokenResponseParameters();
        callbackValues.keySet().forEach(field -> {
            String key = field.getName();
            if (responseParameters.containsKey(key)) {
                new FieldSetter((Field)field).set(connectionProvider, responseParameters.get(key));
            }
        });
    }

    public static <C> ConnectionValidationResult validateOAuthConnection(ConnectionProvider<C> connectionProvider, C connection, ResourceOwnerOAuthContext context) {
        try {
            if (context.getAccessToken() != null) {
                return connectionProvider.validate(connection);
            }
            String message = "Server did not granted an access token";
            return ConnectionValidationResult.failure(message, new IllegalStateException(message));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure("Could not obtain an access token", e);
        }
    }

    public static boolean refreshTokenIfNecessary(final ExecutionContextAdapter<OperationModel> operationContext, Throwable e) {
        AccessTokenExpiredException expiredException = ExtensionsOAuthUtils.getTokenExpirationException(e);
        if (expiredException == null) {
            return false;
        }
        final OAuthConnectionProviderWrapper connectionProvider = ExtensionsOAuthUtils.getOAuthConnectionProvider(operationContext);
        if (connectionProvider == null) {
            return false;
        }
        final Reference resourceOwnerIdReference = new Reference(Optional.empty());
        connectionProvider.getGrantType().accept(new OAuthGrantTypeVisitor(){

            @Override
            public void visit(AuthorizationCodeGrantType grantType) {
                AuthorizationCodeConnectionProviderWrapper cp = (AuthorizationCodeConnectionProviderWrapper)connectionProvider;
                String rsId = cp.getResourceOwnerId();
                resourceOwnerIdReference.set(Optional.of(rsId));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AccessToken for resourceOwner '{}' expired at operation '{}:{}' using config '{}'. Will attempt to refresh token and retry operation", new Object[]{rsId, operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), operationContext.getConfiguration().get().getName()});
                }
            }

            @Override
            public void visit(ClientCredentialsGrantType grantType) {
                this.logTokenExpiration(operationContext);
            }

            @Override
            public void visit(PlatformManagedOAuthGrantType grantType) {
                this.logTokenExpiration(operationContext);
            }

            private void logTokenExpiration(ExecutionContextAdapter<OperationModel> operationContext2) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AccessToken expired at operation '{}:{}' using config '{}'. Will attempt to refresh token and retry operation", new Object[]{operationContext2.getExtensionModel().getName(), ((OperationModel)operationContext2.getComponentModel()).getName(), operationContext2.getConfiguration().get().getName()});
                }
            }
        });
        Optional<String> resourceOwnerId = resourceOwnerIdReference.get();
        try {
            connectionProvider.refreshToken(resourceOwnerId.orElse(""));
        }
        catch (Exception refreshException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("AccessToken %s expired at operation '%s:%s' using config '%s'. Refresh token workflow was attempted but failed with the following exception", ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), operationContext.getConfiguration().get().getName())), (Throwable)refreshException);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access Token successfully refreshed {} on config '{}'", (Object)ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), (Object)operationContext.getConfiguration().get().getName());
        }
        return true;
    }

    private static AccessTokenExpiredException getTokenExpirationException(Throwable e) {
        return ExceptionUtils.extractOfType(e, AccessTokenExpiredException.class).orElse(null);
    }

    private static String forResourceOwner(Optional<String> resourceOwnerId) {
        return resourceOwnerId.map(id -> "for resource owner '" + id + "'").orElse("");
    }

    private ExtensionsOAuthUtils() {
    }
}

