/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.deprecated;

import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ComponentExecutorCompletableAdapterFactory<T extends ComponentModel>
implements CompletableComponentExecutorFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentExecutorCompletableAdapterFactory.class);
    private final ComponentExecutorFactory<T> delegate;

    public ComponentExecutorCompletableAdapterFactory(ComponentExecutorFactory<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableComponentExecutor<T> createExecutor(T componentModel, Map<String, Object> parameters) {
        return new ComponentExecutorCompletableAdapter<T>(this.delegate.createExecutor(componentModel, parameters));
    }

    private static class ComponentExecutorCompletableAdapter<T extends ComponentModel>
    implements CompletableComponentExecutor<T>,
    Lifecycle,
    MuleContextAware {
        private final ComponentExecutor<T> delegate;
        private MuleContext muleContext;

        public ComponentExecutorCompletableAdapter(ComponentExecutor<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(ExecutionContext<T> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
            try {
                Mono.from(this.delegate.execute(executionContext)).switchIfEmpty(Mono.just((Object)"")).subscribe(callback::complete, callback::error);
            }
            catch (Throwable t) {
                callback.error(t);
            }
        }

        @Override
        public void initialise() throws InitialisationException {
            LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        }

        @Override
        public void start() throws MuleException {
            LifecycleUtils.startIfNeeded(this.delegate);
        }

        @Override
        public void stop() throws MuleException {
            LifecycleUtils.stopIfNeeded(this.delegate);
        }

        @Override
        public void dispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        }

        @Override
        public void setMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
        }
    }
}

