/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorResetInterceptor
implements Interceptor<OperationModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorResetInterceptor.class);
    private static final String CURSOR_POSITIONS = "CURSOR_POSITIONS";
    private final List<String> cursorParamNames;

    public CursorResetInterceptor(List<String> cursorParamNames) {
        this.cursorParamNames = cursorParamNames;
    }

    @Override
    public void before(ExecutionContext<OperationModel> ctx) throws Exception {
        ArrayList<Pair<Cursor, Long>> cursorPositions = new ArrayList<Pair<Cursor, Long>>(this.cursorParamNames.size());
        for (String cursorParamName : this.cursorParamNames) {
            Object value = ctx.getParameterOrDefault(cursorParamName, null);
            if (!(value instanceof Cursor)) continue;
            Cursor cursor = value;
            cursorPositions.add(new Pair<Cursor, Long>(cursor, cursor.getPosition()));
        }
        if (!cursorPositions.isEmpty()) {
            ((ExecutionContextAdapter)ctx).setVariable(CURSOR_POSITIONS, cursorPositions);
        }
    }

    @Override
    public Throwable onError(ExecutionContext<OperationModel> executionContext, Throwable exception) {
        ExceptionUtils.extractConnectionException(exception).ifPresent(cne -> {
            List cursorPositions = (List)((ExecutionContextAdapter)executionContext).removeVariable(CURSOR_POSITIONS);
            if (cursorPositions != null) {
                cursorPositions.forEach(pair -> {
                    block2: {
                        try {
                            ((Cursor)pair.getFirst()).seek((Long)pair.getSecond());
                        }
                        catch (IOException e) {
                            if (!LOGGER.isWarnEnabled()) break block2;
                            LOGGER.warn("Could not reset cursor back to position " + pair.getSecond() + ". Inconsistencies might occur if reconnection attempted", (Throwable)e);
                        }
                    }
                });
            }
        });
        return exception;
    }
}

