/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressFilter;
import org.mule.service.http.impl.service.server.grizzly.MuleSslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    protected static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpServer.class);
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private GrizzlyAddressFilter<SSLFilter> sslFilter;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer, GrizzlyAddressFilter<SSLFilter> sslFilter) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
        this.sslFilter = sslFilter;
    }

    @Override
    public synchronized HttpServer start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.serverConnection.getMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{new CloseAcceptedConnectionsOnServerCloseProbe()});
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Listening for connections on '%s'", this.listenerUrl()));
        }
        this.serverConnection.addCloseListener((closeable, type) -> {
            try {
                this.scheduler.stop();
            }
            finally {
                this.scheduler = null;
            }
            this.schedulerDisposer.run();
        });
        this.stopped = false;
        return this;
    }

    @Override
    public synchronized HttpServer stop() {
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Stopped listener on '%s'", this.listenerUrl()));
            }
            GrizzlyHttpServer grizzlyHttpServer = this;
            return grizzlyHttpServer;
        }
        finally {
            this.stopping = false;
            this.stopped = true;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public HttpConstants.Protocol getProtocol() {
        return this.sslFilter.hasFilterForAddress(this.getServerAddress()) ? HttpConstants.Protocol.HTTPS : HttpConstants.Protocol.HTTP;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder(methods).build()).path(path).build());
    }

    @Override
    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }

    @Override
    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.sslFilter.addFilterForAddress(this.getServerAddress(), MuleSslFilter.createSslFilter(tlsContextFactory));
    }

    @Override
    public void disableTls() {
        this.sslFilter.removeFilterForAddress(this.getServerAddress());
    }

    private String listenerUrl() {
        return String.format("%s://%s:%d", this.getProtocol().getScheme(), this.serverAddress.getIp(), this.serverAddress.getPort());
    }

    private static class RemoveCloseListenerOnClientClosed
    implements CloseListener<TCPNIOConnection, CloseType> {
        private CloseAcceptedConnectionOnServerClose callbackToRemove;
        private Connection serverConnection;

        private RemoveCloseListenerOnClientClosed(Connection serverConnection, CloseAcceptedConnectionOnServerClose callbackToRemove) {
            this.serverConnection = serverConnection;
            this.callbackToRemove = callbackToRemove;
        }

        public void onClosed(TCPNIOConnection closeable, CloseType type) throws IOException {
            if (this.serverConnection.isOpen()) {
                this.serverConnection.removeCloseListener((CloseListener)this.callbackToRemove);
            }
        }
    }

    private static class CloseAcceptedConnectionOnServerClose
    implements CloseListener<TCPNIOServerConnection, CloseType> {
        private SocketChannel acceptedChannel;

        private CloseAcceptedConnectionOnServerClose(Connection acceptedConnection) {
            this.acceptedChannel = CloseAcceptedConnectionOnServerClose.getSocketChannel(acceptedConnection);
        }

        private static SocketChannel getSocketChannel(Connection acceptedConnection) {
            if (!(acceptedConnection instanceof TCPNIOConnection)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("The accepted connection is not an instance of TCPNIOConnection");
                }
                return null;
            }
            SelectableChannel selectableChannel = ((TCPNIOConnection)acceptedConnection).getChannel();
            if (!(selectableChannel instanceof SocketChannel)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("The accepted connection doesn't hold a SocketChannel");
                }
                return null;
            }
            return (SocketChannel)selectableChannel;
        }

        public void onClosed(TCPNIOServerConnection closeable, CloseType type) throws IOException {
            if (this.acceptedChannel != null) {
                this.acceptedChannel.shutdownInput();
            }
        }
    }

    private static class CloseAcceptedConnectionsOnServerCloseProbe
    extends ConnectionProbe.Adapter {
        private CloseAcceptedConnectionsOnServerCloseProbe() {
        }

        public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
            CloseAcceptedConnectionOnServerClose callback = new CloseAcceptedConnectionOnServerClose(clientConnection);
            serverConnection.addCloseListener((CloseListener)callback);
            clientConnection.addCloseListener((CloseListener)new RemoveCloseListenerOnClientClosed(serverConnection, callback));
        }
    }
}

