/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.state.DancerState;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.service.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthDancer
implements Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOAuthDancer.class);
    public static final int TOKEN_REQUEST_TIMEOUT_MILLIS = 60000;
    protected final String name;
    protected final String clientId;
    protected final String clientSecret;
    protected final String tokenUrl;
    protected final Charset encoding;
    protected final String scopes;
    protected final ClientCredentialsLocation clientCredentialsLocation;
    protected final String responseAccessTokenExpr;
    protected final String responseRefreshTokenExpr;
    protected final String responseExpiresInExpr;
    protected final Map<String, String> customParametersExtractorsExprs;
    protected final Function<String, String> resourceOwnerIdTransformer;
    private final List<OAuthStateListener> listeners;
    private final SchedulerService schedulerService;
    private final LockFactory lockProvider;
    private final Map<String, ResourceOwnerOAuthContext> tokensStore;
    private final HttpClient httpClient;
    private final MuleExpressionLanguage expressionEvaluator;
    private Scheduler pollScheduler;

    @Deprecated
    protected AbstractOAuthDancer(String name, String clientId, String clientSecret, String tokenUrl, Charset encoding, String scopes, ClientCredentialsLocation clientCredentialsLocation, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExtractorsExprs, Function<String, String> resourceOwnerIdTransformer, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator) {
        this(name, clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExtractorsExprs, resourceOwnerIdTransformer, schedulerService, lockProvider, tokensStore, httpClient, expressionEvaluator, Collections.emptyList());
    }

    protected AbstractOAuthDancer(String name, String clientId, String clientSecret, String tokenUrl, Charset encoding, String scopes, ClientCredentialsLocation clientCredentialsLocation, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExtractorsExprs, Function<String, String> resourceOwnerIdTransformer, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator, List<? extends OAuthStateListener> listeners) {
        this.name = name;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.encoding = encoding;
        this.scopes = scopes;
        this.clientCredentialsLocation = clientCredentialsLocation;
        this.responseAccessTokenExpr = responseAccessTokenExpr;
        this.responseRefreshTokenExpr = responseRefreshTokenExpr;
        this.responseExpiresInExpr = responseExpiresInExpr;
        this.customParametersExtractorsExprs = customParametersExtractorsExprs;
        this.resourceOwnerIdTransformer = resourceOwnerIdTransformer;
        this.schedulerService = schedulerService;
        this.lockProvider = lockProvider;
        this.tokensStore = tokensStore;
        this.httpClient = httpClient;
        this.expressionEvaluator = expressionEvaluator;
        this.listeners = listeners != null ? new CopyOnWriteArrayList<OAuthStateListener>(listeners) : new CopyOnWriteArrayList<OAuthStateListener>();
    }

    @Override
    public void start() throws MuleException {
        this.startHttpClient();
        this.pollScheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName(this.name + "-oauthDancer-tokenRefreshPoll").withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
    }

    protected void startHttpClient() {
        this.httpClient.start();
    }

    @Override
    public void stop() throws MuleException {
        try {
            if (this.pollScheduler != null) {
                this.pollScheduler.stop();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Found error trying to stop pollScheduler for dancer '" + this.name + "'. Execution will continue...", t);
        }
        this.stopHttpClient();
    }

    protected void stopHttpClient() {
        this.httpClient.stop();
    }

    protected String handleClientCredentials(Map<String, String> formData) {
        switch (this.clientCredentialsLocation) {
            case BASIC_AUTH_HEADER: {
                return "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.clientId, this.clientSecret).getBytes());
            }
            case BODY: {
                formData.put("client_id", this.clientId);
                formData.put("client_secret", this.clientSecret);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> CompletableFuture<T> doRefreshToken(Supplier<ResourceOwnerOAuthContext> oauthContextSupplier, Function<ResourceOwnerOAuthContext, CompletableFuture<T>> tokenRefreshRequester) {
        Lock lock;
        ResourceOwnerOAuthContext oauthContext;
        block21: {
            oauthContext = oauthContextSupplier.get();
            lock = oauthContext.getRefreshOAuthContextLock(this.name, this.getLockProvider());
            if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                if (lock.tryLock()) {
                    try {
                        oauthContext = oauthContextSupplier.get();
                        if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
                            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                            return completableFuture;
                        }
                        if (oauthContext.getDancerState() == DancerState.REFRESHING_TOKEN) {
                            CompletableFuture<T> completableFuture = this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
                            return completableFuture;
                        }
                        if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                            CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                            return completableFuture;
                        }
                        break block21;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                return this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
            }
        }
        if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
            String accessToken = oauthContext.getAccessToken();
            lock.lock();
            try {
                oauthContext = oauthContextSupplier.get();
                if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
                    if (accessToken.equals(oauthContext.getAccessToken())) {
                        CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                        return completableFuture;
                    }
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                if (oauthContext.getDancerState() == DancerState.REFRESHING_TOKEN) {
                    CompletableFuture<T> completableFuture = this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
                    return completableFuture;
                }
                if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                    CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                    return completableFuture;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
    }

    protected <T> CompletableFuture<T> doRefreshTokenRequest(Function<ResourceOwnerOAuthContext, CompletableFuture<T>> tokenRefreshRequester, ResourceOwnerOAuthContext oauthContext) {
        oauthContext.setDancerState(DancerState.REFRESHING_TOKEN);
        this.updateResourceOwnerOAuthContext(oauthContext);
        try {
            return tokenRefreshRequester.apply(oauthContext);
        }
        catch (Exception e) {
            oauthContext.setDancerState(DancerState.NO_TOKEN);
            this.updateResourceOwnerOAuthContext(oauthContext);
            throw e;
        }
    }

    private <T> CompletableFuture<T> pollForRefreshComplete(Supplier<ResourceOwnerOAuthContext> oauthContextSupplier, ResourceOwnerOAuthContext oauthContext) {
        CompletableFuture pendingResponse = new CompletableFuture();
        this.pollScheduler.execute(() -> {
            long startNanos = System.nanoTime();
            ResourceOwnerOAuthContext ctx = (ResourceOwnerOAuthContext)oauthContextSupplier.get();
            while (ctx.getDancerState() == DancerState.REFRESHING_TOKEN) {
                if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos) > 60000L) {
                    oauthContext.setDancerState(DancerState.NO_TOKEN);
                    this.updateResourceOwnerOAuthContext(oauthContext);
                    pendingResponse.completeExceptionally(new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Timeout polling for token refresh to complete.")));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    pendingResponse.completeExceptionally(e);
                }
                ctx = (ResourceOwnerOAuthContext)oauthContextSupplier.get();
            }
            pendingResponse.complete(null);
        });
        return pendingResponse;
    }

    protected CompletableFuture<TokenResponse> invokeTokenUrl(String tokenUrl, Map<String, String> tokenRequestFormToSend, MultiMap<String, String> queryParams, MultiMap<String, String> headers, String authorization, boolean retrieveRefreshToken, Charset encoding) {
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(tokenUrl).method(HttpConstants.Method.POST.name()).entity(new ByteArrayHttpEntity(HttpEncoderDecoderUtils.encodeString(tokenRequestFormToSend, encoding).getBytes()))).addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())).queryParams(queryParams).headers(headers);
        if (authorization != null) {
            requestBuilder.addHeader("Authorization", authorization);
        } else if (ClientCredentialsLocation.QUERY_PARAMS.equals((Object)this.clientCredentialsLocation)) {
            requestBuilder.addQueryParam("client_id", this.clientId);
            requestBuilder.addQueryParam("client_secret", this.clientSecret);
        }
        return ((CompletableFuture)this.httpClient.sendAsync(requestBuilder.build(), HttpRequestOptions.builder().responseTimeout(60000).build()).exceptionally(t -> ClassUtils.withContextClassLoader(AbstractOAuthDancer.class.getClassLoader(), () -> {
            if (t instanceof IOException) {
                throw new CompletionException(new TokenUrlResponseException(tokenUrl, (IOException)t));
            }
            throw new CompletionException((Throwable)t);
        }))).thenApply(response -> this.parseTokenResponse((HttpResponse)response, tokenUrl, retrieveRefreshToken));
    }

    protected TokenResponse parseTokenResponse(HttpResponse response, String tokenUrl, boolean retrieveRefreshToken) {
        return ClassUtils.withContextClassLoader(AbstractOAuthDancer.class.getClassLoader(), () -> {
            String body2;
            String contentType = response.getHeaderValue("Content-Type");
            MediaType responseContentType = contentType != null ? MediaType.parse(contentType) : MediaType.ANY;
            try (InputStream content = response.getEntity().getContent();){
                body2 = IOUtils.toString(content);
                if (response.getStatusCode() >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
                    try {
                        throw new CompletionException(new TokenUrlResponseException(tokenUrl, response, body2));
                    }
                    catch (IOException e) {
                        throw new CompletionException(new TokenUrlResponseException(tokenUrl, e));
                    }
                }
            }
            MultiMap<String, String> responseHeaders = response.getHeaders();
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)this.resolveExpression(this.responseAccessTokenExpr, body2, responseHeaders, responseContentType));
            if (tokenResponse.getAccessToken() == null) {
                throw new CompletionException(new TokenNotFoundException(tokenUrl, response, body2));
            }
            if (retrieveRefreshToken) {
                tokenResponse.setRefreshToken((String)this.resolveExpression(this.responseRefreshTokenExpr, body2, responseHeaders, responseContentType));
            }
            tokenResponse.setExpiresIn((String)this.resolveExpression(this.responseExpiresInExpr, body2, responseHeaders, responseContentType));
            if (this.customParametersExtractorsExprs != null && !this.customParametersExtractorsExprs.isEmpty()) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                for (Map.Entry<String, String> customParamExpr : this.customParametersExtractorsExprs.entrySet()) {
                    customParams.put(customParamExpr.getKey(), this.resolveExpression(customParamExpr.getValue(), body2, responseHeaders, responseContentType));
                }
                tokenResponse.setCustomResponseParameters(customParams);
            }
            return tokenResponse;
        });
    }

    protected void updateOAuthContextAfterTokenResponse(ResourceOwnerOAuthContext defaultUserState) {
        defaultUserState.setDancerState(DancerState.HAS_TOKEN);
        this.updateResourceOwnerOAuthContext(defaultUserState);
    }

    protected <T> Function<Throwable, ? extends T> tokenUrlExceptionHandler(ResourceOwnerOAuthContext defaultUserState) {
        return t -> {
            defaultUserState.setDancerState(DancerState.NO_TOKEN);
            this.updateResourceOwnerOAuthContext(defaultUserState);
            if (t instanceof CompletionException) {
                throw (CompletionException)t;
            }
            throw new CompletionException((Throwable)t);
        };
    }

    protected <T> T resolveExpression(String expr, Object body2, MultiMap<String, String> headers, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue<Object>(body2, DataType.builder().fromObject(body2).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue<Map<String, MultiMap<String, String>>>(Collections.singletonMap("headers", headers.toImmutableMultiMap()), DataType.fromType(Map.class))).addBinding("dataType", new TypedValue<DataType>(DataType.builder().fromObject(body2).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    protected <T> T resolveExpression(String expr, Object body2, MultiMap<String, String> headers, MultiMap<String, String> queryParams, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        HashMap<String, MultiMap<String, String>> attributes = new HashMap<String, MultiMap<String, String>>(2);
        attributes.put("headers", headers.toImmutableMultiMap());
        attributes.put("queryParams", queryParams.toImmutableMultiMap());
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue<Object>(body2, DataType.builder().fromObject(body2).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(attributes, DataType.fromType(Map.class))).addBinding("dataType", new TypedValue<DataType>(DataType.builder().fromObject(body2).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    public void invalidateContext(String resourceOwner) {
        Lock refreshUserOAuthContextLock = this.getContextForResourceOwner(resourceOwner).getRefreshOAuthContextLock(this.name, this.getLockProvider());
        refreshUserOAuthContextLock.lock();
        try {
            this.tokensStore.remove(this.resourceOwnerIdTransformer.apply(resourceOwner));
            this.onEachListener(OAuthStateListener::onTokenInvalidated);
        }
        finally {
            refreshUserOAuthContextLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        if (resourceOwnerId == null) {
            resourceOwnerId = "default";
        }
        String transformedResourceOwnerId = this.resourceOwnerIdTransformer.apply(resourceOwnerId);
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = null;
        if (!this.tokensStore.containsKey(transformedResourceOwnerId)) {
            Lock lock = ResourceOwnerOAuthContextWithRefreshState.createRefreshOAuthContextLock(this.name, this.lockProvider, resourceOwnerId);
            lock.lock();
            try {
                if (!this.tokensStore.containsKey(transformedResourceOwnerId)) {
                    resourceOwnerOAuthContext = new ResourceOwnerOAuthContextWithRefreshState(resourceOwnerId);
                    this.tokensStore.put(transformedResourceOwnerId, resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null && (resourceOwnerOAuthContext = this.tokensStore.get(transformedResourceOwnerId)) instanceof DefaultResourceOwnerOAuthContext) {
            resourceOwnerOAuthContext = new ResourceOwnerOAuthContextWithRefreshState(resourceOwnerOAuthContext);
        }
        return resourceOwnerOAuthContext;
    }

    protected void updateResourceOwnerOAuthContext(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshOAuthContextLock(this.name, this.getLockProvider());
        resourceOwnerContextLock.lock();
        try {
            this.tokensStore.put(this.resourceOwnerIdTransformer.apply(resourceOwnerOAuthContext.getResourceOwnerId()), resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }

    protected LockFactory getLockProvider() {
        return this.lockProvider;
    }

    protected void doAddListener(OAuthStateListener listener) {
        Preconditions.checkArgument(listener != null, "Cannot add a null listener");
        this.listeners.add(listener);
    }

    protected void doRemoveListener(OAuthStateListener listener) {
        Preconditions.checkArgument(listener != null, "Cannot remove a null listener");
        this.listeners.remove(listener);
    }

    protected void onEachListener(Consumer<OAuthStateListener> action) {
        this.listeners.forEach(listener -> {
            block2: {
                try {
                    action.accept((OAuthStateListener)listener);
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) break block2;
                    LOGGER.error(String.format("Exception found while invoking %s [%s] on OAuth dancer [%s]", OAuthState.class.getSimpleName(), this, listener), (Throwable)e);
                }
            }
        });
    }
}

