/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.reporting.DefaultSchedulerView;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerService
implements SchedulerService,
Startable,
Stoppable {
    private static final String USAGE_TRACE_INTERVAL_SECS_PROPERTY = "mule.scheduler.usageTraceIntervalSecs";
    public static final Long USAGE_TRACE_INTERVAL_SECS = Long.getLong("mule.scheduler.usageTraceIntervalSecs");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchedulerService.class);
    public static final Logger TRACE_LOGGER = LoggerFactory.getLogger((String)"org.mule.service.scheduler.trace");
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = 5000L;
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private ReadWriteLock pollsLock = new ReentrantReadWriteLock();
    private Lock pollsReadLock = this.pollsLock.readLock();
    private Lock pollsWriteLock = this.pollsLock.writeLock();
    private ContainerThreadPoolsConfig containerThreadPoolsConfig;
    private LoadingCache<SchedulerPoolsConfigFactory, SchedulerThreadPools> poolsByConfig;
    private Scheduler poolsMaintenanceScheduler;
    private ScheduledFuture<?> poolsMaintenanceTask;
    private ScheduledFuture<?> usageReportingTask;
    private volatile boolean started = false;
    private LoadingCache<Thread, Boolean> cpuWorkCache = Caffeine.newBuilder().weakKeys().build(t -> this.isCurrentThreadForCpuWork(SchedulerContainerPoolsConfig.getInstance()));

    @Override
    public String getName() {
        return SchedulerService.class.getSimpleName();
    }

    @Override
    public Scheduler cpuLightScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler ioScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuIntensiveScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuLightScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler ioScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Inject
    public Scheduler cpuLightScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Inject
    public Scheduler ioScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Inject
    public Scheduler cpuIntensiveScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private int cpuBoundWorkers() {
        return 4 * CORES;
    }

    private int ioBoundWorkers() {
        return CORES * CORES;
    }

    @Override
    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config));
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, int queueSize) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config), queueSize);
            return scheduler;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private Supplier<Long> resolveStopTimeout(SchedulerConfig config) {
        return () -> config.getShutdownTimeoutMillis().get() != null ? config.getShutdownTimeoutMillis().get() : Long.valueOf(5000L);
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Service " + this.getName() + " is not started.");
        }
    }

    @Override
    public boolean isCurrentThreadForCpuWork() {
        return (Boolean)this.cpuWorkCache.get((Object)Thread.currentThread());
    }

    @Override
    @Inject
    public boolean isCurrentThreadForCpuWork(SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            boolean bl = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).isCurrentThreadForCpuWork();
            return bl;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public void start() throws MuleException {
        this.pollsWriteLock.lock();
        try {
            this.containerThreadPoolsConfig = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
            this.poolsByConfig = Caffeine.newBuilder().weakKeys().executor(Runnable::run).removalListener((RemovalListener)new RemovalListener<SchedulerPoolsConfigFactory, SchedulerThreadPools>(){

                public void onRemoval(SchedulerPoolsConfigFactory key, SchedulerThreadPools value, RemovalCause cause) {
                    try {
                        value.stop();
                        LOGGER.info("Stopped " + this.toString());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("Stop of " + this.toString() + " interrupted", (Throwable)e);
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }).build(key -> {
                SchedulerThreadPools containerThreadPools = this.createSchedulerThreadPools(this.getName(), key.getConfig().orElse(this.containerThreadPoolsConfig));
                containerThreadPools.start();
                return containerThreadPools;
            });
            this.started = true;
            this.poolsMaintenanceScheduler = this.customScheduler(SchedulerConfig.config().withName("Scheduler Maintenance").withMaxConcurrentTasks(1));
            this.poolsMaintenanceTask = this.poolsMaintenanceScheduler.scheduleAtFixedRate(() -> this.poolsByConfig.cleanUp(), 1L, 1L, TimeUnit.MINUTES);
            if (USAGE_TRACE_INTERVAL_SECS != null) {
                TRACE_LOGGER.info("Usage Trace enabled");
                this.usageReportingTask = this.poolsMaintenanceScheduler.scheduleAtFixedRate(() -> {
                    TRACE_LOGGER.warn("************************************************************************");
                    TRACE_LOGGER.warn("* Schedulers Usage Report                                              *");
                    TRACE_LOGGER.warn("************************************************************************");
                    for (SchedulerThreadPools pool : this.getPools()) {
                        TRACE_LOGGER.warn(pool.buildReportString());
                        TRACE_LOGGER.warn("************************************************************************");
                    }
                }, USAGE_TRACE_INTERVAL_SECS, USAGE_TRACE_INTERVAL_SECS, TimeUnit.SECONDS);
            }
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    private SchedulerThreadPools createSchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig) {
        return SchedulerThreadPools.builder(name, threadPoolsConfig).setTraceLogger(TRACE_LOGGER).preStartThreads(true).build();
    }

    @Override
    public void stop() throws MuleException {
        LOGGER.info("Stopping " + this.toString() + "...");
        this.pollsWriteLock.lock();
        try {
            this.started = false;
            if (this.usageReportingTask != null) {
                this.usageReportingTask.cancel(true);
            }
            this.poolsMaintenanceTask.cancel(true);
            this.poolsMaintenanceScheduler.stop();
            this.poolsByConfig.invalidateAll();
            this.poolsByConfig = null;
            this.containerThreadPoolsConfig = null;
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    @Override
    public List<SchedulerView> getSchedulers() {
        ArrayList schedulers = new ArrayList();
        for (SchedulerThreadPools schedulerThreadPools : this.getPools()) {
            schedulers.addAll(schedulerThreadPools.getSchedulers().stream().map(s -> new DefaultSchedulerView((Scheduler)s)).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(schedulers);
    }

    public Collection<SchedulerThreadPools> getPools() {
        this.pollsReadLock.lock();
        try {
            this.poolsByConfig.cleanUp();
            Collection<SchedulerThreadPools> collection = this.poolsByConfig.asMap().values();
            return collection;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public String getSplashMessage() {
        StringBuilder splashMessage = new StringBuilder();
        splashMessage.append("Resolved configuration values:").append(System.lineSeparator());
        splashMessage.append("" + System.lineSeparator());
        splashMessage.append("Pooling strategy:       ").append(this.containerThreadPoolsConfig.getSchedulerPoolStrategy().name()).append(System.lineSeparator());
        splashMessage.append("gracefulShutdownTimeout:       ").append(this.containerThreadPoolsConfig.getGracefulShutdownTimeout().getAsLong()).append(" ms").append(System.lineSeparator());
        if (this.containerThreadPoolsConfig.getSchedulerPoolStrategy() == SchedulerPoolStrategy.UBER) {
            splashMessage.append("uber.threadPool.maxSize:         ").append(this.containerThreadPoolsConfig.getUberMaxPoolSize().getAsInt() + System.lineSeparator());
            splashMessage.append("uber.threadPool.threadKeepAlive: ").append(this.containerThreadPoolsConfig.getUberKeepAlive().getAsLong() + " ms" + System.lineSeparator());
        } else {
            splashMessage.append("cpuLight.threadPool.size:      ").append(this.containerThreadPoolsConfig.getCpuLightPoolSize().getAsInt() + System.lineSeparator());
            splashMessage.append("cpuLight.workQueue.size:       ").append(this.containerThreadPoolsConfig.getCpuLightQueueSize().getAsInt() + System.lineSeparator());
            splashMessage.append("io.threadPool.maxSize:         ").append(this.containerThreadPoolsConfig.getIoMaxPoolSize().getAsInt() + System.lineSeparator());
            splashMessage.append("io.threadPool.threadKeepAlive: ").append(this.containerThreadPoolsConfig.getIoKeepAlive().getAsLong() + " ms" + System.lineSeparator());
            splashMessage.append("cpuIntensive.threadPool.size:  ").append(this.containerThreadPoolsConfig.getCpuIntensivePoolSize().getAsInt() + System.lineSeparator());
            splashMessage.append("cpuIntensive.workQueue.size:   ").append(this.containerThreadPoolsConfig.getCpuIntensiveQueueSize().getAsInt() + System.lineSeparator());
        }
        splashMessage.append("" + System.lineSeparator());
        splashMessage.append("These can be modified by editing 'conf/scheduler-pools.conf'" + System.lineSeparator());
        return splashMessage.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

