/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import org.mule.weave.v2.exception.UnsupportedBasePropertyException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionToLiteralException$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NameType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.TypeType$;
import org.mule.weave.v2.model.types.UriType$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.BinaryHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u0007\u000e\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006u\u0001!\ta\u000f\u0005\u0006}\u0001!\te\u0010\u0005\u0006U\u0002!\ta\u001b\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002\u0006\u0002!\t!a\"\b\u000f\u0005-U\u0002#\u0001\u0002\u000e\u001a1A\"\u0004E\u0001\u0003\u001fCaA\u000f\u0006\u0005\u0002\u0005E%!D*ue&twmQ8fe\u000e,'O\u0003\u0002\u000f\u001f\u0005A1m\\3sG&|gN\u0003\u0002\u0011#\u00051a/\u00197vKNT!AE\n\u0002\u000b5|G-\u001a7\u000b\u0005Q)\u0012A\u0001<3\u0015\t1r#A\u0003xK\u00064XM\u0003\u0002\u00193\u0005!Q.\u001e7f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u00042\u0001J\u0013(\u001b\u0005i\u0011B\u0001\u0014\u000e\u000511\u0016\r\\;f\u0007>,'oY3s!\tA\u0013&D\u0001\u0010\u0013\tQsBA\u0006TiJLgn\u001a,bYV,\u0017A\u0002<bYV,7\u000bE\u0002\u001f[=J!AL\u0010\u0003\r=\u0003H/[8o!\t\u0001tG\u0004\u00022kA\u0011!gH\u0007\u0002g)\u0011AgG\u0001\u0007yI|w\u000e\u001e \n\u0005Yz\u0012A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u0010\u0002\rqJg.\u001b;?)\taT\b\u0005\u0002%\u0001!)1F\u0001a\u0001Y\u000511m\\3sG\u0016$B\u0001Q$YAR\u0011q%\u0011\u0005\u0006\u0005\u000e\u0001\u001daQ\u0001\u0004GRD\bC\u0001#F\u001b\u0005\t\u0012B\u0001$\u0012\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006\u0011\u000e\u0001\r!S\u0001\u0006m\u0006dW/\u001a\u0019\u0003\u0015>\u00032\u0001K&N\u0013\tauBA\u0003WC2,X\r\u0005\u0002O\u001f2\u0001A!\u0003)H\u0003\u0003\u0005\tQ!\u0001R\u0005\ryF%M\t\u0003%V\u0003\"AH*\n\u0005Q{\"a\u0002(pi\"Lgn\u001a\t\u0003=YK!aV\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003Z\u0007\u0001\u0007!,\u0001\u0006uCJ<W\r\u001e+za\u0016\u0004\"a\u00170\u000e\u0003qS!!X\t\u0002\u000bQL\b/Z:\n\u0005}c&\u0001\u0002+za\u0016DQ!Y\u0002A\u0002\t\fq\u0002\\8dCRLwN\\\"ba\u0006\u0014G.\u001a\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0001\u0002\\8dCRLwN\u001c\u0006\u0003ON\ta\u0001]1sg\u0016\u0014\u0018BA5e\u0005=aunY1uS>t7)\u00199bE2,\u0017A\u00044pe6\fG\u000fV3na>\u0014\u0018\r\u001c\u000b\nY:L\u0018qAA\u0006\u0003\u001b!\"aL7\t\u000b\t#\u00019A\"\t\u000b=$\u0001\u0019\u00019\u0002\u0011Q,W\u000e]8sC2\u0004\"!]<\u000e\u0003IT!a\\:\u000b\u0005Q,\u0018\u0001\u0002;j[\u0016T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002ye\n\u0001B+Z7q_J\fG.Q2dKN\u001cxN\u001d\u0005\u0006u\u0012\u0001\ra_\u0001\u0007g\u000eDW-\\1\u0011\u0007yiC\u0010E\u0002~\u0003\u0007i\u0011A \u0006\u0003u~T1!!\u0001\u0012\u0003%\u0019HO];diV\u0014X-C\u0002\u0002\u0006y\u0014aaU2iK6\f\u0007BBA\u0005\t\u0001\u0007!,\u0001\u0006t_V\u00148-\u001a+za\u0016DQ!\u0019\u0003A\u0002\tDa\u0001\u0013\u0003A\u0002\u0005=\u0001\u0007BA\t\u0003+\u0001B\u0001K&\u0002\u0014A\u0019a*!\u0006\u0005\u0017\u0005]\u0011QBA\u0001\u0002\u0003\u0015\t!\u0015\u0002\u0004?\u0012\u0012\u0014\u0001\u00053p\r>\u0014X.\u0019;UK6\u0004xN]1m)9\ti\"!\t\u0002$\u0005M\u0012qGA\u001d\u0003w!2aLA\u0010\u0011\u0015\u0011U\u0001q\u0001D\u0011\u0015yW\u00011\u0001q\u0011\u001d\t)#\u0002a\u0001\u0003O\ta\u0001\\8dC2,\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055R/\u0001\u0003vi&d\u0017\u0002BA\u0019\u0003W\u0011a\u0001T8dC2,\u0007BBA\u001b\u000b\u0001\u0007q&\u0001\u0004g_Jl\u0017\r\u001e\u0005\u0007\u0003\u0013)\u0001\u0019\u0001.\t\u000b\u0005,\u0001\u0019\u00012\t\r!+\u0001\u0019AA\u001fa\u0011\ty$a\u0011\u0011\t!Z\u0015\u0011\t\t\u0004\u001d\u0006\rCaCA#\u0003w\t\t\u0011!A\u0003\u0002E\u00131a\u0018\u00134\u0003U!WMZ1vYR4uN]7biR+W\u000e]8sC2$2aLA&\u0011\u0015yg\u00011\u0001q\u000311wN]7bi:+XNY3s))\t\t&a\u0018\u0002t\u0005]\u0014\u0011\u0010\u000b\u0005\u0003'\ni\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tI&^\u0001\u0005Y\u0006tw-C\u00029\u0003/BQAQ\u0004A\u0004\rCq!!\u0019\b\u0001\u0004\t\u0019'A\u0001o!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nA!\\1uQ*\u0011\u0011QN\u0001\u0006gBL'/Z\u0005\u0005\u0003c\n9G\u0001\u0004Ok6\u0014WM\u001d\u0005\u0007\u0003k:\u0001\u0019A>\u0002\u00175\f\u0017PQ3TG\",W.\u0019\u0005\u0006C\u001e\u0001\rA\u0019\u0005\u0007\u0011\u001e\u0001\r!a\u001f1\t\u0005u\u0014\u0011\u0011\t\u0005Q-\u000by\bE\u0002O\u0003\u0003#1\"a!\u0002z\u0005\u0005\t\u0011!B\u0001#\n\u0019q\f\n\u001b\u0002\u001d9,XNY3s)>\u001cFO]5oOR\u0019q&!#\t\u000f\u0005\u0005\u0004\u00021\u0001\u0002d\u0005i1\u000b\u001e:j]\u001e\u001cu.\u001a:dKJ\u0004\"\u0001\n\u0006\u0014\u0005)aDCAAG\u0001")
public class StringCoercer
implements ValueCoercer<StringValue> {
    private final Option<String> valueS;

    @Override
    public Option<StringValue> coerceMaybe(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetType, locationCapable, evaluationContext);
    }

    @Override
    public StringValue coerce(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext ctx) {
        StringValue stringValue;
        block54: {
            Option<String> option;
            String result;
            block50: {
                block52: {
                    String expectedString;
                    block53: {
                        String string;
                        String string2;
                        block51: {
                            Type type;
                            Type type2;
                            Type type3;
                            Type type4;
                            Type type5;
                            Type type6;
                            Type type7;
                            Type type8;
                            Type type9;
                            Type type10;
                            Type type11;
                            Type type12;
                            Type type13;
                            Type type14;
                            Type type15;
                            Type type16;
                            String string3;
                            Type type17;
                            Type type18 = value.valueType(ctx);
                            if (type18 != null && (type17 = type18).isInstanceOf(StringType$.MODULE$, ctx)) {
                                string3 = (String)value.evaluate(ctx);
                            } else if (type18 != null && (type16 = type18).isInstanceOf(DateTimeType$.MODULE$, ctx)) {
                                string3 = this.formatTemporal((ZonedDateTime)value.evaluate(ctx), targetType.schema(ctx), DateTimeType$.MODULE$, locationCapable, value, ctx);
                            } else if (type18 != null && (type15 = type18).isInstanceOf(LocalDateTimeType$.MODULE$, ctx)) {
                                string3 = this.formatTemporal((LocalDateTime)value.evaluate(ctx), targetType.schema(ctx), LocalDateTimeType$.MODULE$, locationCapable, value, ctx);
                            } else if (type18 != null && (type14 = type18).isInstanceOf(LocalTimeType$.MODULE$, ctx)) {
                                string3 = this.formatTemporal((LocalTime)value.evaluate(ctx), targetType.schema(ctx), LocalTimeType$.MODULE$, locationCapable, value, ctx);
                            } else if (type18 != null && (type13 = type18).isInstanceOf(LocalDateType$.MODULE$, ctx)) {
                                string3 = this.formatTemporal((LocalDate)value.evaluate(ctx), targetType.schema(ctx), LocalDateType$.MODULE$, locationCapable, value, ctx);
                            } else if (type18 != null && (type12 = type18).isInstanceOf(TimeType$.MODULE$, ctx)) {
                                string3 = this.formatTemporal((OffsetTime)value.evaluate(ctx), targetType.schema(ctx), TimeType$.MODULE$, locationCapable, value, ctx);
                            } else if (type18 != null && (type11 = type18).isInstanceOf(PeriodType$.MODULE$, ctx)) {
                                string3 = ((TemporalAmount)value.evaluate(ctx)).toString();
                            } else if (type18 != null && (type10 = type18).isInstanceOf(TimeZoneType$.MODULE$, ctx)) {
                                string3 = ((ZoneId)value.evaluate(ctx)).toString();
                            } else if (type18 != null && (type9 = type18).isInstanceOf(NumberType$.MODULE$, ctx)) {
                                string3 = this.formatNumber((Number)value.evaluate(ctx), targetType.schema(ctx), locationCapable, value, ctx);
                            } else if (type18 != null && (type8 = type18).isInstanceOf(BooleanType$.MODULE$, ctx)) {
                                string3 = ((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean(value.evaluate(ctx)))).toString();
                            } else if (type18 != null && (type7 = type18).isInstanceOf(UriType$.MODULE$, ctx)) {
                                string3 = ((URI)value.evaluate(ctx)).toString();
                            } else if (type18 != null && (type6 = type18).isInstanceOf(BinaryType$.MODULE$, ctx)) {
                                String string4;
                                Value binaryValue = BinaryType$.MODULE$.coerce(value, ctx);
                                Option maybeBase = targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.base(ctx));
                                if (maybeBase.isDefined()) {
                                    String string5;
                                    String base = (String)maybeBase.get();
                                    String string6 = base;
                                    if ("64".equals(string6)) {
                                        string5 = BinaryHelper$.MODULE$.toBase64String((SeekableStream)binaryValue.evaluate(ctx));
                                    } else if ("16".equals(string6)) {
                                        byte[] content = BinaryValue$.MODULE$.getBytes(binaryValue, BinaryValue$.MODULE$.getBytes$default$2(), ctx);
                                        string5 = BinaryHelper$.MODULE$.toHexString(content);
                                    } else {
                                        throw new UnsupportedBasePropertyException(((LocationCapable)((Schema)targetType.schema(ctx).get()).valueOf(Schema$.MODULE$.BASE_PROPERTY_NAME(), ctx).get()).location(), BinaryType$.MODULE$, StringType$.MODULE$, string6, ctx);
                                    }
                                    string4 = string5;
                                } else {
                                    Charset charset = (Charset)targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.encoding(ctx).map((Function1 & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ctx.serviceManager().charsetProviderService().defaultCharset());
                                    string4 = BinaryValue$.MODULE$.toString((SeekableStream)binaryValue.evaluate(ctx), charset, BinaryValue$.MODULE$.toString$default$3());
                                }
                                string3 = string4;
                            } else if (type18 != null && (type5 = type18).isInstanceOf(NameType$.MODULE$, ctx)) {
                                string3 = ((QualifiedName)value.evaluate(ctx)).name();
                            } else if (type18 != null && (type4 = type18).isInstanceOf(TypeType$.MODULE$, ctx)) {
                                string3 = ((Type)value.evaluate(ctx)).name();
                            } else if (type18 != null && (type3 = type18).isInstanceOf(KeyType$.MODULE$, ctx)) {
                                string3 = ((QualifiedName)value.evaluate(ctx)).name();
                            } else if (type18 != null && (type2 = type18).isInstanceOf(RegexType$.MODULE$, ctx)) {
                                string3 = ((Regex)value.evaluate(ctx)).toString();
                            } else if (type18 != null && (type = type18).isInstanceOf(NamespaceType$.MODULE$, ctx)) {
                                string3 = ((Namespace)value.evaluate(ctx)).uri();
                            } else {
                                Option<String> option2 = this.valueS;
                                if (option2 instanceof Some) {
                                    Some some = (Some)option2;
                                    String expectedString2 = (String)some.value();
                                    throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, expectedString2, value, ctx);
                                }
                                if (None$.MODULE$.equals(option2)) {
                                    throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> String.valueOf(value), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                                }
                                throw new MatchError(option2);
                            }
                            result = string3;
                            option = this.valueS;
                            if (!(option instanceof Some)) break block50;
                            Some some = (Some)option;
                            string2 = expectedString = (String)some.value();
                            string = result;
                            if (string2 != null) break block51;
                            if (string == null) break block52;
                            break block53;
                        }
                        if (string2.equals(string)) break block52;
                    }
                    throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, expectedString, value, ctx);
                }
                stringValue = StringValue$.MODULE$.apply(result, locationCapable, targetType);
                break block54;
            }
            if (None$.MODULE$.equals(option)) {
                stringValue = StringValue$.MODULE$.apply(result, locationCapable, targetType);
            } else {
                throw new MatchError(option);
            }
        }
        return stringValue;
    }

    public String formatTemporal(TemporalAccessor temporal, Option<Schema> schema, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        Option formattedStringMaybe = schema.flatMap((Function1 & Serializable & scala.Serializable)schemaValue -> schemaValue.format(ctx).map((Function1 & Serializable & scala.Serializable)format -> this.doFormatTemporal(temporal, (Locale)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)localeString -> Locale.forLanguageTag(localeString)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Locale.getDefault()), (String)format, sourceType, locationCapable, value, ctx)));
        return (String)formattedStringMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultFormatTemporal(temporal));
    }

    public String doFormatTemporal(TemporalAccessor temporal, Locale locale, String format, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        String string;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, locale);
            string = formatter.format(temporal);
        }
        catch (DateTimeException dte) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)dte.getMessage()), ctx);
        }
        catch (IllegalArgumentException iae) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
        }
        return string;
    }

    public String defaultFormatTemporal(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof OffsetTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_TIME;
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    public String formatNumber(Number n, Option<Schema> mayBeSchema, LocationCapable locationCapable, Value<?> value2, EvaluationContext ctx) {
        String string;
        Option<Schema> option = mayBeSchema;
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                String string3;
                Some some2 = (Some)option2;
                String f = (String)some2.value();
                try {
                    DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0 & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                    DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                    RoundingMode halfup = (RoundingMode)((Object)schemaValue.roundMode(ctx).flatMap((Function1 & Serializable & scala.Serializable)value -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> RoundingMode.valueOf(value)).toOption()).getOrElse((Function0 & Serializable & scala.Serializable)() -> RoundingMode.HALF_UP));
                    formatter.setRoundingMode(halfup);
                    formatter.setParseBigDecimal(true);
                    string3 = formatter.format(n.toBigDecimal().bigDecimal());
                }
                catch (IllegalArgumentException iae) {
                    throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), NumberType$.MODULE$, StringType$.MODULE$, value2, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
                }
                string2 = string3;
            } else {
                string2 = this.numberToString(n);
            }
            string = string2;
        } else {
            string = this.numberToString(n);
        }
        return string;
    }

    public String numberToString(Number n) {
        return n.isWhole() ? (n.withinInt() ? ((Object)BoxesRunTime.boxToInteger((int)n.toInt())).toString() : (n.withinLong() ? ((Object)BoxesRunTime.boxToLong((long)n.toLong())).toString() : n.toBigInt().toString())) : n.toString();
    }

    public StringCoercer(Option<String> valueS) {
        this.valueS = valueS;
        ValueCoercer.$init$(this);
    }
}

