/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.avro;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.avro.AvroDataFormat;
import org.mule.weave.v2.module.avro.AvroSettings;
import org.mule.weave.v2.module.avro.AvroWriter$;
import org.mule.weave.v2.module.avro.exception.AvroInvalidTypeException;
import org.mule.weave.v2.module.avro.exception.InvalidFieldNameException;
import org.mule.weave.v2.module.avro.exception.InvalidFieldValueException;
import org.mule.weave.v2.module.avro.exception.InvalidValueForUnionException;
import org.mule.weave.v2.module.avro.exception.InvalidValueTypeException;
import org.mule.weave.v2.module.avro.exception.MissingRequiredFieldException;
import org.mule.weave.v2.module.avro.exception.MissingRequiredSettingException;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.math.ScalaNumericAnyConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011)\u0019!C\u0001o!AA\b\u0001B\u0001B\u0003%\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015a\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0001\u0006\u0001\"\u0011M\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u000b\u0001\t#\nY\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u001d9\u0011\u0011M\n\t\u0002\u0005\rdA\u0002\n\u0014\u0011\u0003\t)\u0007\u0003\u0004E\u001f\u0011\u0005\u0011q\r\u0005\b\u0003SzA\u0011AA6\u0005)\teO]8Xe&$XM\u001d\u0006\u0003)U\tA!\u0019<s_*\u0011acF\u0001\u0007[>$W\u000f\\3\u000b\u0005aI\u0012A\u0001<3\u0015\tQ2$A\u0003xK\u00064XM\u0003\u0002\u001d;\u0005!Q.\u001e7f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000b\u0002\r]\u0014\u0018\u000e^3s\u0013\ta\u0013F\u0001\u0004Xe&$XM]\u0001\u0003_N\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005%|'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012AbT;uaV$8\u000b\u001e:fC6\f\u0001b]3ui&twm]\u000b\u0002qA\u0011\u0011HO\u0007\u0002'%\u00111h\u0005\u0002\r\u0003Z\u0014xnU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n1a\u0019;y!\ty$)D\u0001A\u0015\t\tu#A\u0003n_\u0012,G.\u0003\u0002D\u0001\n\tRI^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r1\u0015J\u0013\u000b\u0003\u000f\"\u0003\"!\u000f\u0001\t\u000bu*\u00019\u0001 \t\u000b5*\u0001\u0019\u0001\u0018\t\u000bY*\u0001\u0019\u0001\u001d\u0002\u000b\u0019dWo\u001d5\u0015\u00035\u0003\"A\t(\n\u0005=\u001b#\u0001B+oSR\fQa\u00197pg\u0016\f1b\u001e:ji\u0016|%M[3diR\u00191\u000b\u00174\u0015\u0005Q;\u0006C\u0001\u0012V\u0013\t16EA\u0002B]fDQ!\u0010\u0005A\u0004yBQ!\u0017\u0005A\u0002i\u000b\u0011A\u001e\t\u00047z\u0003W\"\u0001/\u000b\u0005u\u0003\u0015A\u0002<bYV,7/\u0003\u0002`9\n)a+\u00197vKB\u0011\u0011\rZ\u0007\u0002E*\u00111\rQ\u0001\ngR\u0014Xo\u0019;ve\u0016L!!\u001a2\u0003\u0013=\u0013'.Z2u'\u0016\f\b\"B4\t\u0001\u0004A\u0017AB:dQ\u0016l\u0017\r\u0005\u0002j[6\t!N\u0003\u0002\u0015W*\u0011A.H\u0001\u0007CB\f7\r[3\n\u00059T'AB*dQ\u0016l\u0017-\u0001\u0006xe&$X-\u0011:sCf$B!]?\u0002\bQ\u0011!\u000f \t\u0004gf$fB\u0001;x\u001b\u0005)(B\u0001<k\u0003\u001d9WM\\3sS\u000eL!\u0001_;\u0002\u0017\u001d+g.\u001a:jG\u0012\u000bG/Y\u0005\u0003un\u0014Q!\u0011:sCfT!\u0001_;\t\u000buJ\u00019\u0001 \t\u000byL\u0001\u0019A@\u0002\u000bY\fG.^3\u0011\tms\u0016\u0011\u0001\t\u0004C\u0006\r\u0011bAA\u0003E\nA\u0011I\u001d:bsN+\u0017\u000fC\u0003h\u0013\u0001\u0007\u0001.A\u0003xe&$X\r\u0006\u0004\u0002\u000e\u0005E\u0011q\u0005\u000b\u0004)\u0006=\u0001\"B\u001f\u000b\u0001\bq\u0004B\u0002@\u000b\u0001\u0004\t\u0019\u0002\r\u0003\u0002\u0016\u0005m\u0001\u0003B._\u0003/\u0001B!!\u0007\u0002\u001c1\u0001A\u0001DA\u000f\u0003#\t\t\u0011!A\u0003\u0002\u0005}!aA0%cE\u0019\u0011\u0011\u0005+\u0011\u0007\t\n\u0019#C\u0002\u0002&\r\u0012qAT8uQ&tw\rC\u0003h\u0015\u0001\u0007\u0001.\u0001\u0007e_^\u0013\u0018\u000e^3WC2,X\r\u0006\u0003\u0002.\u0005EBcA'\u00020!)Qh\u0003a\u0002}!1ap\u0003a\u0001\u0003g\u0001D!!\u000e\u0002:A!1LXA\u001c!\u0011\tI\"!\u000f\u0005\u0019\u0005m\u0012\u0011GA\u0001\u0002\u0003\u0015\t!a\b\u0003\u0007}##'\u0001\u0004sKN,H\u000e^\u000b\u0002)\u0006QA-\u0019;b\r>\u0014X.\u0019;\u0016\u0005\u0005\u0015\u0003#\u0002\u0012\u0002H\u0005-\u0013bAA%G\t1q\n\u001d;j_:\u0004d!!\u0014\u0002X\u0005u\u0003\u0003CA(\u0003#\n)&a\u0017\u000e\u0003UI1!a\u0015\u0016\u0005)!\u0015\r^1G_Jl\u0017\r\u001e\t\u0005\u00033\t9\u0006B\u0006\u0002Z5\t\t\u0011!A\u0003\u0002\u0005}!aA0%gA!\u0011\u0011DA/\t-\ty&DA\u0001\u0002\u0003\u0015\t!a\b\u0003\u0007}#C'\u0001\u0006BmJ|wK]5uKJ\u0004\"!O\b\u0014\u0005=\tCCAA2\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ti'!\u001d\u0002|Q\u0019q)a\u001c\t\u000bu\n\u00029\u0001 \t\u000f\u0005M\u0014\u00031\u0001\u0002v\u0005\u0011A\u000f\u001d\t\u0004Q\u0005]\u0014bAA=S\tqA+\u0019:hKR\u0004&o\u001c<jI\u0016\u0014\b\"\u0002\u001c\u0012\u0001\u0004A\u0004")
public class AvroWriter
implements Writer {
    private final OutputStream os;
    private final AvroSettings settings;

    public static AvroWriter apply(TargetProvider targetProvider, AvroSettings avroSettings, EvaluationContext evaluationContext) {
        return AvroWriter$.MODULE$.apply(targetProvider, avroSettings, evaluationContext);
    }

    @Override
    public boolean supportsStreaming() {
        return Writer.supportsStreaming$(this);
    }

    @Override
    public void startDocument(LocationCapable location) {
        Writer.startDocument$(this, location);
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$(this, location, prefix, uri);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    @Override
    public AvroSettings settings() {
        return this.settings;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public Object writeObject(Value<ObjectSeq> v, Schema schema, EvaluationContext ctx) {
        GenericData.Record record;
        ObjectSeq objectSeq = v.evaluate(ctx);
        Schema.Type type = schema.getType();
        if (Schema.Type.MAP.equals(type)) {
            GenericData.Record map = new HashMap();
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
                return map.put(name, this.write((Value<?>)kvp._2(), schema.getValueType(), ctx));
            });
            record = map;
        } else if (Schema.Type.RECORD.equals(type)) {
            GenericData.Record record2 = new GenericData.Record(schema);
            Schema.Field[] processedFields = new Schema.Field[schema.getFields().size()];
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                AvroWriter.$anonfun$writeObject$2(this, ctx, schema, record2, processedFields, kvp);
                return BoxedUnit.UNIT;
            });
            schema.getFields().forEach(missingField -> {
                if (processedFields[missingField.pos()] == null) {
                    if (missingField.defaultVal() != null) {
                        record2.put(missingField.pos(), missingField.defaultVal());
                    } else {
                        Schema fieldSchema = missingField.schema();
                        throw new MissingRequiredFieldException(missingField.name(), fieldSchema.getType().name().toLowerCase(), schema.getFullName(), v.location());
                    }
                }
            });
            record = record2;
        } else {
            throw new InvalidValueTypeException(v.valueType(ctx), type, v.location());
        }
        return record;
    }

    public GenericData.Array<Object> writeArray(Value<ArraySeq> value, Schema schema, EvaluationContext ctx) {
        Schema.Type type = schema.getType();
        if (!Schema.Type.ARRAY.equals(type)) {
            throw new InvalidValueTypeException(ArrayType$.MODULE$, type, value.location());
        }
        Seq<Value<?>> evaluate = value.evaluate(ctx).toSeq();
        Schema elementType = schema.getElementType();
        GenericData.Array result = new GenericData.Array(evaluate.size(), schema);
        evaluate.foreach((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)result.add(this.write(v, elementType, ctx))));
        GenericData.Array array = result;
        return array;
    }

    public Object write(Value<?> value, Schema schema, EvaluationContext ctx) {
        Object object;
        Schema.Type type = schema.getType();
        if (Schema.Type.UNION.equals(type)) {
            Object v;
            Value<?> materializedValue = value.materialize(ctx);
            List types = schema.getTypes();
            IntRef i = IntRef.create((int)0);
            ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            None$ result = None$.MODULE$;
            while (result.isEmpty() && i.elem < types.size()) {
                ArrayBuffer arrayBuffer;
                Try writeResult = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.write(materializedValue, (Schema)types.get(i$1.elem), ctx));
                Try try_ = writeResult;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    arrayBuffer = exceptions.$plus$eq((Object)exception);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object value2 = success.value();
                    result = new Some(value2);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
                ++i.elem;
            }
            None$ none$ = result;
            if (!(none$ instanceof Some)) {
                if (None$.MODULE$.equals(none$)) {
                    throw new InvalidValueForUnionException((Seq<Throwable>)exceptions, value.location(), (Seq<Schema.Type>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(types).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())), value.valueType(ctx));
                }
                throw new MatchError((Object)none$);
            }
            Some some = (Some)none$;
            Object object2 = v = some.value();
            object = object2;
        } else {
            Object object3;
            Type type2 = value.valueType(ctx);
            if (type2.isInstanceOf(ObjectType$.MODULE$, ctx)) {
                object3 = this.writeObject(ObjectType$.MODULE$.coerce(value, ctx), schema, ctx);
            } else if (type2.isInstanceOf(ArrayType$.MODULE$, ctx)) {
                object3 = this.writeArray(ArrayType$.MODULE$.coerce(value, ctx), schema, ctx);
            } else if (type2.isInstanceOf(RangeType$.MODULE$, ctx)) {
                object3 = this.writeArray(ArrayType$.MODULE$.coerce(value, ctx), schema, ctx);
            } else {
                Object object4;
                Schema.Type type3 = schema.getType();
                if (Schema.Type.LONG.equals(type3)) {
                    object4 = BoxesRunTime.boxToLong((long)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toLong());
                } else if (Schema.Type.INT.equals(type3)) {
                    object4 = BoxesRunTime.boxToInteger((int)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInt());
                } else if (Schema.Type.FLOAT.equals(type3)) {
                    object4 = BoxesRunTime.boxToFloat((float)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toFloat());
                } else if (Schema.Type.DOUBLE.equals(type3)) {
                    object4 = BoxesRunTime.boxToDouble((double)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toDouble());
                } else if (Schema.Type.BOOLEAN.equals(type3)) {
                    object4 = BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                } else if (Schema.Type.STRING.equals(type3)) {
                    String value3;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
                    if (try_ instanceof Failure) {
                        throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.STRING, value.location());
                    }
                    if (!(try_ instanceof Success)) {
                        throw new MatchError((Object)try_);
                    }
                    Success success = (Success)try_;
                    String string = value3 = (String)success.value();
                    object4 = string;
                } else if (Schema.Type.BYTES.equals(type3)) {
                    object4 = BinaryValue$.MODULE$.getBytes(BinaryType$.MODULE$.coerce(value, ctx), BinaryValue$.MODULE$.getBytes$default$2(), ctx);
                } else if (Schema.Type.ENUM.equals(type3)) {
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
                    if (try_ instanceof Failure) {
                        throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.STRING, value.location());
                    }
                    if (!(try_ instanceof Success)) {
                        throw new MatchError((Object)try_);
                    }
                    Success success = (Success)try_;
                    String value4 = (String)success.value();
                    GenericData.EnumSymbol enumSymbol = new GenericData.EnumSymbol(schema, value4);
                    object4 = enumSymbol;
                } else if (Schema.Type.FIXED.equals(type3)) {
                    String value5;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
                    if (try_ instanceof Failure) {
                        throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.STRING, value.location());
                    }
                    if (!(try_ instanceof Success)) {
                        throw new MatchError((Object)try_);
                    }
                    Success success = (Success)try_;
                    String string = value5 = (String)success.value();
                    object4 = string;
                } else if (Schema.Type.NULL.equals(type3)) {
                    object4 = NullType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                } else {
                    throw new InvalidValueTypeException(value.valueType(ctx), type3, value.location());
                }
                object3 = object4;
            }
            object = object3;
        }
        return object;
    }

    @Override
    public void doWriteValue(Value<?> value2, EvaluationContext ctx) {
        if (this.settings().schema() == null) {
            throw new MissingRequiredSettingException("schemaUrl", "Avro Writer", value2.location());
        }
        Schema schema = new Schema.Parser().parse(this.settings().schema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, this.os);
        Type type = value2.valueType(ctx);
        if (type.isInstanceOf(ObjectType$.MODULE$, ctx)) {
            Object result = this.write(value2, schema, ctx);
            Object object = result;
            if (!(object instanceof GenericRecord)) {
                throw new InvalidValueTypeException(value2.valueType(ctx), schema.getType(), value2.location());
            }
            GenericRecord genericRecord = (GenericRecord)object;
            dataFileWriter.append((Object)genericRecord);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (type.isInstanceOf(ArrayType$.MODULE$, ctx)) {
            Iterator<Value<?>> iterator = ((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator();
            iterator.foreach((Function1 & Serializable & scala.Serializable)value -> {
                AvroWriter.$anonfun$doWriteValue$1(this, schema, ctx, dataFileWriter, value);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)type);
        }
        dataFileWriter.flush();
        dataFileWriter.close();
    }

    @Override
    public Object result() {
        return this.os;
    }

    @Override
    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new AvroDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeObject$2(AvroWriter $this, EvaluationContext ctx$1, Schema schema$1, GenericData.Record record$1, Schema.Field[] processedFields$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$1)).name();
        Schema.Field field = schema$1.getField(name);
        if (field == null) {
            throw new InvalidFieldNameException(name, (Seq<String>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Buffer$.MODULE$.canBuildFrom())), kvp._1().location());
        }
        try {
            Object value = $this.write((Value<?>)kvp._2(), field.schema(), ctx$1);
            record$1.put(name, value);
            processedFields$1[field.pos()] = field;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AvroInvalidTypeException) {
                AvroInvalidTypeException avroInvalidTypeException = (AvroInvalidTypeException)((Object)throwable2);
                throw new InvalidFieldValueException(name, avroInvalidTypeException.message(), kvp._1().location());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(AvroWriter $this, Schema schema$2, EvaluationContext ctx$4, DataFileWriter dataFileWriter$1, Value value) {
        Object result = $this.write(value, schema$2, ctx$4);
        Object object = result;
        if (!(object instanceof GenericRecord)) {
            throw new InvalidValueTypeException(value.valueType(ctx$4), schema$2.getType(), value.location());
        }
        GenericRecord genericRecord = (GenericRecord)object;
        dataFileWriter$1.append((Object)genericRecord);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AvroWriter(OutputStream os, AvroSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
    }
}

