/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionUtils;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.util.rx.ReactorTransactionUtils;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class TryScope
extends AbstractMessageProcessorOwner
implements Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryScope.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;
    private FlowExceptionHandler messagingExceptionHandler;
    private List<Processor> processors;
    @Inject
    private ProfilingService profilingService;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> continueProducer;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> startProducer;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> commitProducer;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        if (this.transactionConfig.getAction() == 6) {
            return Flux.from(publisher).doOnNext(e -> TransactionUtils.profileTransactionAction(this.continueProducer, RuntimeProfilingEventTypes.TX_CONTINUE, this.getLocation())).transform((Function)this.nestedChain);
        }
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createScopeTransactionalExecutionTemplate(this.muleContext, this.transactionConfig);
        I18nMessage txErrorMessage = CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.nestedChain, this.transactionConfig);
        return Mono.subscriberContext().flatMapMany(ctx -> Flux.from((Publisher)publisher).handle((event, sink) -> {
            boolean txPrevoiuslyActive = TransactionCoordination.isTransactionActive();
            Transaction previousTx = this.getCurrentTx();
            try {
                sink.next((Object)executionTemplate.execute(() -> {
                    this.handlePreviousTransaction(txPrevoiuslyActive, previousTx, this.getCurrentTx());
                    this.profileBeforeExecution(txPrevoiuslyActive);
                    CoreEvent result = this.processBlocking((Context)ctx, (CoreEvent)event);
                    this.profileAfterExecution(txPrevoiuslyActive);
                    return result;
                }));
            }
            catch (Exception e) {
                Throwable unwrapped = Exceptions.unwrap(e);
                if (unwrapped instanceof MuleException) {
                    sink.error(unwrapped);
                }
                sink.error((Throwable)new DefaultMuleException(txErrorMessage, unwrapped));
            }
        }));
    }

    private void profileBeforeExecution(boolean txPrevoiuslyActive) {
        if (txPrevoiuslyActive) {
            TransactionUtils.profileTransactionAction(this.continueProducer, RuntimeProfilingEventTypes.TX_CONTINUE, this.getLocation());
        } else {
            TransactionUtils.profileTransactionAction(this.startProducer, RuntimeProfilingEventTypes.TX_START, this.getLocation());
        }
    }

    private void profileAfterExecution(boolean txPrevoiuslyActive) {
        if (txPrevoiuslyActive) {
            TransactionUtils.profileTransactionAction(this.continueProducer, RuntimeProfilingEventTypes.TX_CONTINUE, this.getLocation());
        } else {
            TransactionUtils.profileTransactionAction(this.commitProducer, RuntimeProfilingEventTypes.TX_COMMIT, this.getLocation());
        }
    }

    private void handlePreviousTransaction(boolean txPrevoiuslyActive, Transaction previousTx, Transaction currentTx) {
        if (!txPrevoiuslyActive && TransactionCoordination.isTransactionActive() || txPrevoiuslyActive && previousTx != currentTx) {
            TransactionAdapter transaction = (TransactionAdapter)currentTx;
            transaction.setComponentLocation(this.getLocation());
        }
    }

    private CoreEvent processBlocking(Context ctx, CoreEvent event) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).subscriberContext(ReactorTransactionUtils.popTxFromSubscriberContext()).transform((Function)this.nestedChain).onErrorStop().subscriberContext(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true)).subscriberContext(ReactorTransactionUtils.pushTxToSubscriberContext(this.getLocation().getLocation())).subscriberContext(ctx).block();
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    private Transaction getCurrentTx() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler(Optional.of(this.getRootContainerLocation().toString()));
            if (this.shouldSetLocation()) {
                ((ErrorHandler)this.messagingExceptionHandler).setExceptionListenersLocation(this.getLocation());
            }
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this), this.processors, this.messagingExceptionHandler, this.getLocation().getLocation());
        LifecycleUtils.initialiseIfNeeded(this.messagingExceptionHandler, true, this.muleContext);
        this.continueProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_CONTINUE);
        this.startProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_START);
        this.commitProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_COMMIT);
        super.initialise();
    }

    private boolean shouldSetLocation() {
        return (!TemplateOnErrorHandler.reuseGlobalErrorHandler() || !(this.messagingExceptionHandler instanceof GlobalErrorHandler)) && this.messagingExceptionHandler instanceof ErrorHandler;
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messagingExceptionHandler, LOGGER);
        super.dispose();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messagingExceptionHandler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messagingExceptionHandler);
        super.stop();
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        byte txAction = this.transactionConfig.getAction();
        if (txAction == 1 || txAction == 2) {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
        return ReactiveProcessor.ProcessingType.CPU_LITE;
    }
}

