/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DefaultArtifactDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.DeploymentMuleContextListenerFactory;
import org.mule.runtime.module.deployment.internal.DeploymentStatusTracker;
import org.mule.runtime.module.deployment.internal.DomainArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.ParallelDeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.StartupSummaryDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDeploymentService
implements DeploymentService {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final IOFileFilter JAR_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".jar"), FileFileFilter.FILE);
    public static final String PARALLEL_DEPLOYMENT_PROPERTY = "mule.deployment.parallel";
    private static final int MAX_QUEUED_STARTING_ARTIFACTS = 256;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock deploymentLock = new DebuggableReentrantLock(true);
    private final LazyValue<Scheduler> artifactStartExecutor;
    private final ObservableList<Application> applications = new ObservableList();
    private final ObservableList<Domain> domains = new ObservableList();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();
    private final CompositeDeploymentListener applicationDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainBundleDeploymentListener = new CompositeDeploymentListener();
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentDirectoryWatcher deploymentDirectoryWatcher;
    private final DefaultArchiveDeployer<Application> applicationDeployer;
    private final DomainBundleArchiveDeployer domainBundleDeployer;

    public MuleDeploymentService(DefaultDomainFactory domainFactory, DefaultApplicationFactory applicationFactory, Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.artifactStartExecutor = new LazyValue<Supplier<Scheduler>>(() -> ((SchedulerService)artifactStartExecutorSupplier.get()).customScheduler(SchedulerConfig.config().withName("ArtifactDeployer.start").withMaxConcurrentTasks(MuleDeploymentService.useParallelDeployment() ? 20 : 1), 256));
        DefaultArtifactDeployer applicationMuleDeployer = new DefaultArtifactDeployer(this.artifactStartExecutor);
        DefaultArtifactDeployer domainMuleDeployer = new DefaultArtifactDeployer(this.artifactStartExecutor);
        this.applicationDeployer = new DefaultArchiveDeployer<Application>(applicationMuleDeployer, applicationFactory, this.applications, ArtifactDeploymentTemplate.NOP_ARTIFACT_DEPLOYMENT_TEMPLATE, new DeploymentMuleContextListenerFactory(this.applicationDeploymentListener));
        this.applicationDeployer.setDeploymentListener(this.applicationDeploymentListener);
        this.domainDeployer = this.createDomainArchiveDeployer(domainFactory, domainMuleDeployer, this.domains, this.applicationDeployer, this.applicationDeploymentListener, this.domainDeploymentListener);
        this.domainDeployer.setDeploymentListener(this.domainDeploymentListener);
        this.domainBundleDeployer = new DomainBundleArchiveDeployer(this.domainBundleDeploymentListener, this.domainDeployer, this.domains, this.applicationDeployer, this.applications, this.domainDeploymentListener, this.applicationDeploymentListener, this);
        if (MuleDeploymentService.useParallelDeployment()) {
            if (this.isDeployingSelectedAppsInOrder()) {
                throw new IllegalArgumentException(String.format("Deployment parameters '%s' and '%s' cannot be used together", "mule.deploy.applications", PARALLEL_DEPLOYMENT_PROPERTY));
            }
            this.logger.info("Using parallel deployment");
            this.deploymentDirectoryWatcher = new ParallelDeploymentDirectoryWatcher(this.domainBundleDeployer, this.domainDeployer, this.applicationDeployer, this.domains, this.applications, artifactStartExecutorSupplier, this.deploymentLock);
        } else {
            this.deploymentDirectoryWatcher = new DeploymentDirectoryWatcher(this.domainBundleDeployer, this.domainDeployer, this.applicationDeployer, this.domains, this.applications, artifactStartExecutorSupplier, this.deploymentLock);
        }
    }

    static boolean useParallelDeployment() {
        return System.getProperties().containsKey(PARALLEL_DEPLOYMENT_PROPERTY);
    }

    private boolean isDeployingSelectedAppsInOrder() {
        return !StringUtils.isEmpty((CharSequence)System.getProperty("mule.deploy.applications"));
    }

    @Override
    public void start() {
        DeploymentStatusTracker deploymentStatusTracker = new DeploymentStatusTracker();
        this.addDeploymentListener(deploymentStatusTracker.getApplicationDeploymentStatusTracker());
        this.addDomainDeploymentListener(deploymentStatusTracker.getDomainDeploymentStatusTracker());
        StartupSummaryDeploymentListener summaryDeploymentListener = new StartupSummaryDeploymentListener(deploymentStatusTracker, this);
        this.addStartupListener(summaryDeploymentListener);
        this.deploymentDirectoryWatcher.start();
        this.notifyStartupListeners();
    }

    protected void notifyStartupListeners() {
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                this.logger.error("Error executing startup listener {}", (Object)listener, (Object)t);
            }
        }
    }

    @Override
    public void stop() {
        this.deploymentDirectoryWatcher.stop();
        this.artifactStartExecutor.ifComputed(ExecutorService::shutdownNow);
    }

    @Override
    public Domain findDomain(String domainName) {
        return this.deploymentDirectoryWatcher.findArtifact(domainName, this.domains);
    }

    @Override
    public Application findApplication(String appName) {
        return this.deploymentDirectoryWatcher.findArtifact(appName, this.applications);
    }

    @Override
    public Collection<Application> findDomainApplications(String domain) {
        Preconditions.checkArgument(domain != null, "Domain name cannot be null");
        return this.applications.stream().filter(application -> application.getDomain() != null && application.getDomain().getArtifactName().equals(domain)).collect(Collectors.toList());
    }

    @Override
    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public List<Domain> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    Map<String, Map<URI, Long>> getZombieApplications() {
        return this.applicationDeployer.getArtifactsZombieMap();
    }

    Map<String, Map<URI, Long>> getZombieDomains() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    public void setAppFactory(ArtifactFactory<Application> appFactory) {
        this.applicationDeployer.setArtifactFactory(appFactory);
    }

    @Override
    public ReentrantLock getLock() {
        return this.deploymentLock;
    }

    @Override
    public void undeploy(String appName) {
        this.executeSynchronized(() -> this.applicationDeployer.undeployArtifact(appName));
    }

    @Override
    public void deploy(URI appArchiveUri) throws IOException {
        this.deploy(appArchiveUri, Optional.empty());
    }

    private void deploy(URI appArchiveUri, Optional<Properties> deploymentProperties) throws IOException {
        this.deployTemplateMethod(appArchiveUri, deploymentProperties, MuleFoldersUtil.getAppsFolder(), this.applicationDeployer);
    }

    @Override
    public void deploy(URI appArchiveUri, Properties appProperties) throws IOException {
        this.deploy(appArchiveUri, Optional.ofNullable(appProperties));
    }

    @Override
    public void redeploy(String artifactName) {
        this.redeploy(artifactName, Optional.empty());
    }

    @Override
    public void redeploy(String artifactName, Properties appProperties) {
        this.redeploy(artifactName, Optional.ofNullable(appProperties));
    }

    @Override
    public void redeploy(URI archiveUri, Properties appProperties) throws IOException {
        this.deployTemplateMethod(archiveUri, Optional.ofNullable(appProperties), MuleFoldersUtil.getAppsFolder(), this.applicationDeployer);
    }

    @Override
    public void redeploy(URI archiveUri) throws IOException {
        this.redeploy(archiveUri, null);
    }

    @Override
    public void undeployDomain(String domainName) {
        this.executeSynchronized(() -> this.domainDeployer.undeployArtifact(domainName));
    }

    @Override
    public void deployDomain(URI domainArchiveUri) throws IOException {
        this.deployDomain(domainArchiveUri, Optional.empty());
    }

    private void deployDomain(URI domainArchiveUri, Optional<Properties> deploymentProperties) throws IOException {
        this.deployTemplateMethod(domainArchiveUri, deploymentProperties, MuleFoldersUtil.getDomainsFolder(), this.domainDeployer);
    }

    @Override
    public void redeployDomain(String domainName) {
        this.redeployDomain(domainName, Optional.empty());
    }

    private void redeployDomain(String domainName, Optional<Properties> deploymentProperties) {
        this.executeSynchronized(() -> this.domainDeployer.redeploy(domainName, deploymentProperties));
    }

    @Override
    public void deployDomainBundle(URI domainArchiveUri) throws IOException {
        this.executeSynchronized(() -> this.domainBundleDeployer.deployArtifact(domainArchiveUri));
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void addDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void addDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainBundleDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainBundleDeploymentListener.removeDeploymentListener(listener);
    }

    public void setDomainFactory(ArtifactFactory<Domain> domainFactory) {
        this.domainDeployer.setArtifactFactory(domainFactory);
    }

    void undeploy(Application app) {
        this.applicationDeployer.undeployArtifact(app.getArtifactName());
    }

    void undeploy(Domain domain) {
        this.domainDeployer.undeployArtifact(domain.getArtifactName());
    }

    private void deployTemplateMethod(URI artifactArchiveUri, Optional<Properties> deploymentProperties, File artifactDeploymentFolder, ArchiveDeployer archiveDeployer) throws IOException {
        this.executeSynchronized(() -> {
            block6: {
                try {
                    File artifactLocation = FileUtils.toFile((URL)artifactArchiveUri.toURL());
                    String fileName = artifactLocation.getName();
                    if (fileName.endsWith(".jar")) {
                        archiveDeployer.deployPackagedArtifact(artifactArchiveUri, deploymentProperties);
                        break block6;
                    }
                    if (!artifactLocation.getParent().equals(artifactDeploymentFolder.getPath())) {
                        try {
                            FileUtils.copyDirectory((File)artifactLocation, (File)new File(artifactDeploymentFolder, fileName));
                        }
                        catch (IOException e) {
                            throw new MuleRuntimeException(e);
                        }
                    }
                    archiveDeployer.deployExplodedArtifact(fileName, deploymentProperties);
                }
                catch (MalformedURLException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        });
    }

    private void executeSynchronized(SynchronizedDeploymentAction deploymentAction) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: " + (this.deploymentLock instanceof DebuggableReentrantLock ? ((DebuggableReentrantLock)this.deploymentLock).getOwner() : "Unknown"));
                }
                return;
            }
            deploymentAction.execute();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public static SchedulerService findSchedulerService(ServiceRepository serviceManager) {
        List<Service> services = serviceManager.getServices();
        return (SchedulerService)services.stream().filter(s -> s instanceof SchedulerService).findFirst().get();
    }

    @Override
    public void deployDomain(URI domainArchiveUri, Properties appProperties) throws IOException {
        this.deployDomain(domainArchiveUri, Optional.ofNullable(appProperties));
    }

    private void redeploy(String artifactName, Optional<Properties> deploymentProperties) {
        this.executeSynchronized(() -> {
            block2: {
                try {
                    this.applicationDeployer.redeploy(artifactName, deploymentProperties);
                }
                catch (DeploymentException e) {
                    if (!this.logger.isDebugEnabled()) break block2;
                    this.logger.debug("Failure while redeploying application: " + artifactName, (Throwable)e);
                }
            }
        });
    }

    @Override
    public void redeployDomain(String domainName, Properties deploymentProperties) {
        this.redeployDomain(domainName, Optional.ofNullable(deploymentProperties));
    }

    protected DomainArchiveDeployer createDomainArchiveDeployer(DefaultDomainFactory domainFactory, ArtifactDeployer domainMuleDeployer, ObservableList<Domain> domains, DefaultArchiveDeployer<Application> applicationDeployer, CompositeDeploymentListener applicationDeploymentListener, DeploymentListener domainDeploymentListener) {
        return new DomainArchiveDeployer(new DefaultArchiveDeployer<Domain>(domainMuleDeployer, domainFactory, domains, new DomainDeploymentTemplate(applicationDeployer, this, applicationDeploymentListener), new DeploymentMuleContextListenerFactory(domainDeploymentListener)), applicationDeployer, this);
    }

    private static interface SynchronizedDeploymentAction {
        public void execute();
    }
}

