/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.beans.Introspector;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMMQResourceReleaser
implements ResourceReleaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IBMMQResourceReleaser.class);
    private static final String AVOID_IBM_MQ_CLEANUP_PROPERTY_NAME = "avoid.ibm.mq.cleanup";
    private static final String AVOID_IBM_MQ_CLEANUP_MBEANS_PROPERTY_NAME = "avoid.ibm.mq.cleanup.mbeans";
    private final boolean IBM_MQ_RESOURCE_RELEASER_AVOID_CLEANUP = Boolean.getBoolean("avoid.ibm.mq.cleanup");
    private final boolean IBM_MQ_RESOURCE_RELEASER_AVOID_CLEANUP_MBEANS = Boolean.getBoolean("avoid.ibm.mq.cleanup.mbeans");
    private static final String THREADLOCALS_FIELD = "threadLocals";
    private static final String INHERITABLE_THREADLOCALS_FIELD = "inheritableThreadLocals";
    private static final String THREADLOCAL_MAP_TABLE_CLASS = "java.lang.ThreadLocal$ThreadLocalMap";
    private static final String JUL_KNOWN_LEVEL_CLASS = "java.util.logging.Level$KnownLevel";
    private static final String IBM_MQ_MBEAN_DOMAIN = "IBM MQ";
    private static final String IBM_MQ_COMMON_SERVICES_CLASS = "com.ibm.mq.internal.MQCommonServices";
    private static final String IBM_MQ_ENVIRONMENT_CLASS = "com.ibm.mq.MQEnvironment";
    private static final String IBM_MQ_JMS_TLS_CLASS = "com.ibm.msg.client.jms.internal.JmsTls";
    private static final String IBM_MQ_TRACE_CLASS = "com.ibm.msg.client.commonservices.trace.Trace";
    private final ClassLoader driverClassLoader;

    @Override
    public void release() {
        if (this.IBM_MQ_RESOURCE_RELEASER_AVOID_CLEANUP) {
            LOGGER.debug("Avoiding IBM MQ resources cleanup.");
            return;
        }
        LOGGER.debug("Releasing IBM MQ resources");
        if (!this.IBM_MQ_RESOURCE_RELEASER_AVOID_CLEANUP_MBEANS) {
            LOGGER.debug("Releasing IBM MQ resources - Removal of registered mBeans is called.");
            this.removeMBeans();
        }
        LOGGER.debug("Releasing IBM MQ resources - Removal of JUL Custom Logging Levels.");
        this.cleanJULKnownLevels();
        LOGGER.debug("Releasing IBM MQ resources - Removes references held by MQCommonServices Class.");
        this.cleanPrivateStaticFieldForClass(IBM_MQ_COMMON_SERVICES_CLASS, "jmqiEnv");
        LOGGER.debug("Releasing IBM MQ resources - Removes the static references held by the MQEnvironment Class.");
        this.cleanPrivateStaticFieldForClass(IBM_MQ_ENVIRONMENT_CLASS, "defaultMQCxManager");
        LOGGER.debug("Releasing IBM MQ resources - Removes the static references held by the JmsTls Class.");
        this.cleanPrivateStaticFieldForClass(IBM_MQ_JMS_TLS_CLASS, "myInstance");
        LOGGER.debug("Releasing IBM MQ resources - Removes the static references held by the TraceController Class.");
        this.cleanPrivateStaticFieldForClass(IBM_MQ_TRACE_CLASS, "traceController");
        LOGGER.debug("Releasing IBM MQ resources - Removes the thread local references to instances of classes loaded by the driver classloader.");
        this.removeThreadLocals();
    }

    public IBMMQResourceReleaser(ClassLoader classLoader) {
        this.driverClassLoader = classLoader;
    }

    public void removeMBeans() {
        LOGGER.debug("Removing registered MBeans of the IBM MQ Driver (if present)");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mBeanServer.queryMBeans(null, null);
        if (LOGGER.isDebugEnabled()) {
            instances.forEach(x -> LOGGER.debug("MBean Found: Class Name: {} // Object Name: {}", (Object)x.getClassName(), (Object)x.getObjectName()));
        }
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", "CommonServices");
        keys.put("name", "*");
        try {
            for (ObjectInstance object : mBeanServer.queryMBeans(new ObjectName(IBM_MQ_MBEAN_DOMAIN, keys), null)) {
                mBeanServer.unregisterMBean(object.getObjectName());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Unregistered {}", (Object)object.getObjectName());
            }
        }
        catch (InstanceNotFoundException ex) {
            LOGGER.debug("No instance of CommonServices/TraceControl MBean was found.");
        }
        catch (MBeanRegistrationException | MalformedObjectNameException e) {
            LOGGER.warn("Caught exception unregistering the IBM MQ TraceControl MBean: {}", (Object)e.getMessage(), (Object)e);
        }
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanJULKnownLevels() {
        Field levelObjectField;
        Class knownLevelClass;
        LOGGER.debug("Cleaning Java Util Logging references");
        try {
            knownLevelClass = ClassUtils.loadClass(JUL_KNOWN_LEVEL_CLASS, this.driverClassLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("The {} class was not found. This may be caused by a JVM or driver upgrade.", (Object)JUL_KNOWN_LEVEL_CLASS);
            return;
        }
        try {
            levelObjectField = ClassUtils.getField(knownLevelClass, "levelObject", false);
            levelObjectField.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            LOGGER.warn("The level field was not found for the {} class. This may be caused by a JVM or driver upgrade ", (Object)JUL_KNOWN_LEVEL_CLASS);
            return;
        }
        Class clazz = knownLevelClass;
        synchronized (clazz) {
            Map nameToLevels = null;
            Map intToLevels = null;
            try {
                nameToLevels = (Map)ClassUtils.getStaticFieldValue(knownLevelClass, "nameToLevels", false);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                LOGGER.warn("Caught exception when accessing the nameToLevels field for {} class: {}", new Object[]{knownLevelClass, ex.getMessage(), ex});
            }
            try {
                intToLevels = (Map)ClassUtils.getStaticFieldValue(knownLevelClass, "intToLevels", false);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                LOGGER.warn("Caught exception when accessing the intToLevels field for {} class: {}", new Object[]{knownLevelClass, ex.getMessage(), ex});
            }
            if (nameToLevels != null) {
                Set removed = this.processJULKnownLevels(levelObjectField, nameToLevels);
                if (intToLevels != null) {
                    for (List knownLevels : intToLevels.values()) {
                        knownLevels.removeAll(removed);
                    }
                }
            } else if (intToLevels != null) {
                this.processJULKnownLevels(levelObjectField, intToLevels);
            }
        }
    }

    private Set processJULKnownLevels(Field levelObjectField, Map<?, List> levelsMaps) {
        HashSet output = new HashSet();
        for (List knownLevels : levelsMaps.values()) {
            ListIterator iter = knownLevels.listIterator();
            while (iter.hasNext()) {
                Object knownLevel = iter.next();
                try {
                    Level levelObject = (Level)levelObjectField.get(knownLevel);
                    if (this.driverClassLoader != levelObject.getClass().getClassLoader()) continue;
                    iter.remove();
                    output.add(knownLevel);
                }
                catch (IllegalAccessException ex) {
                    LOGGER.warn("Caught IllegalAccessException when removing the JUL KnownLevels: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        return output;
    }

    private void cleanPrivateStaticFieldForClass(String className, String fieldName) {
        Class targetClass;
        try {
            targetClass = ClassUtils.loadClass(className, this.driverClassLoader);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn("Could not load the {} class. The provided driver version may have removed it", (Object)className, (Object)ex);
            return;
        }
        try {
            ClassUtils.setStaticFieldValue(targetClass, fieldName, null, true);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.warn("Could not clear the field {} for class {}. The provided river version may have removed it.", new Object[]{fieldName, className, ex});
        }
    }

    public void removeThreadLocals() {
        LOGGER.debug("Removing ThreadLocals");
        Field threadLocalsField = null;
        Field inheritableThreadLocalsField = null;
        Field threadLocalMapTableField = null;
        try {
            threadLocalsField = ClassUtils.getField(Thread.class, THREADLOCALS_FIELD, false);
        }
        catch (NoSuchFieldException ex) {
            LOGGER.warn("Could not get the {} field for Thread.class. This may be related to a change in the JVM.", (Object)THREADLOCALS_FIELD, (Object)ex);
        }
        try {
            inheritableThreadLocalsField = ClassUtils.getField(Thread.class, INHERITABLE_THREADLOCALS_FIELD, false);
        }
        catch (NoSuchFieldException ex) {
            LOGGER.warn("Could not get the {} field for Thread.class. This may be related to a change in the JVM", (Object)INHERITABLE_THREADLOCALS_FIELD, (Object)ex);
        }
        if (threadLocalsField != null) {
            threadLocalsField.setAccessible(true);
        }
        if (inheritableThreadLocalsField != null) {
            inheritableThreadLocalsField.setAccessible(true);
        }
        try {
            Class threadLocalMapTableClass = ClassUtils.loadClass(THREADLOCAL_MAP_TABLE_CLASS, this.driverClassLoader);
            threadLocalMapTableField = ClassUtils.getField(threadLocalMapTableClass, "table", false);
            threadLocalMapTableField.setAccessible(true);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn("Could not find the {} class. This may be related to a change in the JVM", (Object)THREADLOCAL_MAP_TABLE_CLASS, (Object)ex);
            return;
        }
        catch (NoSuchFieldException ex) {
            LOGGER.warn("Could not find the table field for {} class. This may be related to a change in the JVM", (Object)THREADLOCAL_MAP_TABLE_CLASS, (Object)ex);
            return;
        }
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (LOGGER.isDebugEnabled() && thread.getThreadGroup() != null) {
                LOGGER.debug("Processing Thread: {} / {}", (Object)thread.getThreadGroup().getName(), (Object)thread.getName());
            }
            if (threadLocalsField != null) {
                try {
                    this.processThreadLocalMap(threadLocalMapTableField, threadLocalsField.get(thread));
                }
                catch (IllegalAccessException ex) {
                    LOGGER.warn("Caught exception getting ThreadLocals Field of {} thread: {}", new Object[]{thread.getName(), ex.getMessage(), ex});
                }
            }
            if (inheritableThreadLocalsField == null) continue;
            try {
                this.processThreadLocalMap(threadLocalMapTableField, inheritableThreadLocalsField.get(thread));
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn("Caught exception getting InheritableThreadLocals Field of {} thread: {}", new Object[]{thread.getName(), ex.getMessage(), ex});
            }
        }
    }

    private void processThreadLocalMap(Field threadLocalMapTableField, Object threadLocalMap) {
        if (threadLocalMap == null) {
            return;
        }
        Object[] threadLocalMapTable = new Object[]{};
        try {
            threadLocalMapTable = (Object[])threadLocalMapTableField.get(threadLocalMap);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Could not get threadLocalMapTablefield: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        for (Object entry : threadLocalMapTable) {
            Object x;
            Reference reference;
            ThreadLocal threadLocal;
            if (entry == null || (threadLocal = (ThreadLocal)(reference = (Reference)entry).get()) == null || (x = threadLocal.get()) == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ThreadLocal ClassLoader: {}", (Object)x.getClass().getClassLoader());
                LOGGER.debug("ThreadLocal Class: {}", (Object)x.getClass().getCanonicalName());
            }
            if (this.driverClassLoader != x.getClass().getClassLoader()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removing instance of {}", (Object)x.getClass().getCanonicalName());
            }
            threadLocal.remove();
            threadLocal.set(null);
            reference.clear();
            try {
                Field threadLocalMapEntryValueField = ClassUtils.getField(entry.getClass(), "value", false);
                threadLocalMapEntryValueField.setAccessible(true);
                threadLocalMapEntryValueField.set(entry, null);
                ((Reference)entry).clear();
            }
            catch (NoSuchFieldException ex) {
                LOGGER.warn("Could not get field value for class {}: {}", new Object[]{entry.getClass(), ex.getMessage(), ex});
            }
            catch (IllegalAccessException ex) {
                LOGGER.warn("Could not clear the thread local's entry map reference for class{}: {}", new Object[]{entry.getClass(), ex.getMessage(), ex});
            }
        }
    }
}

