/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.BaseComponentParameterAstDecorator;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public final class MuleArtifactAstCopyUtils {
    private MuleArtifactAstCopyUtils() {
    }

    public static ArtifactAst copyRecursively(ArtifactAst source, UnaryOperator<ComponentAst> componentMapper) {
        return MuleArtifactAstCopyUtils.copyRecursively(source, componentMapper, Collections::emptyList, c -> false);
    }

    public static ArtifactAst copyRecursively(final ArtifactAst source, UnaryOperator<ComponentAst> componentMapper, Supplier<List<ComponentAst>> topLeveltoAdd, Predicate<ComponentAst> topLevelToRemove) {
        List mappedTopLevelTemp = source.topLevelComponentsStream().map(c -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively(c, componentMapper)).collect(Collectors.toList());
        mappedTopLevelTemp.addAll((Collection)topLeveltoAdd.get());
        mappedTopLevelTemp.removeIf(topLevelToRemove);
        final List mappedTopLevel = Collections.unmodifiableList(mappedTopLevelTemp);
        return new BaseArtifactAst(){

            @Override
            public Set<ExtensionModel> dependencies() {
                return source.dependencies();
            }

            @Override
            public Optional<ArtifactAst> getParent() {
                return source.getParent();
            }

            @Override
            public List<ComponentAst> topLevelComponents() {
                return mappedTopLevel;
            }

            @Override
            public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
                source.updatePropertiesResolver(newPropertiesResolver);
            }

            @Override
            public ErrorTypeRepository getErrorTypeRepository() {
                return source.getErrorTypeRepository();
            }

            @Override
            public Collection<ImportedResource> getImportedResources() {
                return source.getImportedResources();
            }
        };
    }

    public static ComponentAst copyComponentTreeRecursively(ComponentAst source, UnaryOperator<ComponentAst> componentMapper) {
        final AtomicBoolean anyChildMapped = new AtomicBoolean(false);
        final AtomicBoolean anyParamMapped = new AtomicBoolean(false);
        final List mappedDirectChildren = Collections.unmodifiableList(source.directChildrenStream().map(child -> {
            ComponentAst mappedChild = MuleArtifactAstCopyUtils.copyComponentTreeRecursively(child, componentMapper);
            if (mappedChild != child) {
                anyChildMapped.set(true);
            }
            return mappedChild;
        }).collect(Collectors.toList()));
        final List mappedParameters = Collections.unmodifiableList(source.getModel(ParameterizedModel.class).map(pmzd -> source.getParameters().stream().map(param -> {
            final AtomicReference mappedValue = new AtomicReference();
            if (param.getModel().getName().equals("errorMappings")) {
                return param;
            }
            param.getModel().getType().accept(new MetadataTypeVisitor((ComponentParameterAst)param, mappedValue, componentMapper){
                final /* synthetic */ ComponentParameterAst val$param;
                final /* synthetic */ AtomicReference val$mappedValue;
                final /* synthetic */ UnaryOperator val$componentMapper;
                {
                    this.val$param = componentParameterAst;
                    this.val$mappedValue = atomicReference;
                    this.val$componentMapper = unaryOperator;
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    Object value = this.val$param.getValue().getRight();
                    if (value != null && value instanceof Collection) {
                        this.val$mappedValue.set(((Collection)value).stream().map(this::doMap).collect(Collectors.toList()));
                    }
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    Object value = this.val$param.getValue().getRight();
                    if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                        if (value != null && value instanceof Collection) {
                            this.val$mappedValue.set(((Collection)value).stream().map(this::doMap).collect(Collectors.toList()));
                        }
                    } else if (value instanceof ComponentAst) {
                        this.val$mappedValue.set(this.doMap((ComponentAst)value));
                    }
                }

                private ComponentAst doMap(ComponentAst component) {
                    return MuleArtifactAstCopyUtils.copyComponentTreeRecursively(component, this.val$componentMapper);
                }
            });
            if (mappedValue.get() == null) {
                return param;
            }
            anyParamMapped.set(true);
            return new BaseComponentParameterAstDecorator((ComponentParameterAst)param){

                @Override
                public <T> Either<String, T> getValue() {
                    return Either.right(String.class, mappedValue.get());
                }
            };
        }).collect(Collectors.toList())).orElse(Collections.emptyList()));
        if (anyChildMapped.get() || anyParamMapped.get()) {
            return (ComponentAst)componentMapper.apply(new BaseComponentAstDecorator(source){

                @Override
                public List<ComponentAst> directChildren() {
                    return anyChildMapped.get() ? mappedDirectChildren : super.directChildren();
                }

                @Override
                public Stream<ComponentAst> directChildrenStream() {
                    return anyChildMapped.get() ? mappedDirectChildren.stream() : super.directChildrenStream();
                }

                @Override
                public Collection<ComponentParameterAst> getParameters() {
                    return anyParamMapped.get() ? mappedParameters : super.getParameters();
                }

                @Override
                public ComponentParameterAst getParameter(String groupName, String paramName) {
                    return anyParamMapped.get() ? (ComponentParameterAst)mappedParameters.stream().filter(p -> p.getModel().getName().equals(paramName) && p.getGroupModel().getName().equals(groupName)).findAny().orElse(null) : super.getParameter(groupName, paramName);
                }
            });
        }
        return (ComponentAst)componentMapper.apply(source);
    }
}

