/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;

public class LazyMetadataService
implements MetadataService,
Initialisable {
    private final LazyMuleArtifactContext lazyMuleArtifactContext;
    private final Supplier<MetadataService> metadataServiceSupplier;
    private MetadataService metadataService;

    public LazyMetadataService(LazyMuleArtifactContext lazyMuleArtifactContext, Supplier<MetadataService> metadataServiceSupplier) {
        this.lazyMuleArtifactContext = lazyMuleArtifactContext;
        this.metadataServiceSupplier = metadataServiceSupplier;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getMetadataKeys(location));
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location, MetadataKey partialKey) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getMetadataKeys(location, partialKey));
    }

    @Override
    public MetadataResult<InputMetadataDescriptor> getInputMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getInputMetadata(location, key));
    }

    @Override
    public MetadataResult<OutputMetadataDescriptor> getOutputMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOutputMetadata(location, key));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location, key));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location, key));
    }

    @Override
    public void disposeCache(String id) {
        this.metadataService.disposeCache(id);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getEntityKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityKeys(location));
    }

    @Override
    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityMetadata(location, key));
    }

    private Optional<MetadataResult<?>> initializeComponent(Location location) {
        try {
            this.lazyMuleArtifactContext.initializeComponent(location, false);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionHelper.getRootException(e);
            MetadataFailure.Builder builder = MetadataFailure.Builder.newFailure(e).withMessage(rootCause.getMessage());
            if (rootCause instanceof NoSuchComponentModelException) {
                builder.withFailureCode(FailureCode.COMPONENT_NOT_FOUND);
            }
            return Optional.of(MetadataResult.failure(builder.onComponent()));
        }
        return Optional.empty();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.metadataService = this.metadataServiceSupplier.get();
    }
}

