/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.ImmutableObjectProviderConfiguration;
import org.mule.runtime.config.internal.MuleArtifactObjectProvider;
import org.mule.runtime.config.internal.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.MuleContextPostProcessor;
import org.mule.runtime.config.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.model.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.model.properties.PropertiesResolverUtils;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.internal.processor.ComponentLocatorCreatePostProcessor;
import org.mule.runtime.config.internal.processor.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.internal.processor.LifecycleStatePostProcessor;
import org.mule.runtime.config.internal.processor.MuleInjectorProcessor;
import org.mule.runtime.config.internal.processor.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.internal.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class MuleArtifactContext
extends AbstractRefreshableConfigApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleArtifactContext.class);
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    private final OptionalObjectsController optionalObjectsController;
    private final DefaultRegistry serviceDiscoverer;
    private final DefaultResourceLocator resourceLocator;
    private final PropertiesResolverConfigurationProperties configurationProperties;
    private ArtifactAst applicationModel;
    private final MuleContextWithRegistry muleContext;
    private final BeanDefinitionFactory beanDefinitionFactory;
    private final ArtifactType artifactType;
    protected SpringConfigurationComponentLocator componentLocator = new SpringConfigurationComponentLocator(componentName -> {
        try {
            BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition(componentName);
            return beanDefinition.isPrototype();
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    });
    protected List<ConfigurableObjectProvider> objectProviders = new ArrayList<ConfigurableObjectProvider>();
    private Registry originalRegistry;
    private final ExtensionManager extensionManager;
    private final FeatureFlaggingService featureFlaggingService;

    public MuleArtifactContext(MuleContext muleContext, ArtifactAst artifactAst, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory, FeatureFlaggingService featureFlaggingService) {
        Preconditions.checkArgument(optionalObjectsController != null, "optionalObjectsController cannot be null");
        this.muleContext = (MuleContextWithRegistry)muleContext;
        this.featureFlaggingService = featureFlaggingService;
        this.optionalObjectsController = optionalObjectsController;
        this.artifactType = artifactType;
        this.serviceDiscoverer = new DefaultRegistry(muleContext);
        this.resourceLocator = new DefaultResourceLocator();
        this.originalRegistry = ((MuleRegistryHelper)this.getMuleRegistry()).getDelegate();
        this.extensionManager = muleContext.getExtensionManager();
        this.beanDefinitionFactory = new BeanDefinitionFactory(muleContext.getConfiguration().getId(), componentBuildingDefinitionRegistryFactory.create(this.getExtensions()), featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_BYTE_BUDDY_OBJECT_CREATION));
        this.applicationModel = artifactAst;
        this.configurationProperties = PropertiesResolverUtils.createConfigurationAttributeResolver(this.applicationModel, parentConfigurationProperties, artifactProperties, new ClassLoaderResourceProvider(muleContext.getExecutionClassLoader()), Optional.ofNullable(this.getMuleRegistry().lookupObject("core.featureFlaggingService")));
        try {
            LifecycleUtils.initialiseIfNeeded(this.configurationProperties.getConfigurationPropertiesResolver());
            this.applicationModel.updatePropertiesResolver(this.configurationProperties.getConfigurationPropertiesResolver());
            this.validateArtifact(this.applicationModel);
        }
        catch (InitialisationException | ConfigurationException e) {
            throw new MuleRuntimeException(e);
        }
        this.registerErrors(this.applicationModel);
    }

    protected MuleRegistry getMuleRegistry() {
        return this.muleContext.getRegistry();
    }

    protected void validateArtifact(ArtifactAst artifactAst) throws ConfigurationException {
        this.doValidateModel(artifactAst, v -> true);
    }

    protected final void doValidateModel(ArtifactAst appModel, Predicate<Validation> validationsFilter) throws ConfigurationException {
        ValidationResult validation = MuleAstUtils.validate(appModel, validationsFilter);
        Collection<ValidationResultItem> items = validation.getItems();
        items.stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.WARN)).forEach(v -> LOGGER.warn(this.componentsLocation((ValidationResultItem)v)));
        List errors = items.stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage(validation.getItems().stream().map(this::componentsLocation).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    private String componentsLocation(ValidationResultItem v) {
        return v.getComponents().stream().map(component -> component.getMetadata().getFileName().orElse("unknown") + ":" + component.getMetadata().getStartLine().orElse(-1)).collect(Collectors.joining("; ", "[", "]")) + ": " + v.getMessage();
    }

    protected void registerErrors(ArtifactAst artifactAst) {
        this.doRegisterErrors(artifactAst);
    }

    protected void doRegisterErrors(ArtifactAst artifactAst) {
        ErrorTypeRepository errorTypeRepository = artifactAst.getErrorTypeRepository();
        ErrorTypeLocator errorTypeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(errorTypeRepository);
        Set<ExtensionModel> dependencies = artifactAst.dependencies();
        ExtensionErrorsRegistrant.registerErrorMappings(errorTypeRepository, errorTypeLocator, dependencies);
        ((ContributedErrorTypeRepository)this.muleContext.getErrorTypeRepository()).setDelegate(errorTypeRepository);
        ((ContributedErrorTypeLocator)((PrivilegedMuleContext)((Object)this.muleContext)).getErrorTypeLocator()).setDelegate(errorTypeLocator);
    }

    public void initialize() {
        this.applicationModel = ApplicationModel.prepareAstForRuntime(this.applicationModel, this.getExtensions());
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.setBeanExpressionResolver(null);
        this.registerEditors(beanFactory);
        this.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory, beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor(this.muleContext), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState()), new ComponentLocatorCreatePostProcessor(this.componentLocator)});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
        this.prepareObjectProviders();
    }

    protected void prepareObjectProviders() {
        MuleArtifactObjectProvider muleArtifactObjectProvider = new MuleArtifactObjectProvider(this);
        ImmutableObjectProviderConfiguration providerConfiguration = new ImmutableObjectProviderConfiguration(this.configurationProperties, muleArtifactObjectProvider);
        for (ConfigurableObjectProvider objectProvider : this.objectProviders) {
            objectProvider.configure(providerConfiguration);
        }
    }

    protected void registerObjectFromObjectProviders(ConfigurableListableBeanFactory beanFactory) {
        ((ObjectProviderAwareBeanFactory)beanFactory).setObjectProviders(this.objectProviders);
    }

    private List<Pair<ComponentAst, Optional<String>>> lookObjectProvidersComponentModels(ArtifactAst applicationModel, Map<ComponentAst, SpringComponentModel> springComponentModels) {
        return applicationModel.topLevelComponentsStream().filter(componentModel -> {
            SpringComponentModel springModel = (SpringComponentModel)springComponentModels.get(componentModel);
            return springModel != null && springModel.getType() != null && ConfigurableObjectProvider.class.isAssignableFrom(springModel.getType());
        }).map(componentModel -> new Pair<ComponentAst, Optional<String>>((ComponentAst)componentModel, componentModel.getComponentId())).collect(Collectors.toList());
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    protected void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    public void close() {
        if (this.isRunning()) {
            super.close();
            LifecycleUtils.disposeIfNeeded(this.configurationProperties.getConfigurationPropertiesResolver(), LOGGER);
        }
    }

    public static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray(resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.createApplicationComponents(beanFactory, this.applicationModel, true);
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Exception e) {
            for (ObjectProvider objectProvider : this.objectProviders) {
                LifecycleUtils.disposeIfNeeded(objectProvider, LOGGER);
            }
            throw new MuleRuntimeException(e);
        }
    }

    protected List<Pair<String, ComponentAst>> createApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst applicationModel, boolean mustBeRoot) {
        LinkedHashMap<ComponentAst, SpringComponentModel> springComponentModels = new LinkedHashMap<ComponentAst, SpringComponentModel>();
        return this.doCreateApplicationComponents(beanFactory, applicationModel, mustBeRoot, springComponentModels);
    }

    protected List<Pair<String, ComponentAst>> doCreateApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst applicationModel, boolean mustBeRoot, Map<ComponentAst, SpringComponentModel> springComponentModels) {
        HashSet alwaysEnabledTopLevelComponents = new HashSet();
        Set alwaysEnabledUnnamedTopLevelComponents = applicationModel.topLevelComponentsStream().filter(cm -> cm.getModel(HasStereotypeModel.class).map(stm -> stm.getStereotype().isAssignableTo(MuleStereotypes.APP_CONFIG)).orElse(false)).peek(cm -> cm.getComponentId().ifPresent(alwaysEnabledTopLevelComponents::add)).filter(cm -> !cm.getComponentId().isPresent()).map(ComponentAst::getIdentifier).collect(Collectors.toSet());
        HashSet alwaysEnabledGeneratedTopLevelComponentsName = new HashSet();
        ArrayList<Pair<String, ComponentAst>> createdComponentModels = new ArrayList<Pair<String, ComponentAst>>();
        Set<ComponentAst> rootComponents = this.resolveRootComponents(applicationModel);
        MuleAstUtils.recursiveStreamWithHierarchy(applicationModel, AstTraversalDirection.BOTTOM_UP, true).filter(cm -> {
            if (!mustBeRoot) return true;
            if (rootComponents.contains(cm.getFirst())) return true;
            if (!((List)cm.getSecond()).stream().anyMatch(rootComponents::contains)) return false;
            return true;
        }).filter(cm -> !this.isIgnored((ComponentAst)cm.getFirst())).forEach(cm -> {
            if (rootComponents.contains(cm.getFirst())) {
                ((ComponentAst)cm.getFirst()).getComponentId().ifPresent(componentName -> createdComponentModels.add(new Pair((String)componentName, cm.getFirst())));
            }
            this.beanDefinitionFactory.resolveComponent(springComponentModels, (List)cm.getSecond(), (ComponentAst)cm.getFirst(), (BeanDefinitionRegistry)beanFactory, this.componentLocator);
            if (rootComponents.contains(cm.getFirst())) {
                this.componentLocator.addComponentLocation(((ComponentAst)cm.getFirst()).getLocation());
            }
        });
        springComponentModels.values().stream().filter(resolvedComponentModel -> rootComponents.contains(resolvedComponentModel.getComponent())).forEach(resolvedComponentModel -> this.registerRootSpringBean(beanFactory, alwaysEnabledUnnamedTopLevelComponents, alwaysEnabledGeneratedTopLevelComponentsName, (List<Pair<String, ComponentAst>>)createdComponentModels, (SpringComponentModel)resolvedComponentModel));
        List<Pair<ComponentAst, Optional<String>>> objectProvidersByName = this.lookObjectProvidersComponentModels(applicationModel, springComponentModels);
        objectProvidersByName.stream().map(pair -> ((SpringComponentModel)springComponentModels.get(pair.getFirst())).getObjectInstance()).forEach(this.objectProviders::add);
        this.registerObjectFromObjectProviders((ConfigurableListableBeanFactory)beanFactory);
        Set objectProviderNames = objectProvidersByName.stream().map(Pair::getSecond).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        createdComponentModels.sort(Comparator.comparing(beanNameAndComponent -> {
            String beanName = (String)beanNameAndComponent.getFirst();
            if (objectProviderNames.contains(beanName)) {
                return 1;
            }
            if (alwaysEnabledGeneratedTopLevelComponentsName.contains(beanName)) {
                return 2;
            }
            if (alwaysEnabledTopLevelComponents.contains(beanName)) {
                return 3;
            }
            return 4;
        }));
        return createdComponentModels;
    }

    protected boolean isIgnored(ComponentAst componentAst) {
        return this.beanDefinitionFactory.isComponentIgnored(componentAst.getIdentifier());
    }

    private Set<ComponentAst> resolveRootComponents(ArtifactAst applicationModel) {
        Set xmlSdk1ConfigModels = Collections.newSetFromMap(new IdentityHashMap());
        this.extensionManager.getExtensions().stream().flatMap(extension -> extension.getModelProperty(XmlExtensionModelProperty.class).map(mp -> extension.getConfigurationModels().stream()).orElse(Stream.empty())).forEach(xmlSdk1ConfigModels::add);
        return Stream.concat(applicationModel.topLevelComponentsStream(), applicationModel.topLevelComponentsStream().flatMap(root -> root.recursiveStream().filter(comp -> comp.getModel(ConfigurationModel.class).map(xmlSdk1ConfigModels::contains).orElse(comp.getIdentifier().getName().equals("_defaultGlobalElements"))).flatMap(ComponentAst::directChildrenStream))).filter(comp -> !comp.getIdentifier().getName().equals("_defaultGlobalElements")).collect(Collectors.toSet());
    }

    private void registerRootSpringBean(DefaultListableBeanFactory beanFactory, Set<ComponentIdentifier> alwaysEnabledUnnamedTopLevelComponents, Set<String> alwaysEnabledGeneratedTopLevelComponentsName, List<Pair<String, ComponentAst>> createdComponentModels, SpringComponentModel resolvedComponentModel) {
        String nameAttribute = resolvedComponentModel.getComponent().getComponentId().orElse(null);
        if (resolvedComponentModel.getComponent().getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
            nameAttribute = "_muleConfiguration";
        } else if (nameAttribute == null) {
            nameAttribute = AutoIdUtils.uniqueValue(resolvedComponentModel.getBeanDefinition().getBeanClassName());
            if (alwaysEnabledUnnamedTopLevelComponents.contains(resolvedComponentModel.getComponent().getIdentifier())) {
                alwaysEnabledGeneratedTopLevelComponentsName.add(nameAttribute);
                createdComponentModels.add(new Pair<String, ComponentAst>(nameAttribute, resolvedComponentModel.getComponent()));
            } else if (resolvedComponentModel.getType() != null && TransactionManagerFactory.class.isAssignableFrom(resolvedComponentModel.getType())) {
                createdComponentModels.add(new Pair<String, ComponentAst>(nameAttribute, resolvedComponentModel.getComponent()));
            }
        }
        beanFactory.registerBeanDefinition(nameAttribute, Objects.requireNonNull(resolvedComponentModel.getBeanDefinition(), "BeanDefinition null for " + resolvedComponentModel.getComponent().toString()));
        MuleArtifactContext.postProcessBeanDefinition(resolvedComponentModel, (BeanDefinitionRegistry)beanFactory, nameAttribute);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new SpringMuleContextServiceConfigurator(this.muleContext, this.configurationProperties, this.artifactType, this.optionalObjectsController, (BeanDefinitionRegistry)beanFactory, this.componentLocator, this.serviceDiscoverer, this.originalRegistry, this.resourceLocator).createArtifactServices();
        this.originalRegistry = null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Optional<ComponentAst> configurationOptional = ApplicationModel.findComponentDefinitionModel(this.applicationModel, CoreDslConstants.CONFIGURATION_IDENTIFIER);
        if (configurationOptional.isPresent()) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, null);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, null);
        this.registerInjectorProcessor(beanFactory);
    }

    protected void registerInjectorProcessor(ConfigurableListableBeanFactory beanFactory) {
        MuleInjectorProcessor muleInjectorProcessor = null;
        if (this.artifactType.equals((Object)ArtifactType.APP) || this.artifactType.equals((Object)ArtifactType.POLICY) || this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            muleInjectorProcessor = new MuleInjectorProcessor();
        }
        if (muleInjectorProcessor != null) {
            muleInjectorProcessor.setBeanFactory((BeanFactory)beanFactory);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)muleInjectorProcessor);
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(SpringComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", (BeanDefinition)converterBeanDefinitionCopy);
        }
    }

    public MuleContextWithRegistry getMuleContext() {
        return this.muleContext;
    }

    public OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public org.mule.runtime.api.artifact.Registry getRegistry() {
        return (org.mule.runtime.api.artifact.Registry)this.getMuleContext().getRegistry().get("_muleRegistry");
    }

    public String toString() {
        return String.format("%s: %s (%s)", ((Object)((Object)this)).getClass().getName(), this.muleContext.getConfiguration().getId(), this.artifactType.name());
    }

    private Set<ExtensionModel> getExtensions() {
        return this.extensionManager == null ? Collections.emptySet() : this.extensionManager.getExtensions();
    }

    public ArtifactAst getApplicationModel() {
        return this.applicationModel;
    }
}

