/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.profiling.context.DefaultTransactionProfilingEventContext;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;

public final class TransactionUtils {
    private TransactionUtils() {
    }

    public static void profileTransactionAction(ProfilingDataProducer<TransactionProfilingEventContext, Object> dataProducer, ProfilingEventType<TransactionProfilingEventContext> type, ComponentLocation location) {
        if (!TransactionCoordination.isTransactionActive() && !type.equals(RuntimeProfilingEventTypes.TX_START)) {
            return;
        }
        TransactionAdapter tx = (TransactionAdapter)TransactionCoordination.getInstance().getTransaction();
        TransactionType txType = tx.isXA() ? TransactionType.XA : TransactionType.LOCAL;
        dataProducer.triggerProfilingEvent(new DefaultTransactionProfilingEventContext(tx.getComponentLocation(), location, txType, System.currentTimeMillis()));
    }
}

