/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.management.stats.ComponentStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.ResetOnQueryCounter;
import org.mule.runtime.core.internal.management.stats.DefaultResetOnQueryCounter;

public class DefaultFlowConstructStatistics
implements FlowConstructStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    protected final String flowConstructType;
    protected String name;
    protected boolean enabled = false;
    private long samplePeriod = 0L;
    protected final AtomicLong receivedEvents = new AtomicLong(0L);
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    protected final ComponentStatistics flowStatistics = new ComponentStatistics();
    private final transient AtomicLong connectionErrors = new AtomicLong(0L);
    private final transient List<DefaultResetOnQueryCounter> eventsReceivedCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> executionErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> connectionErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> fatalErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();

    public DefaultFlowConstructStatistics(String flowConstructType, String name) {
        this.name = name;
        this.flowConstructType = flowConstructType;
        this.flowStatistics.setEnabled(this.enabled);
        if (this.getClass() == DefaultFlowConstructStatistics.class) {
            this.clear();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void incExecutionError() {
        this.executionError.addAndGet(1L);
        this.executionErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
    }

    @Override
    public void incFatalError() {
        this.fatalError.addAndGet(1L);
        this.fatalErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
        this.flowStatistics.setEnabled(this.enabled);
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void clear() {
        this.receivedEvents.set(0L);
        this.samplePeriod = System.currentTimeMillis();
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.flowStatistics != null) {
            this.flowStatistics.clear();
        }
    }

    @Override
    public void addCompleteFlowExecutionTime(long time) {
        this.flowStatistics.addCompleteExecutionTime(time);
    }

    @Override
    public void addFlowExecutionBranchTime(long time, long total) {
        this.flowStatistics.addExecutionBranchTime(time == total, time, total);
    }

    @Override
    public long getAverageProcessingTime() {
        return this.flowStatistics.getAverageExecutionTime();
    }

    @Override
    public long getProcessedEvents() {
        return this.flowStatistics.getExecutedEvents();
    }

    @Override
    public long getMaxProcessingTime() {
        return this.flowStatistics.getMaxExecutionTime();
    }

    @Override
    public long getMinProcessingTime() {
        return this.flowStatistics.getMinExecutionTime();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.flowStatistics.getTotalExecutionTime();
    }

    @Override
    public long getExecutionErrors() {
        return this.executionError.get();
    }

    @Override
    public long getFatalErrors() {
        return this.fatalError.get();
    }

    @Override
    public long getConnectionErrors() {
        return this.connectionErrors.get();
    }

    @Override
    public void incReceivedEvents() {
        this.receivedEvents.addAndGet(1L);
        this.eventsReceivedCounters.forEach(DefaultResetOnQueryCounter::increment);
    }

    @Override
    public void incConnectionErrors() {
        this.connectionErrors.addAndGet(1L);
        this.connectionErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
    }

    @Override
    public long getTotalEventsReceived() {
        return this.receivedEvents.get();
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }

    @Override
    public ResetOnQueryCounter getEventsReceivedCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.eventsReceivedCounters.add(counter);
        counter.add(this.getTotalEventsReceived());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getExecutionErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.executionErrorsCounters.add(counter);
        counter.add(this.getExecutionErrors());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getConnectionErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.connectionErrorsCounters.add(counter);
        counter.add(this.getConnectionErrors());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getFatalErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.fatalErrorsCounters.add(counter);
        counter.add(this.getFatalErrors());
        return counter;
    }
}

