/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.internal.loader.XmlExtensionLoaderDelegate;
import org.vibur.objectpool.PoolObjectFactory;

public class ForTnsTransformerFactory
implements PoolObjectFactory<Transformer> {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final String TRANSFORMATION_FOR_TNS_RESOURCE = "META-INF/transform_for_tns.xsl";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transformer create() {
        try (BufferedInputStream in = new BufferedInputStream(XmlExtensionLoaderDelegate.class.getClassLoader().getResourceAsStream(TRANSFORMATION_FOR_TNS_RESOURCE));){
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(in));
            return transformer;
        }
        catch (IOException | TransformerException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an issue creating the transformer to remove the content of the <body> element to generate an XSD", new Object[0])), (Throwable)e);
        }
    }

    public boolean readyToTake(Transformer obj) {
        return true;
    }

    public boolean readyToRestore(Transformer obj) {
        return true;
    }

    public void destroy(Transformer obj) {
        obj.reset();
    }
}

