/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.api.notification.PolicyNotificationListener;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.CompositeArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.config.FeatureFlaggingUtils;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyInstance;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.proxy.LifecycleFilterProxy;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.policy.api.PolicyPointcut;

public class DefaultApplicationPolicyInstance
implements ApplicationPolicyInstance {
    public static final String CLUSTER_MANAGER_ID = "_muleClusterManager";
    private final Application application;
    private final PolicyTemplate template;
    private final PolicyParametrization parametrization;
    private final ServiceRepository serviceRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final MuleContextListener muleContextListener;
    private ArtifactContext policyContext;
    private LazyValue<PolicyInstance> policyInstance;

    public DefaultApplicationPolicyInstance(Application application, PolicyTemplate template, PolicyParametrization parametrization, ServiceRepository serviceRepository, ClassLoaderRepository classLoaderRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, MuleContextListener muleContextListener) {
        this.application = application;
        this.template = template;
        this.parametrization = parametrization;
        this.serviceRepository = serviceRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.muleContextListener = muleContextListener;
    }

    private void initPolicyContext() throws InitialisationException {
        ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactType(ArtifactType.POLICY).setArtifactProperties(SmallMap.copy(this.parametrization.getParameters())).setArtifactName(this.parametrization.getId()).setConfigurationFiles(this.parametrization.getConfig().getAbsolutePath()).setExecutionClassloader(this.template.getArtifactClassLoader().getClassLoader()).setServiceRepository(this.serviceRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactPlugins(this.getFeatureFlaggedArtifactPlugins((ArtifactDescriptor)this.template.getDescriptor())).setParentArtifact(this.application).setExtensionManagerFactory(this.getFeatureFlaggedExtensionManagerFactory()).setMuleContextListener(this.muleContextListener);
        artifactBuilder.withServiceConfigurator(customizationService -> {
            Registry applicationRegistry = this.application.getArtifactContext().getRegistry();
            this.addPolicyCustomizationOverride("_muleLockProvider", customizationService, applicationRegistry);
            this.addPolicyCustomizationOverride("_defaultPersistentObjectStore", customizationService, applicationRegistry);
            this.addPolicyCustomizationOverride("_defaultInMemoryObjectStore", customizationService, applicationRegistry);
            this.addPolicyCustomizationOverride("_muleTimeSupplier", customizationService, applicationRegistry);
            this.addPolicyCustomizationOverride(CLUSTER_MANAGER_ID, customizationService, applicationRegistry);
        });
        try {
            this.policyContext = artifactBuilder.build();
            this.enableNotificationListeners(this.parametrization.getNotificationListeners());
            this.policyContext.getMuleContext().start();
        }
        catch (MuleException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Cannot create artifact context for the policy instance"), (Throwable)e, this);
        }
    }

    private List<ArtifactPlugin> getFeatureFlaggedArtifactPlugins(ArtifactDescriptor policyArtifactDescriptor) {
        if (FeatureFlaggingUtils.isFeatureEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION, policyArtifactDescriptor)) {
            return this.template.getOwnArtifactPlugins();
        }
        return this.template.getArtifactPlugins();
    }

    private ExtensionManagerFactory getFeatureFlaggedExtensionManagerFactory() {
        return muleContext -> {
            try {
                FeatureFlaggingService featureFlaggingService = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(FeatureFlaggingService.class);
                if (featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
                    ArtifactExtensionManagerFactory artifactExtensionManagerFactory = new ArtifactExtensionManagerFactory(this.template.getOwnArtifactPlugins(), this.extensionModelLoaderRepository, new DefaultExtensionManagerFactory());
                    return artifactExtensionManagerFactory.create(muleContext, this.getInheritedExtensionModels());
                }
                return new CompositeArtifactExtensionManagerFactory(this.application, this.extensionModelLoaderRepository, this.template.getOwnArtifactPlugins(), new DefaultExtensionManagerFactory()).create(muleContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        };
    }

    private Set<ExtensionModel> getInheritedExtensionModels() {
        HashSet<ExtensionModel> inheritedExtensionModels = new HashSet<ExtensionModel>(2);
        ExtensionManager extensionManager = (ExtensionManager)this.application.getRegistry().lookupByName("_muleExtensionManager").get();
        extensionManager.getExtension("HTTP").ifPresent(inheritedExtensionModels::add);
        extensionManager.getExtension("Sockets").ifPresent(inheritedExtensionModels::add);
        return inheritedExtensionModels;
    }

    private void addPolicyCustomizationOverride(String objectKey, CustomizationService customizationService, Registry applicationRegistry) {
        applicationRegistry.lookupByName(objectKey).map(LifecycleFilterProxy::createLifecycleFilterProxy).ifPresent(s -> customizationService.overrideDefaultServiceImpl(objectKey, s));
    }

    private void enableNotificationListeners(List<NotificationListener> notificationListeners) {
        NotificationListenerRegistry listenerRegistry = this.policyContext.getRegistry().lookupByType(NotificationListenerRegistry.class).get();
        this.policyContext.getMuleContext().getNotificationManager().addInterfaceToType(PolicyNotificationListener.class, PolicyNotification.class);
        notificationListeners.forEach(listenerRegistry::registerListener);
    }

    private PolicyInstance initPolicyInstance() {
        return this.policyContext.getRegistry().lookupByType(PolicyInstance.class).get();
    }

    @Override
    public PolicyPointcut getPointcut() {
        return this.parametrization.getPolicyPointcut();
    }

    @Override
    public int getOrder() {
        return this.parametrization.getOrder();
    }

    @Override
    public PolicyTemplate getPolicyTemplate() {
        return this.template;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.policyInstance == null && this.policyContext == null) {
            this.initPolicyContext();
        }
        this.policyInstance = new LazyValue<Supplier<PolicyInstance>>(this::initPolicyInstance);
    }

    @Override
    public void dispose() {
        if (this.policyContext != null) {
            this.policyContext.getMuleContext().dispose();
        }
    }

    @Override
    public Optional<Policy> getSourcePolicy() {
        return this.policyInstance.get().getSourcePolicyChain().map(chain -> new Policy((PolicyChain)chain, this.parametrization.getId()));
    }

    @Override
    public Optional<Policy> getOperationPolicy() {
        return this.policyInstance.get().getOperationPolicyChain().map(chain -> new Policy((PolicyChain)chain, this.parametrization.getId()));
    }
}

