/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructInvalidException;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.construct.FlowConstructLifecycleManager;
import org.mule.runtime.core.internal.context.FlowStoppedPersistenceListener;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.lifecycle.EmptyLifecycleCallback;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowConstruct
extends AbstractExecutableComponent
implements FlowConstruct,
Lifecycle {
    public static final String FLOW_FLOW_CONSTRUCT_TYPE = "Flow";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFlowConstruct.class);
    private final FlowConstructLifecycleManager lifecycleManager;
    private final String name;
    private final FlowExceptionHandler exceptionListener;
    private volatile FlowConstructStatistics statistics;
    protected FlowStoppedPersistenceListener flowStoppedPersistenceListener;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private final String initialState;

    public AbstractFlowConstruct(String name, MuleContext muleContext, Optional<FlowExceptionHandler> exceptionListener, String initialState, FlowConstructStatistics statistics) {
        this.muleContext = muleContext;
        this.name = name;
        this.exceptionListener = exceptionListener.orElseGet(() -> muleContext.getDefaultErrorHandler(Optional.of(name)));
        this.initialState = initialState;
        try {
            this.lifecycleManager = new FlowConstructLifecycleManager(this, ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
        this.statistics = statistics;
    }

    @Override
    public final void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase((phaseName, object) -> {
                LifecycleUtils.initialiseIfNeeded(this.exceptionListener, this.muleContext);
                this.validateConstruct();
                this.doInitialise();
            });
        }
        catch (InitialisationException e) {
            FunctionalUtils.safely(() -> this.dispose());
            throw e;
        }
        catch (MuleException e) {
            FunctionalUtils.safely(() -> this.dispose());
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public final void start() throws MuleException {
        boolean usePersistedState;
        boolean bl = usePersistedState = this.featureFlaggingService != null && this.featureFlaggingService.isEnabled(MuleRuntimeFeature.HONOUR_PERSISTED_FLOW_STATE) && this.flowStoppedPersistenceListener != null && this.flowStoppedPersistenceListener.isStatePersisted() != false;
        if (this.muleContext.isStarting() && (!usePersistedState && this.initialState.equals("stopped") || this.flowStoppedPersistenceListener != null && !this.flowStoppedPersistenceListener.shouldStart().booleanValue())) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            LOGGER.info("Flow " + this.name + " has not been started");
            return;
        }
        this.lifecycleManager.fireStartPhase((phaseName, object) -> {
            this.doStartProcessingStrategy();
            this.startIfStartable(this.exceptionListener);
            this.doStart();
        });
        if (this.flowStoppedPersistenceListener != null) {
            this.flowStoppedPersistenceListener.onStart();
        }
    }

    @Override
    public final void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase((phaseName, object) -> {
            this.doStop();
            this.stopIfStoppable(this.exceptionListener);
            this.doStopProcessingStrategy();
        });
        if (this.flowStoppedPersistenceListener != null) {
            this.flowStoppedPersistenceListener.onStop();
        }
    }

    @Override
    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase((phaseName, object) -> {
                this.disposeIfDisposable(this.exceptionListener);
                this.doDispose();
            });
        }
        catch (MuleException e) {
            LOGGER.error("Failed to stop service: " + this.name, (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FlowExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public String getInitialState() {
        return this.initialState;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    protected void doInitialise() throws MuleException {
        if (this.exceptionListener instanceof ErrorHandler) {
            ((ErrorHandler)this.exceptionListener).setStatistics(this.statistics);
        }
    }

    public static FlowConstructStatistics createFlowStatistics(String flowName, AllStatistics statistics) {
        DefaultFlowConstructStatistics flowStatistics = new DefaultFlowConstructStatistics(FLOW_FLOW_CONSTRUCT_TYPE, flowName);
        flowStatistics.setEnabled(statistics.isEnabled());
        statistics.add(flowStatistics);
        return flowStatistics;
    }

    protected void doStartProcessingStrategy() throws MuleException {
    }

    protected void doInitialiseProcessingStrategy() throws MuleException {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStopProcessingStrategy() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
        this.muleContext.getStatistics().remove(this.statistics);
        this.statistics = null;
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        if (this.exceptionListener instanceof MessagingExceptionHandlerAcceptor && !((MessagingExceptionHandlerAcceptor)this.exceptionListener).acceptsAll()) {
            throw new FlowConstructInvalidException(I18nMessageFactory.createStaticMessage("Flow exception listener contains an exception strategy that doesn't handle all request, Perhaps there's an exception strategy with a when attribute set but it's not part of a catch exception strategy"), this);
        }
    }

    @Override
    public String getUniqueIdString() {
        return this.muleContext.getUniqueIdString();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getId();
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    protected void startIfStartable(Object candidate) throws MuleException {
        LifecycleUtils.startIfNeeded(candidate);
    }

    protected void stopIfStoppable(Object candidate) throws MuleException {
        LifecycleUtils.stopIfNeeded(candidate);
    }

    protected void disposeIfDisposable(Object candidate) {
        LifecycleUtils.disposeIfNeeded(candidate, LOGGER);
    }

    public void addFlowStoppedListener(FlowStoppedPersistenceListener flowStoppedPersistenceListener) {
        this.flowStoppedPersistenceListener = flowStoppedPersistenceListener;
    }

    public void doNotPersist() {
        if (this.flowStoppedPersistenceListener != null) {
            this.flowStoppedPersistenceListener.doNotPersist();
        }
    }
}

