/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import javax.transaction.TransactionManager;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeginAndResolveTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeginAndResolveTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;
    private final String applicationName;
    private final SingleResourceTransactionFactoryManager transactionFactoryManager;
    private final TransactionManager transactionManager;
    private final NotificationDispatcher notificationDispatcher;
    private final boolean processOnException;
    private final boolean mustResolveAnyTransaction;
    private final boolean errorAtTimeout;

    public BeginAndResolveTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig, String applicationName, NotificationDispatcher notificationDispatcher, SingleResourceTransactionFactoryManager transactionFactoryManager, TransactionManager transactionManager, boolean processOnException, boolean mustResolveAnyTransaction, boolean errorAtTimeout) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.applicationName = applicationName;
        this.notificationDispatcher = notificationDispatcher;
        this.transactionFactoryManager = transactionFactoryManager;
        this.transactionManager = transactionManager;
        this.processOnException = processOnException;
        this.mustResolveAnyTransaction = mustResolveAnyTransaction;
        this.errorAtTimeout = errorAtTimeout;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        byte action = this.transactionConfig.getAction();
        int timeout = this.transactionConfig.getTimeout();
        boolean resolveStartedTransaction = false;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 1 || action == 2 && tx == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Beginning transaction");
            }
            executionContext.markTransactionStart();
            tx = this.transactionConfig.getFactory().beginTransaction(this.applicationName, this.notificationDispatcher, this.transactionFactoryManager, this.transactionManager);
            tx.setTimeout(timeout);
            if (tx instanceof TransactionAdapter) {
                ((TransactionAdapter)tx).setRollbackIfTimeout(this.errorAtTimeout);
            }
            resolveStartedTransaction = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction successfully started: " + tx);
            }
        }
        try {
            T result = this.next.execute(callback, executionContext);
            this.resolveTransactionIfRequired(resolveStartedTransaction);
            return result;
        }
        catch (MessagingException e) {
            if (this.processOnException) {
                this.rollbackTransactionIfRequired(resolveStartedTransaction || this.mustResolveAnyTransaction);
            }
            throw e;
        }
    }

    private void rollbackTransactionIfRequired(boolean mustResolveTransaction) {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
    }

    private void resolveTransactionIfRequired(boolean mustResolveTransaction) throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
    }
}

