/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.source.scheduler;

import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.FlowProcessingTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.core.internal.source.scheduler.DefaultSchedulerMessageSource;

final class SchedulerFlowProcessingTemplate
extends FlowProcessingTemplate {
    private final DefaultSchedulerMessageSource defaultSchedulerMessageSource;
    private final FeatureFlaggingService featureFlaggingService;

    SchedulerFlowProcessingTemplate(Processor messageProcessor, List<NotificationFunction> notificationFunctions, DefaultSchedulerMessageSource defaultSchedulerMessageSource, FeatureFlaggingService featureFlaggingService) {
        super(messageProcessor, notificationFunctions);
        this.defaultSchedulerMessageSource = defaultSchedulerMessageSource;
        this.featureFlaggingService = featureFlaggingService;
    }

    @Override
    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
        this.defaultSchedulerMessageSource.setIsExecuting(false);
    }

    @Override
    public void sendResponseToClient(CoreEvent response, Map<String, Object> parameters, CompletableCallback<Void> callback) {
        callback.complete(null);
    }

    @Override
    public void sendFailureResponseToClient(MessagingException exception, Map<String, Object> parameters, CompletableCallback<Void> callback) {
        if (this.featureFlaggingService != null && this.featureFlaggingService.isEnabled(MuleRuntimeFeature.DISABLE_SCHEDULER_LOGGING)) {
            exception.getExceptionInfo().setAlreadyLogged(true);
        }
        callback.error(exception);
    }
}

