/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.IOUtils;

@NoExtend
@NoInstantiate
public final class ConfigResource {
    private static final List<String> CLASS_PATH_ENTRIES = Arrays.asList(System.getProperty("java.class.path").split(":"));
    protected String resourceName;
    private URL url;
    private InputStream inputStream;

    public ConfigResource(String resourceName) throws IOException {
        this.resourceName = resourceName;
        this.url = IOUtils.getResourceAsUrl(resourceName, this.getClass(), true, true);
        if (this.url == null) {
            throw new FileNotFoundException(resourceName);
        }
    }

    public ConfigResource(URL url) {
        this.url = url;
        this.resourceName = url.getProtocol().equals("jar") ? url.toExternalForm().split("!/")[1] : (url.getProtocol().equals("file") ? CLASS_PATH_ENTRIES.stream().filter(cp -> url.getPath().startsWith((String)cp)).findAny().map(cp -> url.getPath().substring(cp.length() + 1)).orElse(url.toExternalForm()) : url.toExternalForm());
    }

    public ConfigResource(String resourceName, InputStream inputStream) {
        this.inputStream = inputStream;
        this.resourceName = resourceName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null && this.url != null) {
            this.inputStream = this.url.openStream();
        }
        return this.inputStream;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isStreamOpen() {
        return this.inputStream != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigResource that = (ConfigResource)o;
        return !(this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigResource");
        sb.append("{resourceName='").append(this.resourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

