/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.node;

import java.io.Serializable;
import java.util.Arrays;
import org.mule.weave.v2.interpreted.ExecutionContext;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.Types$;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.FunctionValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class FunctionDispatchingHelper$ {
    public static FunctionDispatchingHelper$ MODULE$;

    static {
        new FunctionDispatchingHelper$();
    }

    /*
     * WARNING - void declaration
     */
    public FunctionValue[] allTargets(FunctionValue functionValue) {
        FunctionValue[] functionValueArray;
        if (functionValue.isOverloaded()) {
            functionValueArray = functionValue.overloads();
        } else {
            void var2_2;
            FunctionValue[] result = new FunctionValue[]{functionValue};
            functionValueArray = var2_2;
        }
        return functionValueArray;
    }

    public Option<Tuple2<Object, FunctionValue>> findMatchingFunction(Value<Object>[] arguments, FunctionValue[] options, EvaluationContext ctx) {
        for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
            FunctionValue functionValue = options[optionIndex];
            boolean matchesTypes = this.matchesFunctionTypes(functionValue, arguments, ctx);
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)optionIndex), (Object)functionValue));
        }
        return None$.MODULE$;
    }

    public Option<Tuple3<Object, Value<?>[], Seq<Object>>> findMatchingFunctionWithCoercion(Value<Object>[] arguments, FunctionValue[] options, WeaveLocationCapable weaveLocationCapable, EvaluationContext ctx) {
        Value[] coercedValues = new Value[arguments.length];
        for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
            FunctionValue function = options[optionIndex];
            if (function.minParams() > arguments.length || function.maxParams() < arguments.length) continue;
            boolean matchesTypes = true;
            Type[] functionParamTypes = function.parameterTypes();
            ArrayBuffer paramsThatAreCoerced = new ArrayBuffer();
            for (int index = 0; arguments.length > index && matchesTypes; ++index) {
                BoxedUnit boxedUnit;
                Type expectedType = functionParamTypes[index];
                if (!expectedType.accepts(arguments[index], ctx)) {
                    try {
                        coercedValues[index] = expectedType.coerce(arguments[index], weaveLocationCapable, ctx);
                        boxedUnit = paramsThatAreCoerced.$plus$eq((Object)BoxesRunTime.boxToInteger((int)index));
                    }
                    catch (Exception exception) {
                        matchesTypes = false;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    continue;
                }
                coercedValues[index] = arguments[index];
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)optionIndex), (Object)coercedValues, (Object)paramsThatAreCoerced));
        }
        return None$.MODULE$;
    }

    public int indexOfFunction(FunctionValue[] options, FunctionValue possible) {
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != possible) continue;
            return i;
        }
        return -1;
    }

    public Value<Object>[] materializeArgs(FunctionParameter[] parameters, Value<Object>[] arguments, ExecutionContext ctx) {
        Iterator argsIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arguments)).iterator();
        int index = 0;
        Value[] result = new Value[arguments.length];
        while (argsIterator.hasNext()) {
            Value newArg;
            Value arg = (Value)argsIterator.next();
            result[index] = newArg = parameters[index].typeRequiresMaterialization() ? arg.materialize(ctx) : arg;
            ++index;
        }
        return result;
    }

    public Value<Object>[] materializeOverloadedFunctionArgs(FunctionValue[] overloads, Value<Object>[] arguments, EvaluationContext ctx) {
        Value[] result = new Value[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            Value<Object> newArg;
            Value<Object> arg = arguments[index];
            result[index] = newArg = this.materializeOverloadedFunctionArgs(overloads, index, arg, ctx);
        }
        return result;
    }

    public Value<Object> materializeOverloadedFunctionArgs(FunctionValue[] overloads, int argumentIndex, Value<Object> argument, EvaluationContext ctx) {
        boolean requiresMaterialize = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])overloads)).exists((Function1 & Serializable & scala.Serializable)fun -> BoxesRunTime.boxToBoolean((boolean)FunctionDispatchingHelper$.$anonfun$materializeOverloadedFunctionArgs$1(argumentIndex, fun)));
        Value<Object> newArg = requiresMaterialize ? argument.materialize(ctx) : argument;
        return newArg;
    }

    public FunctionValue[] sortByParameterTypeWeight(FunctionValue[] functionOverloads, Type[] argTypes, EvaluationContext ctx) {
        Tuple3[] weightFunctions = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functionOverloads)).map((Function1 & Serializable & scala.Serializable)operator -> {
            Type[] parameterTypes = (Type[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operator.parameters())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.wtype(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Type.class)));
            DoubleRef weight = DoubleRef.create((double)0.0);
            IntRef miss = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterTypes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])argTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)paramTypeArgType -> {
                FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$3(ctx, miss, weight, paramTypeArgType);
                return BoxedUnit.UNIT;
            });
            return new Tuple3(operator, (Object)BoxesRunTime.boxToDouble((double)weight.elem), (Object)BoxesRunTime.boxToInteger((int)miss.elem));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        FunctionValue[] sortedOperators = (FunctionValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])weightFunctions)).sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$4(v)), (Ordering)Ordering.Double$.MODULE$))).sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$5(v)), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)v -> (FunctionValue)v._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FunctionValue.class)));
        return sortedOperators;
    }

    public Value<?>[] tryToCoerceOnly(Value<?>[] args, FunctionValue dispatch, Seq<Object> paramIndexToCoerce, EvaluationContext ctx) {
        Value[] result = (Value[])args.clone();
        Type[] parameterTypes = dispatch.parameterTypes();
        for (int i = 0; paramIndexToCoerce.length() > i; ++i) {
            Value<?> arg;
            int paramIndex = BoxesRunTime.unboxToInt((Object)paramIndexToCoerce.apply(i));
            Type expectedType = parameterTypes[paramIndex];
            Option<Value> valueMaybe = expectedType.coerceMaybe(arg = args[paramIndex], ctx);
            if (!valueMaybe.isDefined()) {
                return null;
            }
            result[paramIndex] = (Value)valueMaybe.get();
        }
        return result;
    }

    public Option<Value<?>[]> tryToCoerce(Value<?>[] argumentsWithDefaults, FunctionValue dispatch, EvaluationContext ctx) {
        Value[] result = new Value[dispatch.parameters().length];
        for (int i = 0; dispatch.parameters().length > i; ++i) {
            Value<?> value;
            Type expectedType = dispatch.parameters()[i].wtype();
            if (!expectedType.accepts(value = argumentsWithDefaults[i], ctx)) {
                Option<Value> valueMaybe = expectedType.coerceMaybe(value, ctx);
                if (valueMaybe.isDefined()) {
                    result[i] = (Value)valueMaybe.get();
                    continue;
                }
                return None$.MODULE$;
            }
            result[i] = value;
        }
        return new Some((Object)result);
    }

    public boolean matchesFunctionTypes(FunctionValue functionValue, Value<Object>[] arguments, EvaluationContext ctx) {
        return this.matchesParameters(functionValue.parameters(), functionValue.parameterTypes(), arguments, ctx);
    }

    public boolean matchesParameters(FunctionParameter[] parameters, Type[] paramTypes, Value<Object>[] arguments, EvaluationContext ctx) {
        boolean matchesTypes = true;
        if (parameters.length == arguments.length) {
            matchesTypes = Types$.MODULE$.validate(paramTypes, arguments, ctx);
        } else if (arguments.length > parameters.length) {
            matchesTypes = false;
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).nonEmpty() && ((FunctionParameter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).head()).value().nonEmpty()) {
            int delta = parameters.length - arguments.length;
            FunctionParameter[] requireDefaultValue = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, 0, delta);
            FunctionParameter[] needsToCheck = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, delta, parameters.length);
            Type[] needsToCheckTypes = (Type[])Arrays.copyOfRange((Object[])paramTypes, delta, parameters.length);
            matchesTypes = this.validateDefaultValue(requireDefaultValue) && this.matchesParameters(needsToCheck, needsToCheckTypes, arguments, ctx);
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).nonEmpty() && ((FunctionParameter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).last()).value().nonEmpty()) {
            int delta = parameters.length - arguments.length;
            FunctionParameter[] requireDefaultValue = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, delta, parameters.length);
            FunctionParameter[] needsToCheck = (FunctionParameter[])Arrays.copyOfRange((Object[])parameters, 0, delta);
            Type[] needsToCheckTypes = (Type[])Arrays.copyOfRange((Object[])paramTypes, 0, delta);
            matchesTypes = this.validateDefaultValue(requireDefaultValue) && this.matchesParameters(needsToCheck, needsToCheckTypes, arguments, ctx);
        } else {
            matchesTypes = false;
        }
        return matchesTypes;
    }

    private boolean validateDefaultValue(FunctionParameter[] requireDefaultValue) {
        for (int i = 0; i < requireDefaultValue.length; ++i) {
            if (!requireDefaultValue[i].value().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final Value<?>[] expandArguments(Value<?>[] arguments, FunctionValue function, EvaluationContext ctx) {
        return FunctionValue$.MODULE$.expandArguments(arguments, function, ctx);
    }

    public static final /* synthetic */ boolean $anonfun$materializeOverloadedFunctionArgs$1(int argumentIndex$1, FunctionValue fun) {
        return fun.parameters().length > argumentIndex$1 ? fun.parameters()[argumentIndex$1].typeRequiresMaterialization() : false;
    }

    public static final /* synthetic */ void $anonfun$sortByParameterTypeWeight$3(EvaluationContext ctx$1, IntRef miss$1, DoubleRef weight$1, Tuple2 paramTypeArgType) {
        block0: {
            if (((Type)paramTypeArgType._2()).isInstanceOf((Type)paramTypeArgType._1(), ctx$1)) break block0;
            ++miss$1.elem;
            weight$1.elem += (double)((Type)paramTypeArgType._1()).weight(ctx$1);
        }
    }

    public static final /* synthetic */ double $anonfun$sortByParameterTypeWeight$4(Tuple3 v) {
        return BoxesRunTime.unboxToDouble((Object)v._2());
    }

    public static final /* synthetic */ int $anonfun$sortByParameterTypeWeight$5(Tuple3 v) {
        return BoxesRunTime.unboxToInt((Object)v._3());
    }

    private FunctionDispatchingHelper$() {
        MODULE$ = this;
    }
}

