/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.xml.reader.indexed;

public final class LongUtils$ {
    public static LongUtils$ MODULE$;

    static {
        new LongUtils$();
    }

    public long parseUnsignedLong(String s, int radix) {
        long result;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = Long.parseLong(s.substring(0, len - 1), radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException(new StringBuilder(20).append("Bad digit at end of ").append(s).toString());
            }
            result = first * (long)radix + (long)second;
            if (this.compareUnsigned(result, first) < 0) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
        } else {
            throw new NumberFormatException(new StringBuilder(20).append("For input string: \"").append(s).append("\"").toString());
        }
        return result;
    }

    public int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    private LongUtils$() {
        MODULE$ = this;
    }
}

