/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import scala.Option;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4Aa\u0004\t\u0001C!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"B\u001f\u0001\t\u0003q\u0004\"B)\u0001\t\u0003\u0011\u0006\"\u0002-\u0001\t\u0003I\u0006\"B.\u0001\t\u0003a\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"\u00025\u0001\t\u0003I\u0007\"B6\u0001\t\u0013a\u0007\"B7\u0001\t\u0003q'!E\"T-N+G\u000f^5oONDU\r\u001c9fe*\u0011\u0011CE\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005M!\u0012A\u0002:fC\u0012,'O\u0003\u0002\u0016-\u0005\u00191m\u001d<\u000b\u0005]A\u0012AB7pIVdWM\u0003\u0002\u001a5\u0005\u0011aO\r\u0006\u00037q\tQa^3bm\u0016T!!\b\u0010\u0002\t5,H.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0017\r\u001choU3ui&twm]\u000b\u0002UA\u00111\u0006L\u0007\u0002!%\u0011Q\u0006\u0005\u0002\f\u0007N36+\u001a;uS:<7/\u0001\u0007dgZ\u001cV\r\u001e;j]\u001e\u001c\b%A\btKR$\u0018N\\4t'\u0016\u0014h/[2f!\t\td'D\u00013\u0015\t\u0019D'A\u0004tKJ4\u0018nY3\u000b\u0005UB\u0012!B7pI\u0016d\u0017BA\u001c3\u0005=\u0019V\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0002;wq\u0002\"a\u000b\u0001\t\u000b!\"\u0001\u0019\u0001\u0016\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\u0011UtWm]2ba\u0016$2a\u0010&M!\t\u0001uI\u0004\u0002B\u000bB\u0011!\tJ\u0007\u0002\u0007*\u0011A\tI\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019#\u0013A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!A\u0012\u0013\t\u000b-+\u0001\u0019A \u0002\u000bY\fG.^3\t\u000b5+\u0001\u0019\u0001(\u0002\u0011%\u001c\u0018+^8uK\u0012\u0004\"aI(\n\u0005A##a\u0002\"p_2,\u0017M\\\u0001\u0017e\u0016\fX/\u001b:fg\u0016\u001b8-\u00199f\u0013:\fVo\u001c;fIR\u0011aj\u0015\u0005\u0006)\u001a\u0001\r!V\u0001\u0005G\"\f'\u000f\u0005\u0002$-&\u0011q\u000b\n\u0002\u0005\u0007\"\f'/\u0001\bsKF,\u0018N]3t\u000bN\u001c\u0017\r]3\u0015\u00059S\u0006\"\u0002+\b\u0001\u0004)\u0016\u0001D5t\u0019&tW-\u00128eS:<GC\u0001(^\u0011\u0015q\u0006\u00021\u0001V\u0003\u0005\u0019\u0017aC5t#V|G/Z\"iCJ$\"AT1\t\u000byK\u0001\u0019A+\u0002#%\u001c8i\u001c7v[:\u001cV\r]1sCR|'\u000f\u0006\u0002OI\")aL\u0003a\u0001+\u0006a\u0011n]#tG\u0006\u0004Xm\u00115beR\u0011aj\u001a\u0005\u0006=.\u0001\r!V\u0001\u0015KN\u001c\u0017\r]3V]F,x\u000e^3e'R\u0014\u0018N\\4\u0015\u0005}R\u0007\"B&\r\u0001\u0004y\u0014AE1mo\u0006L8/R:dCB,\u0017+^8uKN$\u0012AT\u0001\u0013KN\u001c\u0017\r]3Rk>$X\rZ*ue&tw\r\u0006\u0002@_\")1J\u0004a\u0001\u007f\u0001")
public class CSVSettingsHelper {
    private final CSVSettings csvSettings;
    private final SettingsService settingsService;

    public CSVSettings csvSettings() {
        return this.csvSettings;
    }

    public String unescape(String value, boolean isQuoted) {
        StringBuilder result = new StringBuilder();
        char[] array = value.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            StringBuilder stringBuilder;
            boolean isEscapeAndNextIsQuote;
            char c = array[i];
            boolean bl = isEscapeAndNextIsQuote = this.isEscapeChar(c) && i + 1 < array.length && this.needsEscape$1(array[i + 1], isQuoted);
            if (!isEscapeAndNextIsQuote) {
                stringBuilder = result.append(c);
                continue;
            }
            result.append(array[i + 1]);
            ++i;
            stringBuilder = BoxedUnit.UNIT;
        }
        return result.toString();
    }

    public boolean requiresEscapeInQuoted(char c) {
        return this.csvSettings().requiresEscapeInQuoted(c);
    }

    public boolean requiresEscape(char c) {
        return this.csvSettings().requiresEscape(c);
    }

    public boolean isLineEnding(char c) {
        return this.csvSettings().isLineEnding(c);
    }

    public boolean isQuoteChar(char c) {
        return this.csvSettings().isQuoteChar(c);
    }

    public boolean isColumnSeparator(char c) {
        return this.csvSettings().isColumnSeparator(c);
    }

    public boolean isEscapeChar(char c) {
        return this.csvSettings().isEscapeChar(c);
    }

    public String escapeUnquotedString(String value) {
        StringBuilder result = new StringBuilder();
        Option<Object> maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape.isDefined()) {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isColumnSeparator(c) || this.isLineEnding(c) || this.isQuoteChar(c) && this.alwaysEscapeQuotes();
                object = needsEscaping ? result.append(BoxesRunTime.unboxToChar((Object)maybeEscape.get())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean alwaysEscapeQuotes() {
        return this.settingsService.csvWriter().alwaysEscapeQuotesInCSV();
    }

    public String escapeQuotedString(String value) {
        StringBuilder result = new StringBuilder();
        Option<Object> maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape.isDefined()) {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isQuoteChar(c);
                object = needsEscaping ? result.append(BoxesRunTime.unboxToChar((Object)maybeEscape.get())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    private final boolean needsEscape$1(char c, boolean isQuoted$1) {
        return isQuoted$1 ? this.requiresEscapeInQuoted(c) : this.requiresEscape(c);
    }

    public CSVSettingsHelper(CSVSettings csvSettings, SettingsService settingsService) {
        this.csvSettings = csvSettings;
        this.settingsService = settingsService;
    }
}

